/**
 * Load the settings for a message processor.
 *
 * @module     core_message/notification_processor_settings
 * @class      notification_processor_settings
 * @package    message
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/notification_processor_settings",["jquery","core/ajax","core/str","core/notification","core/custom_interaction_events","core/modal","core/modal_registry","core/fragment"],(function($,Ajax,Str,Notification,CustomEvents,Modal,ModalRegistry,Fragment){var registered=!1,SELECTORS_SAVE_BUTTON='[data-action="save"]',SELECTORS_CANCEL_BUTTON='[data-action="cancel"]',SELECTORS_PROCESSOR="[data-processor-name]",SELECTORS_PREFERENCE_ROW='[data-region="preference-row"]',NotificationProcessorSettings=function(root){Modal.call(this,root),this.name=null,this.userId=null,this.contextId=null,this.element=null,this.saveButton=this.getFooter().find(SELECTORS_SAVE_BUTTON),this.cancelButton=this.getFooter().find(SELECTORS_CANCEL_BUTTON)};return NotificationProcessorSettings.TYPE="core_message-notification_processor_settings",(NotificationProcessorSettings.prototype=Object.create(Modal.prototype)).constructor=NotificationProcessorSettings,NotificationProcessorSettings.prototype.setUserId=function(id){this.userId=id},NotificationProcessorSettings.prototype.getUserId=function(){return this.userId},NotificationProcessorSettings.prototype.setElement=function(element){this.element=element},NotificationProcessorSettings.prototype.getElement=function(){return this.element},NotificationProcessorSettings.prototype.setName=function(name){this.name=name},NotificationProcessorSettings.prototype.getName=function(){return this.name},NotificationProcessorSettings.prototype.setContextId=function(id){this.contextId=id},NotificationProcessorSettings.prototype.getContextId=function(){return this.contextId},NotificationProcessorSettings.prototype.getForm=function(){return this.getBody().find("form")},NotificationProcessorSettings.prototype.disableButtons=function(){this.saveButton.prop("disabled",!0),this.cancelButton.prop("disabled",!0)},NotificationProcessorSettings.prototype.enableButtons=function(){this.saveButton.prop("disabled",!1),this.cancelButton.prop("disabled",!1)},NotificationProcessorSettings.prototype.loadTitleContent=function(){return this.titlePromise=Str.get_string("processorsettings","message"),this.setTitle(this.titlePromise),this.titlePromise},NotificationProcessorSettings.prototype.loadBodyContent=function(){this.disableButtons();var args={userid:this.getUserId(),type:this.getName()};return this.bodyPromise=Fragment.loadFragment("message","processor_settings",this.getContextId(),args),this.setBody(this.bodyPromise),this.bodyPromise.then(function(){this.enableButtons()}.bind(this)).fail(Notification.exception),this.bodyPromise},NotificationProcessorSettings.prototype.loadAllContent=function(){return $.when(this.loadTitleContent(),this.loadBodyContent())},NotificationProcessorSettings.prototype.show=function(){this.loadAllContent(),Modal.prototype.show.call(this)},NotificationProcessorSettings.prototype.hide=function(){Modal.prototype.hide.call(this),this.setContextId(null),this.setName(null),this.setUserId(null)},NotificationProcessorSettings.prototype.updateConfiguredStatus=function(){var processorHeader=$(this.getElement()).closest(SELECTORS_PROCESSOR);if(!processorHeader.hasClass("unconfigured"))return!1;var processorName=processorHeader.attr("data-processor-name"),request={methodname:"core_message_get_message_processor",args:{name:processorName,userid:this.userId}};return Ajax.call([request])[0].fail(Notification.exception).done((function(result){if(result.userconfigured){var notifications=$(SELECTORS_PREFERENCE_ROW+' [data-processor-name="'+processorName+'"]');processorHeader.removeClass("unconfigured"),notifications.removeClass("disabled")}}))},NotificationProcessorSettings.prototype.registerEventListeners=function(){Modal.prototype.registerEventListeners.call(this),this.getModal().on(CustomEvents.events.activate,SELECTORS_SAVE_BUTTON,function(e,data){this.getForm().submit(),data.originalEvent.preventDefault()}.bind(this)),this.getModal().on("mpp:formsubmitted",function(e){this.hide(),this.updateConfiguredStatus(),e.stopPropagation()}.bind(this)),this.getModal().on(CustomEvents.events.activate,SELECTORS_CANCEL_BUTTON,function(e,data){this.hide(),data.originalEvent.preventDefault(),e.stopPropagation()}.bind(this))},registered||(ModalRegistry.register(NotificationProcessorSettings.TYPE,NotificationProcessorSettings,"core/modal_save_cancel"),registered=!0),NotificationProcessorSettings}));

//# sourceMappingURL=notification_processor_settings.min.js.map