define("core_contentbank/sort",["exports","./selectors","core/str","core/prefetch","core/ajax","core/notification"],(function(_exports,_selectors,_str,_prefetch,_ajax,_notification){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Content bank UI actions.
   *
   * @module     core_contentbank/sort
   * @package    core_contentbank
   * @copyright  2020 Bas Brands <bas@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_selectors=_interopRequireDefault(_selectors),_prefetch=_interopRequireDefault(_prefetch),_ajax=_interopRequireDefault(_ajax),_notification=_interopRequireDefault(_notification);_exports.init=function(){var contentBank=document.querySelector(_selectors.default.regions.contentbank);_prefetch.default.prefetchStrings("contentbank",["contentname","lastmodified","size","type"]),_prefetch.default.prefetchStrings("moodle",["sortbyx","sortbyxreverse"]),registerListenerEvents(contentBank)};var registerListenerEvents=function(contentBank){var fileArea=document.querySelector(_selectors.default.regions.filearea),shownItems=fileArea.querySelectorAll(_selectors.default.elements.listitem),viewGrid=contentBank.querySelector(_selectors.default.actions.viewgrid),viewList=contentBank.querySelector(_selectors.default.actions.viewlist);viewGrid.addEventListener("click",(function(){contentBank.classList.remove("view-list"),contentBank.classList.add("view-grid"),viewGrid.classList.add("active"),viewList.classList.remove("active"),setViewListPreference(!1)})),viewList.addEventListener("click",(function(){contentBank.classList.remove("view-grid"),contentBank.classList.add("view-list"),viewList.classList.add("active"),viewGrid.classList.remove("active"),setViewListPreference(!0)}));var sortByName=contentBank.querySelector(_selectors.default.actions.sortname);sortByName.addEventListener("click",(function(){var ascending=updateSortButtons(contentBank,sortByName);updateSortOrder(fileArea,shownItems,"data-file",ascending)}));var sortByDate=contentBank.querySelector(_selectors.default.actions.sortdate);sortByDate.addEventListener("click",(function(){var ascending=updateSortButtons(contentBank,sortByDate);updateSortOrder(fileArea,shownItems,"data-timemodified",ascending)}));var sortBySize=contentBank.querySelector(_selectors.default.actions.sortsize);sortBySize.addEventListener("click",(function(){var ascending=updateSortButtons(contentBank,sortBySize);updateSortOrder(fileArea,shownItems,"data-bytes",ascending)}));var sortByType=contentBank.querySelector(_selectors.default.actions.sorttype);sortByType.addEventListener("click",(function(){var ascending=updateSortButtons(contentBank,sortByType);updateSortOrder(fileArea,shownItems,"data-type",ascending)}))},setViewListPreference=function(viewList){!1===viewList&&(viewList=null);var request={methodname:"core_user_update_user_preferences",args:{preferences:[{type:"core_contentbank_view_list",value:viewList}]}};return _ajax.default.call([request])[0].catch(_notification.default.exception)},updateSortButtons=function(contentBank,sortButton){contentBank.querySelectorAll(_selectors.default.elements.sortbutton).forEach((function(button){button!==sortButton&&(button.classList.remove("dir-asc"),button.classList.remove("dir-desc"),button.classList.add("dir-none"),updateButtonTitle(button,!1))}));var ascending=!0;return sortButton.classList.contains("dir-none")?(sortButton.classList.remove("dir-none"),sortButton.classList.add("dir-asc")):sortButton.classList.contains("dir-asc")?(sortButton.classList.remove("dir-asc"),sortButton.classList.add("dir-desc"),ascending=!1):sortButton.classList.contains("dir-desc")&&(sortButton.classList.remove("dir-desc"),sortButton.classList.add("dir-asc")),updateButtonTitle(sortButton,ascending),ascending},updateButtonTitle=function(button,ascending){var sortString=ascending?"sortbyxreverse":"sortbyx";return(0,_str.get_string)(button.dataset.string,"contentbank").then((function(columnName){return(0,_str.get_string)(sortString,"core",columnName)})).then((function(sortByString){return button.setAttribute("title",sortByString),sortByString})).catch()},updateSortOrder=function(fileArea,itemList,attribute,ascending){[].slice.call(itemList).sort((function(a,b){var aa=a.getAttribute(attribute),bb=b.getAttribute(attribute);return isNaN(aa)||(aa=parseInt(aa),bb=parseInt(bb)),ascending?aa>bb?1:-1:aa<bb?1:-1})).forEach((function(listItem){return fileArea.appendChild(listItem)}))}}));

//# sourceMappingURL=sort.min.js.map