/**
 * Manage the timeline courses view for the timeline block.
 *
 * @package    block_timeline
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("block_timeline/view_courses",["jquery","core/notification","core/custom_interaction_events","core/str","core/templates","block_timeline/event_list","core_course/repository","block_timeline/calendar_events_repository"],(function($,Notification,CustomEvents,Str,Templates,EventList,CourseRepository,EventsRepository){var SELECTORS_MORE_COURSES_BUTTON='[data-action="more-courses"]',SELECTORS_MORE_COURSES_BUTTON_CONTAINER='[data-region="more-courses-button-container"]',SELECTORS_NO_COURSES_EMPTY_MESSAGE='[data-region="no-courses-empty-message"]',SELECTORS_COURSES_LIST='[data-region="courses-list"]',SELECTORS_COURSE_ITEMS_LOADING_PLACEHOLDER='[data-region="course-items-loading-placeholder"]',SELECTORS_COURSE_EVENTS_CONTAINER='[data-region="course-events-container"]',SELECTORS_COURSE_NAME='[data-region="course-name"]',SELECTORS_LOADING_ICON=".loading-icon",TEMPLATES_COURSE_ITEMS="block_timeline/course-items",TEMPLATES_LOADING_ICON="core/loading",hideLoadingPlaceholder=function(root){root.find(SELECTORS_COURSE_ITEMS_LOADING_PLACEHOLDER).addClass("hidden")},disableMoreCoursesButtonLoading=function(root){var button=root.find(SELECTORS_MORE_COURSES_BUTTON);button.prop("disabled",!1),button.find(SELECTORS_LOADING_ICON).remove()},hasLoadedCourses=function(root){return root.find(SELECTORS_COURSE_EVENTS_CONTAINER).length>0},getDaysOffset=function(root){return parseInt(root.attr("data-days-offset"),10)},getDaysLimit=function(root){var daysLimit=root.attr("data-days-limit");return null!=daysLimit?parseInt(daysLimit,10):void 0},getMidnight=function(root){return parseInt(root.attr("data-midnight"),10)},getStartTime=function(root){return getMidnight(root)+86400*getDaysOffset(root)},getEndTime=function(root){var midnight=getMidnight(root),daysLimit=getDaysLimit(root);return null!=daysLimit&&midnight+86400*daysLimit},getEventsForCourseIds=function(courseIds,startTime,limit,endTime){var args={courseids:courseIds,starttime:startTime,limit:limit};return endTime&&(args.endtime=endTime),EventsRepository.queryByCourses(args)},setEventReloadTime=function(root,time){root.data("last-event-load-time",time)},hasReloadedEventsSince=function(root,time){return function(root){return root.data("last-event-load-time")}(root)>time},updateDisplayFromCourses=function(courses,root,midnight,daysOffset,daysLimit,noEventsURL){return Templates.render(TEMPLATES_COURSE_ITEMS,{courses:courses,midnight:midnight,hasdaysoffset:!0,hasdayslimit:null!=daysLimit,daysoffset:daysOffset,dayslimit:daysLimit,nodayslimit:null==daysLimit,urls:{noevents:noEventsURL}}).then((function(html){return hideLoadingPlaceholder(root),html?function(root,html){var container=root.find(SELECTORS_COURSES_LIST);Templates.appendNodeContents(container,html,"")}(root,html):hasLoadedCourses(root)||function(root){root.find(SELECTORS_NO_COURSES_EMPTY_MESSAGE).removeClass("hidden")}(root),html})).then((function(html){return courses.length<2?function(root){root.find(SELECTORS_MORE_COURSES_BUTTON_CONTAINER).addClass("hidden")}(root):function(root){root.find(SELECTORS_MORE_COURSES_BUTTON_CONTAINER).removeClass("hidden")}(root),html})).catch((function(){hideLoadingPlaceholder(root)}))},loadMoreCourses=function(root){var offset=function(root){return parseInt(root.attr("data-offset"),10)}(root),limit=function(root){return parseInt(root.attr("data-limit"),10)}(root);return CourseRepository.getEnrolledCoursesByTimelineClassification("inprogress",limit,offset,"fullname asc").then((function(result){var startEventLoadingTime=Date.now(),courses=result.courses,nextOffset=result.nextoffset,daysOffset=getDaysOffset(root),daysLimit=getDaysLimit(root),midnight=getMidnight(root),startTime=getStartTime(root),endTime=getEndTime(root),noEventsURL=root.attr("data-no-events-url");!function(root,offset){root.attr("data-offset",offset)}(root,nextOffset);var eventsPromise=function(courses,startTime,endTime){var courseIds=courses.map((function(course){return course.id}));return getEventsForCourseIds(courseIds,startTime,6,endTime)}(courses,startTime,endTime),renderPromise=updateDisplayFromCourses(courses,root,midnight,daysOffset,daysLimit,noEventsURL);return $.when(eventsPromise,renderPromise).then((function(eventsByCourse){return hasReloadedEventsSince(root,startEventLoadingTime)||courses.forEach((function(course){var courseId=course.id,events=[],containerSelector='[data-region="course-events-container"][data-course-id="'+courseId+'"]',eventListRoot=root.find(containerSelector).find(EventList.rootSelector),courseGroups=eventsByCourse.groupedbycourse.filter((function(group){return group.courseid==courseId}));courseGroups.length&&(events=courseGroups[0].events);var pageOnePreload=$.Deferred().resolve({events:events}).promise();Str.get_string("ariaeventlistpaginationnavcourses","block_timeline",course.fullnamedisplay).then((function(string){return EventList.init(eventListRoot,5,{1:pageOnePreload},string),string})).catch((function(){EventList.init(eventListRoot,5,{1:pageOnePreload})}))})),eventsByCourse}))})).catch(Notification.exception)},registerEventListeners=function(root){CustomEvents.define(root,[CustomEvents.events.activate]),root.on(CustomEvents.events.activate,SELECTORS_MORE_COURSES_BUTTON,(function(e,data){!function(root){var button=root.find(SELECTORS_MORE_COURSES_BUTTON);button.prop("disabled",!0),Templates.render(TEMPLATES_LOADING_ICON,{}).then((function(html){return button.append(html),html})).catch((function(){return!1}))}(root),loadMoreCourses(root).then((function(){disableMoreCoursesButtonLoading(root)})).catch((function(){disableMoreCoursesButtonLoading(root)})),data&&(data.originalEvent.preventDefault(),data.originalEvent.stopPropagation()),e.stopPropagation()}))},shown=function(root){root.attr("data-seen")||(hasLoadedCourses(root)?function(root){var startReloadTime=Date.now(),startTime=getStartTime(root),endTime=getEndTime(root),courseEventsContainers=root.find(SELECTORS_COURSE_EVENTS_CONTAINER),courseIds=courseEventsContainers.map((function(){return $(this).attr("data-course-id")})).get();setEventReloadTime(root,startReloadTime),getEventsForCourseIds(courseIds,startTime,6,endTime).then((function(eventsByCourse){return hasReloadedEventsSince(root,startReloadTime)||courseEventsContainers.each((function(index,container){var courseId=(container=$(container)).attr("data-course-id"),courseName=container.find(SELECTORS_COURSE_NAME).text(),eventListContainer=container.find(EventList.rootSelector),pageDeferred=$.Deferred(),events=[],courseGroups=eventsByCourse.groupedbycourse.filter((function(group){return group.courseid==courseId}));courseGroups.length&&(events=courseGroups[0].events),pageDeferred.resolve({events:events}),Str.get_string("ariaeventlistpaginationnavcourses","block_timeline",courseName).then((function(string){return EventList.init(eventListContainer,5,{1:pageDeferred.promise()},string),string})).catch((function(){EventList.init(eventListContainer,5,{1:pageDeferred.promise()})}))})),eventsByCourse})).catch(Notification.exception)}(root):loadMoreCourses(root),root.attr("data-seen",!0))};return{init:function(root){root=$(root),setEventReloadTime(root,Date.now()),root.hasClass("active")&&(loadMoreCourses(root),root.attr("data-seen",!0)),registerEventListeners(root)},reset:function(root){root.removeAttr("data-seen"),root.hasClass("active")&&shown(root)},shown:shown}}));

//# sourceMappingURL=view_courses.min.js.map