/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

CREATE TABLE IF NOT EXISTS `activities` (
  `activitiesID` int(11) NOT NULL AUTO_INCREMENT,
  `activitiescategoryID` int(11) NOT NULL,
  `description` text NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `time_to` varchar(40) DEFAULT NULL,
  `time_from` varchar(40) DEFAULT NULL,
  `time_at` varchar(40) DEFAULT NULL,
  `usertypeID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  PRIMARY KEY (`activitiesID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` (`activitiesID`, `activitiescategoryID`, `description`, `create_date`, `modify_date`, `time_to`, `time_from`, `time_at`, `usertypeID`, `userID`, `schoolyearID`) VALUES
	(1, 6, 'EL NIÑO ES MENOR', '2019-04-24 11:39:47', '2019-04-24 11:39:47', '11:40:00', '11:40:00', '11:40:00', 1, 1, 1),
	(2, 3, 'LOS NIÑOS DUERMEN DESDE LAS 8PM', '2019-04-24 11:40:19', '2019-04-24 11:40:19', '11:40:00', '11:40:00', '11:40:00', 1, 1, 1),
	(3, 2, 'SOPA DE VERDURAS', '2019-04-24 11:40:56', '2019-04-24 11:40:56', '11:40:00', '11:40:00', '11:40:00', 1, 1, 1);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `activitiescategory` (
  `activitiescategoryID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `fa_icon` varchar(40) DEFAULT NULL,
  `schoolyearID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(40) NOT NULL,
  PRIMARY KEY (`activitiescategoryID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `activitiescategory` DISABLE KEYS */;
INSERT INTO `activitiescategory` (`activitiescategoryID`, `title`, `fa_icon`, `schoolyearID`, `create_date`, `modify_date`, `userID`, `usertypeID`) VALUES
	(1, 'Fotos', 'fa-picture-o', 19, '2017-04-30 09:04:15', '2019-04-06 06:33:07', 1, 1),
	(2, 'Comida', 'fa-cutlery', 19, '2017-04-30 02:28:09', '2019-04-06 06:33:32', 1, 1),
	(3, 'Dormir', 'fa-bed', 19, '2017-04-30 02:51:08', '2019-04-06 06:33:37', 1, 1),
	(4, 'Deportes', 'fa-trophy', 19, '2017-04-30 02:52:04', '2019-04-06 06:33:46', 1, 1),
	(5, 'Actividades', 'fa-puzzle-piece', 19, '2017-04-30 02:52:36', '2019-04-06 06:33:42', 1, 1),
	(6, 'Notas', 'fa-edit', 19, '2017-04-30 02:55:08', '2019-04-06 06:33:51', 1, 1),
	(7, 'Incidentes', 'fa-times', 19, '2017-04-30 03:00:54', '2019-04-06 06:33:57', 1, 1),
	(8, 'Medicina', 'fa-medkit', 19, '2017-04-30 03:02:47', '2019-04-06 06:34:05', 1, 1),
	(9, 'Arte', 'fa-paint-brush', 19, '2017-04-30 03:06:07', '2019-04-06 06:34:09', 1, 1);
/*!40000 ALTER TABLE `activitiescategory` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `activitiescomment` (
  `activitiescommentID` int(11) NOT NULL AUTO_INCREMENT,
  `activitiesID` int(11) NOT NULL,
  `comment` text NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  PRIMARY KEY (`activitiescommentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `activitiescomment` DISABLE KEYS */;
/*!40000 ALTER TABLE `activitiescomment` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `activitiesmedia` (
  `activitiesmediaID` int(11) NOT NULL AUTO_INCREMENT,
  `activitiesID` int(11) NOT NULL,
  `attachment` text NOT NULL,
  `create_date` datetime NOT NULL,
  PRIMARY KEY (`activitiesmediaID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `activitiesmedia` DISABLE KEYS */;
/*!40000 ALTER TABLE `activitiesmedia` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `activitiesstudent` (
  `activitiesstudentID` int(11) NOT NULL AUTO_INCREMENT,
  `activitiesID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  PRIMARY KEY (`activitiesstudentID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `activitiesstudent` DISABLE KEYS */;
/*!40000 ALTER TABLE `activitiesstudent` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `alert` (
  `alertID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `itemID` int(128) NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `itemname` varchar(128) NOT NULL,
  PRIMARY KEY (`alertID`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `alert` DISABLE KEYS */;
INSERT INTO `alert` (`alertID`, `itemID`, `userID`, `usertypeID`, `itemname`) VALUES
	(1, 1, 1, 1, 'message'),
	(2, 2, 1, 1, 'message'),
	(3, 3, 1, 1, 'message'),
	(4, 4, 1, 1, 'message'),
	(5, 1, 1, 1, 'notice'),
	(6, 1, 1, 1, 'holiday'),
	(7, 1, 1, 1, 'event'),
	(8, 2, 1, 1, 'event'),
	(9, 3, 1, 1, 'event'),
	(10, 1, 1, 1, 'mark'),
	(11, 2, 1, 1, 'mark'),
	(12, 3, 1, 1, 'mark'),
	(13, 4, 1, 1, 'mark'),
	(14, 5, 1, 1, 'mark'),
	(15, 6, 1, 1, 'mark'),
	(16, 7, 1, 1, 'mark'),
	(17, 8, 1, 1, 'mark'),
	(18, 9, 1, 1, 'mark'),
	(19, 10, 1, 1, 'mark'),
	(20, 11, 1, 1, 'mark'),
	(21, 12, 1, 1, 'mark'),
	(22, 13, 1, 1, 'mark'),
	(23, 14, 1, 1, 'mark'),
	(24, 15, 1, 1, 'mark'),
	(25, 16, 1, 1, 'mark'),
	(26, 17, 1, 1, 'mark'),
	(27, 18, 1, 1, 'mark');
/*!40000 ALTER TABLE `alert` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `asset` (
  `assetID` int(11) NOT NULL AUTO_INCREMENT,
  `serial` varchar(255) DEFAULT NULL,
  `description` text COMMENT 'Title',
  `manufacturer` varchar(255) DEFAULT NULL,
  `brand` varchar(255) DEFAULT NULL,
  `asset_number` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `asset_condition` int(11) DEFAULT NULL,
  `attachment` text,
  `originalfile` text,
  `asset_categoryID` int(11) DEFAULT NULL,
  `asset_locationID` int(11) DEFAULT NULL,
  `create_date` date NOT NULL,
  `modify_date` date NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`assetID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `asset` DISABLE KEYS */;
INSERT INTO `asset` (`assetID`, `serial`, `description`, `manufacturer`, `brand`, `asset_number`, `status`, `asset_condition`, `attachment`, `originalfile`, `asset_categoryID`, `asset_locationID`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES
	(1, '88765', 'Activo 32', NULL, NULL, NULL, 2, 1, '', '', 1, 1, '2019-04-26', '2019-04-26', 1, 1);
/*!40000 ALTER TABLE `asset` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `asset_assignment` (
  `asset_assignmentID` int(11) NOT NULL AUTO_INCREMENT,
  `assetID` int(11) NOT NULL COMMENT 'Description and title',
  `usertypeID` int(11) DEFAULT NULL,
  `check_out_to` int(11) NOT NULL,
  `due_date` date DEFAULT NULL,
  `note` text,
  `assigned_quantity` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `asset_locationID` int(11) DEFAULT NULL,
  `check_out_date` date DEFAULT NULL,
  `check_in_date` date DEFAULT NULL,
  `create_date` date NOT NULL,
  `modify_date` date NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`asset_assignmentID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `asset_assignment` DISABLE KEYS */;
INSERT INTO `asset_assignment` (`asset_assignmentID`, `assetID`, `usertypeID`, `check_out_to`, `due_date`, `note`, `assigned_quantity`, `status`, `asset_locationID`, `check_out_date`, `check_in_date`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES
	(1, 1, 2, 4, '2019-04-30', '', 32, 2, 1, '2019-04-26', '2019-04-26', '2019-04-26', '2019-04-26', 1, 1);
/*!40000 ALTER TABLE `asset_assignment` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `asset_category` (
  `asset_categoryID` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(255) NOT NULL,
  `create_date` date NOT NULL,
  `modify_date` date NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  `active` int(11) NOT NULL,
  PRIMARY KEY (`asset_categoryID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `asset_category` DISABLE KEYS */;
INSERT INTO `asset_category` (`asset_categoryID`, `category`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`, `active`) VALUES
	(1, 'estandar', '2019-04-26', '2019-04-26', 1, 1, 1);
/*!40000 ALTER TABLE `asset_category` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `assignment` (
  `assignmentID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(128) NOT NULL,
  `description` text NOT NULL,
  `deadlinedate` date NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `originalfile` text NOT NULL,
  `file` text NOT NULL,
  `classesID` longtext NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `sectionID` longtext,
  `subjectID` longtext,
  `assignusertypeID` int(11) DEFAULT NULL,
  `assignuserID` int(11) DEFAULT NULL,
  PRIMARY KEY (`assignmentID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`assignmentID`, `title`, `description`, `deadlinedate`, `usertypeID`, `userID`, `originalfile`, `file`, `classesID`, `schoolyearID`, `sectionID`, `subjectID`, `assignusertypeID`, `assignuserID`) VALUES
	(1, 'Prácticas de matemáticas', 'ecuaciones de segundo grado', '2019-10-31', 1, 1, '', '', '2', 1, '["1"]', '1', 0, 0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `assignmentanswer` (
  `assignmentanswerID` int(11) NOT NULL AUTO_INCREMENT,
  `assignmentID` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `uploaderID` int(11) NOT NULL,
  `uploadertypeID` int(11) NOT NULL,
  `answerfile` text NOT NULL,
  `answerfileoriginal` text NOT NULL,
  `answerdate` date NOT NULL,
  PRIMARY KEY (`assignmentanswerID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `assignmentanswer` DISABLE KEYS */;
INSERT INTO `assignmentanswer` (`assignmentanswerID`, `assignmentID`, `schoolyearID`, `uploaderID`, `uploadertypeID`, `answerfile`, `answerfileoriginal`, `answerdate`) VALUES
	(1, 1, 1, 2, 3, '858d7492f9ea809523ddffbda828afbaccf12aa2fe87f1c61b878744880be13a4b77887c3ecd438e6b31fd5ec2be836e224ec13e42ae1860fbc49bef513db8e5.png', 'AnthonCode.png', '2019-04-27');
/*!40000 ALTER TABLE `assignmentanswer` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `attendance` (
  `attendanceID` int(200) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  `sectionID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `usertype` varchar(60) NOT NULL,
  `monthyear` varchar(10) NOT NULL,
  `a1` varchar(3) DEFAULT NULL,
  `a2` varchar(3) DEFAULT NULL,
  `a3` varchar(3) DEFAULT NULL,
  `a4` varchar(3) DEFAULT NULL,
  `a5` varchar(3) DEFAULT NULL,
  `a6` varchar(3) DEFAULT NULL,
  `a7` varchar(3) DEFAULT NULL,
  `a8` varchar(3) DEFAULT NULL,
  `a9` varchar(3) DEFAULT NULL,
  `a10` varchar(3) DEFAULT NULL,
  `a11` varchar(3) DEFAULT NULL,
  `a12` varchar(3) DEFAULT NULL,
  `a13` varchar(3) DEFAULT NULL,
  `a14` varchar(3) DEFAULT NULL,
  `a15` varchar(3) DEFAULT NULL,
  `a16` varchar(3) DEFAULT NULL,
  `a17` varchar(3) DEFAULT NULL,
  `a18` varchar(3) DEFAULT NULL,
  `a19` varchar(3) DEFAULT NULL,
  `a20` varchar(3) DEFAULT NULL,
  `a21` varchar(3) DEFAULT NULL,
  `a22` varchar(3) DEFAULT NULL,
  `a23` varchar(3) DEFAULT NULL,
  `a24` varchar(3) DEFAULT NULL,
  `a25` varchar(3) DEFAULT NULL,
  `a26` varchar(3) DEFAULT NULL,
  `a27` varchar(3) DEFAULT NULL,
  `a28` varchar(3) DEFAULT NULL,
  `a29` varchar(3) DEFAULT NULL,
  `a30` varchar(3) DEFAULT NULL,
  `a31` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`attendanceID`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `attendance` DISABLE KEYS */;
INSERT INTO `attendance` (`attendanceID`, `schoolyearID`, `studentID`, `classesID`, `sectionID`, `userID`, `usertype`, `monthyear`, `a1`, `a2`, `a3`, `a4`, `a5`, `a6`, `a7`, `a8`, `a9`, `a10`, `a11`, `a12`, `a13`, `a14`, `a15`, `a16`, `a17`, `a18`, `a19`, `a20`, `a21`, `a22`, `a23`, `a24`, `a25`, `a26`, `a27`, `a28`, `a29`, `a30`, `a31`) VALUES
	(1, 1, 2, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, 'P', NULL, NULL, 'LE', 'L', 'A', NULL, 'P', NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL),
	(2, 1, 4, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, 'P', NULL, NULL, 'LE', 'L', 'P', NULL, 'P', NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL),
	(3, 1, 1, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, 'LE', NULL, NULL, 'LE', 'L', 'P', NULL, 'P', NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL),
	(4, 1, 3, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, 'L', NULL, NULL, 'LE', 'L', 'P', NULL, 'P', NULL, NULL, NULL, NULL, NULL, 'LE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'A', NULL, NULL, NULL, NULL, NULL),
	(5, 1, 5, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'LE', NULL, NULL, NULL, NULL, NULL, 'LE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL),
	(6, 1, 6, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL),
	(7, 1, 8, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, 'L', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL),
	(8, 1, 9, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL),
	(9, 1, 10, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'LE', NULL, NULL, NULL, NULL, NULL, 'L', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL),
	(10, 1, 11, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL),
	(11, 1, 12, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'LE', NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL),
	(12, 1, 13, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL),
	(13, 1, 14, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL),
	(14, 1, 15, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL),
	(15, 1, 16, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL),
	(16, 1, 17, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'L', NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'LE', NULL, NULL, NULL, NULL, NULL),
	(17, 1, 18, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'L', NULL, NULL, NULL, NULL, NULL),
	(18, 1, 7, 2, 1, 1, 'Admin', '04-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL, 'A', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'P', NULL, NULL, NULL, NULL, NULL),
	(19, 1, 2, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(20, 1, 4, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(21, 1, 5, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(22, 1, 6, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(23, 1, 8, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(24, 1, 9, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(25, 1, 10, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(26, 1, 11, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(27, 1, 1, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(28, 1, 12, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(29, 1, 13, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(30, 1, 14, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(31, 1, 15, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(32, 1, 16, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(33, 1, 17, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(34, 1, 18, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(35, 1, 3, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(36, 1, 7, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
	(37, 1, 19, 2, 1, 8, 'Docente', '05-2019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
/*!40000 ALTER TABLE `attendance` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `automation_rec` (
  `automation_recID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `studentID` int(11) NOT NULL,
  `date` date NOT NULL,
  `day` varchar(3) NOT NULL,
  `month` varchar(3) NOT NULL,
  `year` year(4) NOT NULL,
  `nofmodule` int(11) NOT NULL,
  PRIMARY KEY (`automation_recID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `automation_rec` DISABLE KEYS */;
/*!40000 ALTER TABLE `automation_rec` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `automation_shudulu` (
  `automation_shuduluID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `day` varchar(3) NOT NULL,
  `month` varchar(3) NOT NULL,
  `year` year(4) NOT NULL,
  PRIMARY KEY (`automation_shuduluID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `automation_shudulu` DISABLE KEYS */;
INSERT INTO `automation_shudulu` (`automation_shuduluID`, `date`, `day`, `month`, `year`) VALUES
	(1, '2019-02-02', '02', '02', '2019');
/*!40000 ALTER TABLE `automation_shudulu` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `book` (
  `bookID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `book` varchar(60) NOT NULL,
  `subject_code` tinytext NOT NULL,
  `author` varchar(100) NOT NULL,
  `price` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `due_quantity` int(11) NOT NULL,
  `rack` tinytext NOT NULL,
  PRIMARY KEY (`bookID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `book` DISABLE KEYS */;
INSERT INTO `book` (`bookID`, `book`, `subject_code`, `author`, `price`, `quantity`, `due_quantity`, `rack`) VALUES
	(1, 'ALGEBRA', 'E234', 'BALDOR', 50, 700, 0, '3242423QWEW'),
	(2, 'CIENCIAS', 'EWQE', 'VARGAS', 43, 433, 0, '123E'),
	(3, 'INTRODUCCION A LA QUIMICA', 'E3423F', 'ROGER R.', 43, 443, 0, '32R6'),
	(4, 'COMO SER UN TOPO', '43T6', 'EL TOPO', 45, 87, 0, '3125'),
	(5, '50 SOMBRAS DE PEPE', '53454TE', 'EL PEPE', 2, 500, 0, '43RT6'),
	(6, 'MUJERCITAS', '8754TE', 'NO LO SE', 34, 57, 0, '87'),
	(7, 'LOS MAESTROS TAMBIEN TENEMOS SENTIMIENTOS', '5YTRYR', 'ERUDITO JR', 43, 907, 0, '53'),
	(8, 'COMO SER UN GENIO EN 1 DIA', '867UYT', 'JUANITO', 38, 785, 1, '32');
/*!40000 ALTER TABLE `book` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `category` (
  `categoryID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hostelID` int(11) NOT NULL,
  `class_type` varchar(60) NOT NULL,
  `hbalance` varchar(20) NOT NULL,
  `note` text,
  PRIMARY KEY (`categoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `category` DISABLE KEYS */;
/*!40000 ALTER TABLE `category` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `certificate_template` (
  `certificate_templateID` int(11) NOT NULL AUTO_INCREMENT,
  `usertypeID` int(11) NOT NULL,
  `name` varchar(60) NOT NULL,
  `theme` int(11) NOT NULL,
  `top_heading_title` text,
  `top_heading_left` text,
  `top_heading_right` text,
  `top_heading_middle` text,
  `main_middle_text` text NOT NULL,
  `template` text NOT NULL,
  `footer_left_text` text,
  `footer_right_text` text,
  `footer_middle_text` text,
  `background_image` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`certificate_templateID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `certificate_template` DISABLE KEYS */;
INSERT INTO `certificate_template` (`certificate_templateID`, `usertypeID`, `name`, `theme`, `top_heading_title`, `top_heading_left`, `top_heading_right`, `top_heading_middle`, `main_middle_text`, `template`, `footer_left_text`, `footer_right_text`, `footer_middle_text`, `background_image`) VALUES
	(1, 3, 'certificado graduación', 1, 'Certificado de Graduación<br>', '', '', '2020', 'LESSON<br>', '<span>Este certificado es gracias a la dedicación y estudio en las diversas asignaturas de esta institución educativa, se otorga este certificado al estudiante: [name], por seguir sus metas.</span>', 'Firma del Director o Directora<br>', 'Firma del Docente<br>', 'rrrrrrr', '053de526ab517db1a2d49cabe8ee966db1ea17d2eb6bdbe5fe41a3f856cf45321ed00c797cd7384c60308183ae0fdcc2b534282d9d6c5a423a0c49da476f2cee.png'),
	(2, 3, 'certificado feria de ciencias', 2, 'FERIA DE CIENCIAS<br>', '2020', 'Feria de ciencia<br>', 'ddddddddd', 'Certificado a mejor proyecto<br>', 'Gracias por presentar su mejor proyecto en la feria estatal de ciencias, este certificado es para reconocer su aporte a la ciencia, estudiante: [name]', 'FIRMA DEL DIRECTOR<br>', 'FIRMA DEL DOCENTE<br>', '', 'c1badfef7344a65f20f137aca2095100046dc6f4cc5b34048d66310a0cbaf9d7446ec9cbc36e3fc5182de85089a58aa8fd6bbc87497effb704b526e2326f5031.png');
/*!40000 ALTER TABLE `certificate_template` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `childcare` (
  `childcareID` int(11) NOT NULL AUTO_INCREMENT,
  `dropped_at` datetime DEFAULT NULL,
  `received_at` datetime DEFAULT NULL,
  `usertypeID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `parentID` int(11) NOT NULL,
  `signature` text,
  `classesID` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `comment` text,
  `received_status` int(11) NOT NULL DEFAULT '0',
  `receiver_name` varchar(40) NOT NULL,
  `phone` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`childcareID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `childcare` DISABLE KEYS */;
INSERT INTO `childcare` (`childcareID`, `dropped_at`, `received_at`, `usertypeID`, `userID`, `parentID`, `signature`, `classesID`, `schoolyearID`, `comment`, `received_status`, `receiver_name`, `phone`) VALUES
	(1, '2019-04-22 16:05:00', '2019-04-23 17:00:00', 3, 2, 2, NULL, 2, 1, '', 0, 'ANDRES EL NIÑERO', '25454');
/*!40000 ALTER TABLE `childcare` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `classes` (
  `classesID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `classes` varchar(60) NOT NULL,
  `classes_numeric` int(11) NOT NULL,
  `teacherID` int(11) NOT NULL,
  `studentmaxID` int(11) DEFAULT NULL,
  `note` text,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(60) NOT NULL,
  `create_usertype` varchar(60) NOT NULL,
  PRIMARY KEY (`classesID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `classes` DISABLE KEYS */;
INSERT INTO `classes` (`classesID`, `classes`, `classes_numeric`, `teacherID`, `studentmaxID`, `note`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`) VALUES
	(2, 'PRIMERO DE SECUNDARIA', 1, 8, 999999999, '', '2019-05-03 02:29:15', '2019-05-03 02:49:57', 1, 'admin', 'Admin'),
	(3, 'SEGUNDO DE SECUNDARIA', 2, 8, 999999999, '', '2019-03-25 02:32:02', '2019-05-03 02:52:47', 1, 'admin', 'Admin'),
	(4, 'TERCERO DE SECUNDARIA', 3, 8, 999999999, '', '2019-03-25 02:33:03', '2019-05-03 02:52:54', 1, 'admin', 'Admin'),
	(5, 'CUARTO DE SECUNDARIA', 4, 8, 999999999, '', '2019-05-03 02:33:30', '2019-05-03 02:33:30', 1, 'admin', 'Admin'),
	(8, 'Baile', 5, 4, 999999999, '', '2019-05-03 02:53:55', '2019-05-03 02:53:55', 1, 'admin', 'Admin'),
	(9, 'Artes', 7, 8, 999999999, '', '2019-05-03 02:54:20', '2019-05-03 02:54:20', 1, 'admin', 'Admin');
/*!40000 ALTER TABLE `classes` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `complain` (
  `complainID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `userID` int(11) DEFAULT NULL,
  `schoolyearID` int(11) DEFAULT NULL,
  `description` text,
  `attachment` text,
  `originalfile` text,
  `create_userID` int(11) NOT NULL DEFAULT '0',
  `create_usertypeID` int(11) NOT NULL DEFAULT '0',
  `create_date` datetime DEFAULT NULL,
  `modify_date` datetime DEFAULT NULL,
  PRIMARY KEY (`complainID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `complain` DISABLE KEYS */;
INSERT INTO `complain` (`complainID`, `title`, `usertypeID`, `userID`, `schoolyearID`, `description`, `attachment`, `originalfile`, `create_userID`, `create_usertypeID`, `create_date`, `modify_date`) VALUES
	(1, 'aulas en mal estado', 1, 1, 1, 'el piso esta sucio y las ventanas rotas', NULL, NULL, 3, 3, '2019-04-04 12:07:14', '2019-04-04 12:07:14');
/*!40000 ALTER TABLE `complain` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `conversation_message_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` int(11) DEFAULT '0',
  `draft` int(11) DEFAULT '0',
  `fav_status` int(11) DEFAULT '0',
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `conversation_message_info` DISABLE KEYS */;
INSERT INTO `conversation_message_info` (`id`, `status`, `draft`, `fav_status`, `create_date`, `modify_date`) VALUES
	(1, 0, 0, 0, '2019-04-05 14:00:19', '2019-04-05 14:00:19'),
	(2, 0, 0, 0, '2019-04-05 14:02:28', '2019-04-05 14:02:28'),
	(3, 0, 0, 0, '2019-04-05 14:03:10', '2019-04-05 14:03:10'),
	(4, 0, 0, 0, '2019-04-05 14:04:10', '2019-04-05 14:04:10');
/*!40000 ALTER TABLE `conversation_message_info` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `conversation_msg` (
  `msg_id` int(11) NOT NULL AUTO_INCREMENT,
  `conversation_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `msg` text NOT NULL,
  `attach` text,
  `attach_file_name` text,
  `usertypeID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `start` int(11) DEFAULT NULL,
  PRIMARY KEY (`msg_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `conversation_msg` DISABLE KEYS */;
INSERT INTO `conversation_msg` (`msg_id`, `conversation_id`, `user_id`, `subject`, `msg`, `attach`, `attach_file_name`, `usertypeID`, `create_date`, `modify_date`, `start`) VALUES
	(1, 1, 1, 'calificaciones de enero', 'sus calificaciones ya están publicadas', NULL, NULL, 1, '2019-04-05 14:00:19', '2019-04-05 14:00:19', 1),
	(2, 2, 1, 'cheque', 'ya puede recoger su cheque de febrero', NULL, NULL, 1, '2019-04-05 14:02:28', '2019-04-05 14:02:28', 1),
	(3, 3, 1, 'pago de mensualidad', 'pagos de esta semana pendientes', NULL, NULL, 1, '2019-04-05 14:03:10', '2019-04-05 14:03:10', 1),
	(4, 4, 1, 'reunión', 'Lorem ipsum dolor sit amet, consectetur adipisicing elit. Reiciendis tempore consequatur corporis incidunt sapiente inventore id, voluptates modi voluptatum ex.Lorem ipsum dolor sit amet, consectetur adipisicing elit. Reiciendis tempore consequatur corporis incidunt sapiente inventore id, voluptates modi voluptatum ex.Lorem ipsum dolor sit amet, consectetur adipisicing elit. Reiciendis tempore consequatur corporis incidunt sapiente inventore id, voluptates modi voluptatum ex.Lorem ipsum dolor sit amet, consectetur adipisicing elit. Reiciendis tempore consequatur corporis incidunt sapiente inventore id, voluptates modi voluptatum ex.Lorem ipsum dolor sit amet, consectetur adipisicing elit. Reiciendis tempore consequatur corporis incidunt sapiente inventore id, voluptates modi voluptatum ex.Lorem ipsum dolor sit amet, consectetur adipisicing elit. Reiciendis tempore consequatur corporis incidunt sapiente inventore id, voluptates modi voluptatum ex.Lorem ipsum dolor sit amet, consectetur adipisicing elit. Reiciendis tempore consequatur corporis incidunt sapiente inventore id, voluptates modi voluptatum ex.Lorem ipsum dolor sit amet, consectetur adipisicing elit. Reiciendis tempore consequatur corporis incidunt sapiente inventore id, voluptates modi voluptatum ex.', NULL, NULL, 1, '2019-04-05 14:04:10', '2019-04-05 14:04:10', 1);
/*!40000 ALTER TABLE `conversation_msg` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `conversation_user` (
  `conversation_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `is_sender` int(11) DEFAULT '0',
  `trash` int(11) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `conversation_user` DISABLE KEYS */;
INSERT INTO `conversation_user` (`conversation_id`, `user_id`, `usertypeID`, `is_sender`, `trash`) VALUES
	(1, 1, 1, 1, 0),
	(1, 2, 3, 0, 0),
	(2, 1, 1, 1, 0),
	(2, 4, 2, 0, 0),
	(3, 1, 1, 1, 0),
	(3, 4, 3, 0, 0),
	(4, 1, 1, 1, 0),
	(4, 1, 4, 0, 0),
	(4, 2, 4, 0, 0),
	(4, 3, 4, 0, 0),
	(4, 4, 4, 0, 0),
	(4, 5, 4, 0, 0),
	(4, 6, 4, 0, 0),
	(4, 7, 4, 0, 0),
	(4, 8, 4, 0, 0),
	(4, 9, 4, 0, 0),
	(4, 10, 4, 0, 0),
	(4, 11, 4, 0, 0),
	(4, 12, 4, 0, 0),
	(4, 13, 4, 0, 0),
	(4, 14, 4, 0, 0),
	(4, 15, 4, 0, 0),
	(4, 16, 4, 0, 0),
	(4, 17, 4, 0, 0),
	(4, 18, 4, 0, 0);
/*!40000 ALTER TABLE `conversation_user` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `document` (
  `documentID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(128) CHARACTER SET utf8 NOT NULL,
  `file` varchar(200) CHARACTER SET utf8 NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`documentID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

/*!40000 ALTER TABLE `document` DISABLE KEYS */;
/*!40000 ALTER TABLE `document` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `eattendance` (
  `eattendanceID` int(200) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `examID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  `sectionID` int(11) NOT NULL,
  `subjectID` int(11) NOT NULL,
  `date` date NOT NULL,
  `studentID` int(11) DEFAULT NULL,
  `s_name` varchar(60) DEFAULT NULL,
  `eattendance` varchar(20) DEFAULT NULL,
  `year` year(4) NOT NULL,
  `eextra` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`eattendanceID`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `eattendance` DISABLE KEYS */;
INSERT INTO `eattendance` (`eattendanceID`, `schoolyearID`, `examID`, `classesID`, `sectionID`, `subjectID`, `date`, `studentID`, `s_name`, `eattendance`, `year`, `eextra`) VALUES
	(1, 1, 8, 2, 1, 1, '2019-05-04', 2, 'JULIETA ROJAS LUNA', 'Present', '2019', NULL),
	(2, 1, 8, 2, 1, 1, '2019-05-04', 4, 'ANGELA LOZA VALENCIA', 'Present', '2019', NULL),
	(3, 1, 8, 2, 1, 1, '2019-05-04', 5, 'FRANZ PLACIDO DOMINGO', 'Present', '2019', NULL),
	(4, 1, 8, 2, 1, 1, '2019-05-04', 6, 'ABIGAIL FONTANER DALAS', 'Present', '2019', NULL),
	(5, 1, 8, 2, 1, 1, '2019-05-04', 8, 'IGNACIO RESTREPO GOMEZ', 'Present', '2019', NULL),
	(6, 1, 8, 2, 1, 1, '2019-05-04', 9, 'LAURA MENDOZA TAMBO', 'Present', '2019', NULL),
	(7, 1, 8, 2, 1, 1, '2019-05-04', 10, 'JUAN CARLOS ORTEGA AVALOS', 'Present', '2019', NULL),
	(8, 1, 8, 2, 1, 1, '2019-05-04', 11, 'ROBERTO AGUILAR VARGAS', 'Present', '2019', NULL),
	(9, 1, 8, 2, 1, 1, '2019-05-04', 1, 'CARLOS FERREIRA LOPEZ', 'Present', '2019', NULL),
	(10, 1, 8, 2, 1, 1, '2019-05-04', 12, 'EDUARDO NINA RAMIREZ', 'Present', '2019', NULL),
	(11, 1, 8, 2, 1, 1, '2019-05-04', 13, 'DIONICIO DURAN SANCHEZ', 'Present', '2019', NULL),
	(12, 1, 8, 2, 1, 1, '2019-05-04', 14, 'MOISES MARTINEZ PINTO', 'Present', '2019', NULL),
	(13, 1, 8, 2, 1, 1, '2019-05-04', 15, 'JAVIER TORREZ VELASCO', 'Present', '2019', NULL),
	(14, 1, 8, 2, 1, 1, '2019-05-04', 16, 'EVA PLATA HEREDIA', 'Present', '2019', NULL),
	(15, 1, 8, 2, 1, 1, '2019-05-04', 17, 'MIGUEL LUJAN SANTOS', 'Present', '2019', NULL),
	(16, 1, 8, 2, 1, 1, '2019-05-04', 18, 'RUDY MARQUEZ ROLDAN', 'Present', '2019', NULL),
	(17, 1, 8, 2, 1, 1, '2019-05-04', 3, 'MANUEL FLORES VASQUEZ', 'Present', '2019', NULL),
	(18, 1, 8, 2, 1, 1, '2019-05-04', 7, 'DIEGO GONZALES BARRAGAN', 'Present', '2019', NULL),
	(19, 1, 8, 2, 1, 1, '2019-05-04', 19, 'Ariel Flores', 'Present', '2019', NULL);
/*!40000 ALTER TABLE `eattendance` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `ebooks` (
  `ebooksID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 NOT NULL,
  `author` varchar(255) CHARACTER SET utf8 NOT NULL,
  `classesID` int(11) NOT NULL,
  `authority` tinyint(4) NOT NULL DEFAULT '0',
  `cover_photo` varchar(200) CHARACTER SET utf8 NOT NULL,
  `file` varchar(200) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`ebooksID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

/*!40000 ALTER TABLE `ebooks` DISABLE KEYS */;
INSERT INTO `ebooks` (`ebooksID`, `name`, `author`, `classesID`, `authority`, `cover_photo`, `file`) VALUES
	(1, 'TEORIA MUSICAL', 'SONIA T.', 2, 0, '9485d2a27a5be38a777f457bd56caa5dd801692f882fae64b80978427e37c437357c481fec4c3a38e2141857abdc5ef25eaa6deaa80e2969440437048785796f.jpg', '9bb03631f1c6741799d5c8421d9cbf274122c0d07f4d681ad971a9398329e77e89738f1588a10422dc990afa721eed988477994e1bfb8a881ebc9336f100cf78.pdf');
/*!40000 ALTER TABLE `ebooks` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `emailsetting` (
  `fieldoption` varchar(100) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`fieldoption`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `emailsetting` DISABLE KEYS */;
INSERT INTO `emailsetting` (`fieldoption`, `value`) VALUES
	('email_engine', 'sendmail'),
	('smtp_password', ''),
	('smtp_port', ''),
	('smtp_security', ''),
	('smtp_server', ''),
	('smtp_username', ' ');
/*!40000 ALTER TABLE `emailsetting` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `event` (
  `eventID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fdate` date NOT NULL,
  `ftime` time NOT NULL,
  `tdate` date NOT NULL,
  `ttime` time NOT NULL,
  `title` varchar(128) NOT NULL,
  `details` text NOT NULL,
  `photo` varchar(200) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `create_userID` int(11) NOT NULL DEFAULT '0',
  `create_usertypeID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`eventID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `event` DISABLE KEYS */;
INSERT INTO `event` (`eventID`, `fdate`, `ftime`, `tdate`, `ttime`, `title`, `details`, `photo`, `create_date`, `schoolyearID`, `create_userID`, `create_usertypeID`) VALUES
	(1, '2019-04-08', '00:00:00', '2019-04-08', '23:59:00', 'Cumpleaños del director', 'venir con regalos <br>', 'holiday.png', '2019-04-08 19:28:59', 1, 1, 1),
	(2, '2019-04-08', '00:00:00', '2019-04-10', '23:00:00', 'Reunion para padres de familia', 'para madres o padres de familia<br>', 'holiday.png', '2019-04-08 19:29:48', 1, 1, 1),
	(3, '2019-08-20', '00:00:00', '2019-08-21', '23:00:00', 'Graduación de secundaria', 'todos quedan invitados<br>', 'holiday.png', '2019-04-08 19:30:35', 1, 1, 1);
/*!40000 ALTER TABLE `event` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `eventcounter` (
  `eventcounterID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `eventID` int(11) NOT NULL,
  `username` varchar(40) NOT NULL,
  `type` varchar(20) NOT NULL,
  `name` varchar(128) NOT NULL,
  `photo` varchar(200) DEFAULT NULL,
  `status` int(11) NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`eventcounterID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `eventcounter` DISABLE KEYS */;
/*!40000 ALTER TABLE `eventcounter` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `exam` (
  `examID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `exam` varchar(60) NOT NULL,
  `date` date NOT NULL,
  `note` text,
  PRIMARY KEY (`examID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `exam` DISABLE KEYS */;
INSERT INTO `exam` (`examID`, `exam`, `date`, `note`) VALUES
	(2, 'examen de ciencias', '2019-05-04', ''),
	(3, 'examen de literatura', '2019-04-03', ''),
	(4, 'examen de música', '2019-04-05', ''),
	(5, 'examen de química', '2019-04-04', ''),
	(6, 'examen sobre ecuaciones', '2019-04-15', ''),
	(7, 'examen sobre la tabla periódica', '2019-04-12', ''),
	(8, 'examen de matemáticas', '2019-05-04', '');
/*!40000 ALTER TABLE `exam` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `examschedule` (
  `examscheduleID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `examID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  `sectionID` int(11) NOT NULL,
  `subjectID` int(11) NOT NULL,
  `edate` date NOT NULL,
  `examfrom` varchar(10) NOT NULL,
  `examto` varchar(10) NOT NULL,
  `room` tinytext,
  `schoolyearID` int(11) NOT NULL,
  PRIMARY KEY (`examscheduleID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `examschedule` DISABLE KEYS */;
INSERT INTO `examschedule` (`examscheduleID`, `examID`, `classesID`, `sectionID`, `subjectID`, `edate`, `examfrom`, `examto`, `room`, `schoolyearID`) VALUES
	(1, 2, 2, 1, 2, '2019-05-04', '4:30 PM', '5:00 PM', '3et', 1),
	(2, 2, 2, 1, 2, '2019-05-04', '4:30 PM', '5:00 PM', 'AE4', 1),
	(3, 8, 2, 1, 1, '2019-05-04', '5:15 PM', '5:30 PM', '', 1);
/*!40000 ALTER TABLE `examschedule` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `expense` (
  `expenseID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `create_date` date NOT NULL,
  `date` date NOT NULL,
  `expenseday` varchar(11) NOT NULL,
  `expensemonth` varchar(11) NOT NULL,
  `expenseyear` year(4) NOT NULL,
  `expense` varchar(128) NOT NULL,
  `amount` double NOT NULL,
  `file` varchar(200) DEFAULT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `uname` varchar(60) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `note` text,
  PRIMARY KEY (`expenseID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `expense` DISABLE KEYS */;
INSERT INTO `expense` (`expenseID`, `create_date`, `date`, `expenseday`, `expensemonth`, `expenseyear`, `expense`, `amount`, `file`, `userID`, `usertypeID`, `uname`, `schoolyearID`, `note`) VALUES
	(1, '2019-04-08', '2019-04-08', '08', '04', '2019', 'compra de uniformes', 456, '', 1, 1, 'admin', 1, ''),
	(2, '2019-04-08', '2019-04-08', '08', '04', '2019', 'compra de material escolar', 534, '', 1, 1, 'admin', 1, '');
/*!40000 ALTER TABLE `expense` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `feetypes` (
  `feetypesID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `feetypes` varchar(60) NOT NULL,
  `note` text,
  PRIMARY KEY (`feetypesID`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `feetypes` DISABLE KEYS */;
INSERT INTO `feetypes` (`feetypesID`, `feetypes`, `note`) VALUES
	(1, 'Libros', 'libros de uso gratuito'),
	(2, 'Biblioteca', 'tiene un costo'),
	(3, 'Transporte', 'Tiene costo'),
	(4, 'Hospedaje gratis', 'de uso gratuito'),
	(5, 'material de artes [Jan]', ''),
	(6, 'material de artes [Feb]', ''),
	(7, 'material de artes [Mar]', ''),
	(8, 'material de artes [Apr]', ''),
	(9, 'material de artes [May]', ''),
	(10, 'material de artes [Jun]', ''),
	(11, 'material de artes [Jul]', ''),
	(12, 'material de artes [Aug]', ''),
	(13, 'material de artes [Sep]', ''),
	(14, 'material de artes [Oct]', ''),
	(15, 'material de artes [Nov]', ''),
	(16, 'material de artes [Dec]', '');
/*!40000 ALTER TABLE `feetypes` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `fmenu` (
  `fmenuID` int(11) NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(128) NOT NULL,
  `status` int(11) NOT NULL COMMENT 'Only for active',
  `topbar` int(11) NOT NULL,
  `social` int(11) NOT NULL,
  PRIMARY KEY (`fmenuID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `fmenu` DISABLE KEYS */;
INSERT INTO `fmenu` (`fmenuID`, `menu_name`, `status`, `topbar`, `social`) VALUES
	(1, 'header', 1, 1, 1);
/*!40000 ALTER TABLE `fmenu` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `fmenu_relation` (
  `fmenu_relationID` int(11) NOT NULL AUTO_INCREMENT,
  `fmenuID` int(11) DEFAULT NULL,
  `menu_typeID` int(11) DEFAULT NULL COMMENT '1 => Pages, 2 => Post, 3 => Links',
  `menu_parentID` varchar(128) DEFAULT NULL,
  `menu_orderID` int(11) DEFAULT NULL,
  `menu_pagesID` int(11) DEFAULT NULL,
  `menu_label` varchar(254) DEFAULT NULL,
  `menu_link` text NOT NULL,
  `menu_rand` varchar(128) DEFAULT NULL,
  `menu_rand_parentID` varchar(128) DEFAULT NULL,
  `menu_status` int(11) DEFAULT NULL,
  PRIMARY KEY (`fmenu_relationID`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `fmenu_relation` DISABLE KEYS */;
INSERT INTO `fmenu_relation` (`fmenu_relationID`, `fmenuID`, `menu_typeID`, `menu_parentID`, `menu_orderID`, `menu_pagesID`, `menu_label`, `menu_link`, `menu_rand`, `menu_rand_parentID`, `menu_status`) VALUES
	(22, 1, 1, '0', 1, 1, 'Inicio', '#', 'f01522cd1db3a1cb1ebc1a45517cf8ad', '0', 1),
	(23, 1, 1, '0', 2, 9, 'Blog', '#', '045696bc8e7d2fc782c1253aa99bcd4b', '0', 1),
	(24, 1, 1, '0', 3, 5, 'Evento', '#', 'e63b0d31559914103de5701935c52374', '0', 1),
	(25, 1, 1, '0', 4, 7, 'Galeria', '#', '1dc91e4aff72849a09f4a1c65fd400a5', '0', 1),
	(26, 1, 1, '0', 5, 6, 'Profesor', '#', '3bf7c73f58c87af6ca250ecf71de99e5', '0', 1),
	(27, 1, 1, '0', 6, 8, 'Noticias', '#', '7037eb88c81249f9d0fc53cb52d007c8', '0', 1),
	(28, 1, 1, '0', 7, 10, 'Admisión', '#', '43172c06100e10ee8148b10c0fd83f01', '0', 1),
	(29, 1, 1, '0', 8, 3, 'Contacto', '#', '6be641d77b2683c11cea869df581e0af', '0', 1),
	(30, 1, 1, '0', 9, 4, 'Acerca De', '#', 'd56b948dc0a3ef8803b66a51e8d66ef9', '0', 1);
/*!40000 ALTER TABLE `fmenu_relation` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `frontend_setting` (
  `fieldoption` varchar(100) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`fieldoption`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `frontend_setting` DISABLE KEYS */;
INSERT INTO `frontend_setting` (`fieldoption`, `value`) VALUES
	('description', ''),
	('facebook', 'https://facebook.com/anthoncode'),
	('linkedin', ''),
	('login_menu_status', '1'),
	('online_admission_status', '1'),
	('pinterest', 'https://pinterest.com/anthoncode/'),
	('teacher_email_status', '0'),
	('teacher_phone_status', '0'),
	('twitter', 'https://twitter.com/anthoncode'),
	('youtube', 'https://youtube.com/c/anthoncode');
/*!40000 ALTER TABLE `frontend_setting` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `frontend_template` (
  `frontend_templateID` int(11) NOT NULL AUTO_INCREMENT,
  `template_name` varchar(128) NOT NULL,
  PRIMARY KEY (`frontend_templateID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `frontend_template` DISABLE KEYS */;
INSERT INTO `frontend_template` (`frontend_templateID`, `template_name`) VALUES
	(1, 'home'),
	(2, 'about'),
	(3, 'event'),
	(4, 'teacher'),
	(5, 'gallery'),
	(6, 'notice'),
	(7, 'blog'),
	(8, 'contact'),
	(9, 'admission');
/*!40000 ALTER TABLE `frontend_template` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `globalpayment` (
  `globalpaymentID` int(11) NOT NULL AUTO_INCREMENT,
  `classesID` int(11) DEFAULT NULL,
  `sectionID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `clearancetype` varchar(40) NOT NULL,
  `invoicename` varchar(128) NOT NULL,
  `invoicedescription` varchar(128) NOT NULL,
  `paymentyear` varchar(5) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  PRIMARY KEY (`globalpaymentID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `globalpayment` DISABLE KEYS */;
INSERT INTO `globalpayment` (`globalpaymentID`, `classesID`, `sectionID`, `studentID`, `clearancetype`, `invoicename`, `invoicedescription`, `paymentyear`, `schoolyearID`) VALUES
	(1, 2, 1, 2, 'partial', '412413EW-JULIETA ROJAS LUNA', '', '2019', 1),
	(2, 2, 1, 4, 'paid', '3124EWAE-ANGELA LOZA VALENCIA', '', '2019', 1),
	(3, 2, 1, 2, 'partial', '412413EW-JULIETA ROJAS LUNA', '', '2019', 1),
	(4, 2, 1, 2, 'paid', '412413EW-JULIETA ROJAS LUNA', '', '2019', 1),
	(5, 2, 1, 2, 'partial', '412413EW-JULIETA ROJAS LUNA', '', '2019', 1);
/*!40000 ALTER TABLE `globalpayment` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `grade` (
  `gradeID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `grade` varchar(60) NOT NULL,
  `point` varchar(11) NOT NULL,
  `gradefrom` int(11) NOT NULL,
  `gradeupto` int(11) NOT NULL,
  `note` text,
  PRIMARY KEY (`gradeID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `grade` DISABLE KEYS */;
INSERT INTO `grade` (`gradeID`, `grade`, `point`, `gradefrom`, `gradeupto`, `note`) VALUES
	(1, 'APROBADO', '0', 51, 100, ''),
	(2, 'NORMAL', '0.5', 11, 50, ''),
	(3, 'REPROBADO', '5', 5, 10, '');
/*!40000 ALTER TABLE `grade` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `hmember` (
  `hmemberID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hostelID` int(11) NOT NULL,
  `categoryID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `hbalance` varchar(20) DEFAULT NULL,
  `hjoindate` date NOT NULL,
  PRIMARY KEY (`hmemberID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `hmember` DISABLE KEYS */;
/*!40000 ALTER TABLE `hmember` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `holiday` (
  `holidayID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `fdate` date NOT NULL,
  `tdate` date NOT NULL,
  `title` varchar(128) NOT NULL,
  `details` text NOT NULL,
  `photo` varchar(200) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL DEFAULT '0',
  `create_usertypeID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`holidayID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `holiday` DISABLE KEYS */;
INSERT INTO `holiday` (`holidayID`, `schoolyearID`, `fdate`, `tdate`, `title`, `details`, `photo`, `create_date`, `create_userID`, `create_usertypeID`) VALUES
	(1, 1, '2019-10-01', '2019-11-06', 'VACACIONES DE FIN DE AÑO', 'VACACIONES PARA TODOS<br>', 'holiday.png', '2019-04-06 19:03:27', 1, 1);
/*!40000 ALTER TABLE `holiday` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `hostel` (
  `hostelID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `htype` varchar(11) NOT NULL,
  `address` varchar(200) NOT NULL,
  `note` text,
  PRIMARY KEY (`hostelID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `hostel` DISABLE KEYS */;
INSERT INTO `hostel` (`hostelID`, `name`, `htype`, `address`, `note`) VALUES
	(1, 'LOS OLIVOS', 'Niños', 'CALLE LIMON', ''),
	(2, 'FRATERNIDAD DIVAS', 'Chicas', 'EN LA SECCION SUR', '');
/*!40000 ALTER TABLE `hostel` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `hourly_template` (
  `hourly_templateID` int(11) NOT NULL AUTO_INCREMENT,
  `hourly_grades` varchar(128) NOT NULL,
  `hourly_rate` int(11) NOT NULL,
  PRIMARY KEY (`hourly_templateID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `hourly_template` DISABLE KEYS */;
INSERT INTO `hourly_template` (`hourly_templateID`, `hourly_grades`, `hourly_rate`) VALUES
	(1, 'plus', 100);
/*!40000 ALTER TABLE `hourly_template` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `idmanager` (
  `idmanagerID` int(11) NOT NULL AUTO_INCREMENT,
  `schooltype` varchar(20) NOT NULL,
  `idtitle` varchar(128) NOT NULL,
  `idtype` varchar(128) NOT NULL,
  PRIMARY KEY (`idmanagerID`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `idmanager` DISABLE KEYS */;
INSERT INTO `idmanager` (`idmanagerID`, `schooltype`, `idtitle`, `idtype`) VALUES
	(1, 'semesterbase', 'Year+Semester Code+Department Code+Student Max ID', 'schoolyear+semestercode+classes_numeric+studentmaxID'),
	(2, 'semesterbase', 'Year+Department Code+Semester Code+Student Max ID', 'schoolyear+classes_numeric+semestercode+studentmaxID'),
	(3, 'semesterbase', 'Year+Semester Code+Student Max ID', 'schoolyear+semestercode+studentmaxID'),
	(4, 'semesterbase', 'Year+Department Code+Student Max ID', 'schoolyear+classes_numeric+studentmaxID'),
	(5, 'semesterbase', 'Student Max ID+Year+Semester Code+Department Code', 'studentmaxID+schoolyear+semestercode+classes_numeric'),
	(6, 'semesterbase', 'Student Max ID+Semester Code+Department Code+Year', 'studentmaxID+semestercode+classes_numeric+schoolyear'),
	(7, 'semesterbase', 'Student Max ID+Semester Code+Department Code', 'studentmaxID+semestercode+classes_numeric'),
	(8, 'semesterbase', 'Student Max ID+Department Code+Semester Code', 'studentmaxID+classes_numeric+semestercode'),
	(9, 'semesterbase', 'Semester Code+Department Code+Student Max ID', 'semestercode+classes_numeric+studentmaxID'),
	(10, 'semesterbase', 'Department Code+Semester Code+Student Max ID', 'classes_numeric+semestercode+studentmaxID'),
	(11, 'semesterbase', 'Semester Code+Student Max ID', 'semestercode+studentmaxID'),
	(12, 'semesterbase', 'Department Code+Student Max ID', 'classes_numeric+studentmaxID'),
	(13, 'semesterbase', 'Student Max ID', 'studentmaxID'),
	(14, 'classbase', 'Year+Class Numeric+Student Max ID', 'schoolyear+classes_numeric+studentmaxID'),
	(15, 'Classbase', 'Class Numeric+Year+Student Max ID', 'classes_numeric+schoolyear+studentmaxID'),
	(16, 'classbase', 'Year+Student Max ID', 'schoolyear+studentmaxID'),
	(17, 'classbase', 'Class Numeric+Student Max ID', 'classes_numeric+studentmaxID'),
	(18, 'classbase', 'Student Max ID', 'studentmaxID'),
	(19, 'semesterbase', 'None', 'none'),
	(20, 'classbase', 'None', 'none');
/*!40000 ALTER TABLE `idmanager` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `income` (
  `incomeID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `date` date NOT NULL,
  `incomeday` varchar(11) NOT NULL,
  `incomemonth` varchar(11) NOT NULL,
  `incomeyear` year(4) NOT NULL,
  `amount` double NOT NULL,
  `file` varchar(200) NOT NULL,
  `note` text NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `create_date` date NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`incomeID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `income` DISABLE KEYS */;
INSERT INTO `income` (`incomeID`, `name`, `date`, `incomeday`, `incomemonth`, `incomeyear`, `amount`, `file`, `note`, `schoolyearID`, `create_date`, `userID`, `usertypeID`) VALUES
	(1, 'Bonos por parte del ministerio para aulas', '2019-04-08', '08', '04', '2019', 5800, '', '', 1, '2019-04-08', 1, 1);
/*!40000 ALTER TABLE `income` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `ini_config` (
  `configID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `config_key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`configID`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `ini_config` DISABLE KEYS */;
INSERT INTO `ini_config` (`configID`, `type`, `config_key`, `value`) VALUES
	(1, 'paypal', 'paypal_api_username', ''),
	(2, 'paypal', 'paypal_api_password', ''),
	(3, 'paypal', 'paypal_api_signature', ''),
	(4, 'paypal', 'paypal_email', ''),
	(5, 'paypal', 'paypal_demo', ''),
	(6, 'stripe', 'stripe_secret', ''),
	(8, 'stripe', 'stripe_demo', ''),
	(9, 'payumoney', 'payumoney_key', ''),
	(10, 'payumoney', 'payumoney_salt', ''),
	(11, 'payumoney', 'payumoney_demo', ''),
	(12, 'paypal', 'paypal_status', ''),
	(13, 'stripe', 'stripe_status', ''),
	(14, 'payumoney', 'payumoney_status', ''),
	(15, 'voguepay', 'voguepay_merchant_id', ''),
	(16, 'voguepay', 'voguepay_merchant_ref', ''),
	(17, 'voguepay', 'voguepay_developer_code', ''),
	(18, 'voguepay', 'voguepay_demo', ''),
	(19, 'voguepay', 'voguepay_status', '');
/*!40000 ALTER TABLE `ini_config` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `instruction` (
  `instructionID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(512) NOT NULL,
  `content` text NOT NULL,
  PRIMARY KEY (`instructionID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `instruction` DISABLE KEYS */;
INSERT INTO `instruction` (`instructionID`, `title`, `content`) VALUES
	(1, 'evaluaciones para clasificar en las olimpiadas de conocimiento', 'solo los que obtengan mejores calificaciones<br>');
/*!40000 ALTER TABLE `instruction` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `invoice` (
  `invoiceID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `feetypeID` int(11) DEFAULT NULL,
  `feetype` varchar(128) NOT NULL,
  `amount` double NOT NULL,
  `discount` double NOT NULL DEFAULT '0',
  `userID` int(11) DEFAULT NULL,
  `usertypeID` int(11) DEFAULT NULL,
  `uname` varchar(60) DEFAULT NULL,
  `date` date NOT NULL,
  `create_date` date NOT NULL,
  `day` varchar(20) DEFAULT NULL,
  `month` varchar(20) DEFAULT NULL,
  `year` year(4) NOT NULL,
  `paidstatus` int(11) DEFAULT NULL,
  `deleted_at` int(11) NOT NULL DEFAULT '1',
  `maininvoiceID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`invoiceID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `invoice` DISABLE KEYS */;
INSERT INTO `invoice` (`invoiceID`, `schoolyearID`, `classesID`, `studentID`, `feetypeID`, `feetype`, `amount`, `discount`, `userID`, `usertypeID`, `uname`, `date`, `create_date`, `day`, `month`, `year`, `paidstatus`, `deleted_at`, `maininvoiceID`) VALUES
	(1, 1, 2, 2, 1, 'Libros', 4, 0, 1, 1, 'admin', '2019-04-08', '2019-04-08', '08', '04', '2019', 1, 1, 1),
	(2, 1, 2, 2, 1, 'Libros', 4, 0, 1, 1, 'admin', '2019-04-18', '2019-04-18', '18', '04', '2019', 0, 1, 2),
	(3, 1, 2, 4, 3, 'Transporte', 3, 2, 1, 1, 'admin', '2019-04-18', '2019-04-18', '18', '04', '2019', 2, 1, 3),
	(4, 1, 2, 2, 1, 'Libros', 5, 0, 1, 1, 'admin', '2019-04-26', '2019-04-26', '26', '04', '2019', 1, 1, 4),
	(7, 1, 2, 2, 3, 'Transporte', 4, 0, 1, 1, 'admin', '2019-04-26', '2019-04-26', '26', '04', '2019', 2, 1, 5),
	(8, 1, 2, 2, 1, 'Libros', 6, 0, 1, 1, 'admin', '2019-04-26', '2019-04-26', '26', '04', '2019', 1, 1, 6);
/*!40000 ALTER TABLE `invoice` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `issue` (
  `issueID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `lID` varchar(128) NOT NULL,
  `bookID` int(11) NOT NULL,
  `serial_no` varchar(40) NOT NULL,
  `issue_date` date NOT NULL,
  `due_date` date NOT NULL,
  `return_date` date DEFAULT NULL,
  `note` text,
  PRIMARY KEY (`issueID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `issue` DISABLE KEYS */;
INSERT INTO `issue` (`issueID`, `lID`, `bookID`, `serial_no`, `issue_date`, `due_date`, `return_date`, `note`) VALUES
	(1, '201901', 8, '4124124', '2019-04-08', '2019-04-24', NULL, '');
/*!40000 ALTER TABLE `issue` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `leaveapplications` (
  `leaveapplicationID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `leavecategoryID` int(10) unsigned NOT NULL,
  `apply_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `od_status` tinyint(1) NOT NULL DEFAULT '0',
  `from_date` date NOT NULL,
  `from_time` time DEFAULT NULL,
  `to_date` date NOT NULL,
  `to_time` time DEFAULT NULL,
  `leave_days` int(11) NOT NULL,
  `reason` text,
  `attachment` varchar(200) DEFAULT NULL,
  `attachmentorginalname` varchar(200) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) unsigned NOT NULL,
  `applicationto_userID` int(11) unsigned DEFAULT NULL,
  `applicationto_usertypeID` int(11) unsigned DEFAULT NULL,
  `approver_userID` int(11) unsigned DEFAULT NULL,
  `approver_usertypeID` int(11) unsigned DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `schoolyearID` int(11) NOT NULL,
  PRIMARY KEY (`leaveapplicationID`),
  KEY `leave_categoryID` (`leavecategoryID`),
  KEY `from_date` (`from_date`),
  KEY `to_date` (`to_date`),
  KEY `approver_userID` (`approver_userID`),
  KEY `approver_usertypeID` (`approver_usertypeID`),
  KEY `applicationto_usertypeID` (`applicationto_usertypeID`),
  KEY `applicationto_userID` (`applicationto_userID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `leaveapplications` DISABLE KEYS */;
INSERT INTO `leaveapplications` (`leaveapplicationID`, `leavecategoryID`, `apply_date`, `od_status`, `from_date`, `from_time`, `to_date`, `to_time`, `leave_days`, `reason`, `attachment`, `attachmentorginalname`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`, `applicationto_userID`, `applicationto_usertypeID`, `approver_userID`, `approver_usertypeID`, `status`, `schoolyearID`) VALUES
	(1, 3, '2019-04-04 11:59:22', 0, '2019-04-04', '11:59:22', '2019-04-04', '11:59:22', 1, 'vaca', '', '', '2019-04-04 11:59:22', '2019-04-04 11:59:22', 3, 3, 1, 1, NULL, NULL, NULL, 1),
	(2, 2, '2019-04-10 15:21:41', 0, '2019-04-10', '15:21:41', '2019-04-10', '15:21:41', 1, 'motivo de trabajo', '', '', '2019-04-10 15:21:41', '2019-04-10 15:22:08', 4, 2, 1, 1, NULL, NULL, 1, 1);
/*!40000 ALTER TABLE `leaveapplications` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `leaveassign` (
  `leaveassignID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `leavecategoryID` int(10) unsigned NOT NULL,
  `usertypeID` int(11) unsigned NOT NULL,
  `leaveassignday` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`leaveassignID`),
  KEY `leave_categoryID` (`leavecategoryID`),
  KEY `usertypeID` (`usertypeID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `leaveassign` DISABLE KEYS */;
INSERT INTO `leaveassign` (`leaveassignID`, `leavecategoryID`, `usertypeID`, `leaveassignday`, `schoolyearID`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES
	(4, 3, 3, 4, 1, '2019-04-04 11:52:53', '2019-04-04 11:52:53', 1, 1),
	(5, 2, 2, 2, 1, '2019-04-10 15:21:19', '2019-04-10 15:21:19', 1, 1);
/*!40000 ALTER TABLE `leaveassign` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `leavecategory` (
  `leavecategoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `leavecategory` varchar(255) NOT NULL,
  `leavegender` int(11) DEFAULT '0' COMMENT '1 = General, 2 = Male, 3 = Femele',
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) unsigned NOT NULL,
  PRIMARY KEY (`leavecategoryID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `leavecategory` DISABLE KEYS */;
INSERT INTO `leavecategory` (`leavecategoryID`, `leavecategory`, `leavegender`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES
	(1, 'salud', 1, '2019-03-26 18:21:38', '2019-03-26 18:21:38', 1, 1),
	(2, 'trabajo', 1, '2019-03-26 18:21:48', '2019-03-26 18:21:48', 1, 1),
	(3, 'vacación', 3, '2019-03-26 18:22:03', '2019-03-26 18:24:17', 1, 1),
	(4, 'actividades', 2, '2019-04-10 15:20:04', '2019-04-10 15:20:34', 1, 1);
/*!40000 ALTER TABLE `leavecategory` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `lmember` (
  `lmemberID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `lID` varchar(40) NOT NULL,
  `studentID` int(11) NOT NULL,
  `name` varchar(60) NOT NULL,
  `email` varchar(40) DEFAULT NULL,
  `phone` tinytext,
  `lbalance` varchar(20) DEFAULT NULL,
  `ljoindate` date NOT NULL,
  PRIMARY KEY (`lmemberID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `lmember` DISABLE KEYS */;
INSERT INTO `lmember` (`lmemberID`, `lID`, `studentID`, `name`, `email`, `phone`, `lbalance`, `ljoindate`) VALUES
	(1, '201901', 2, 'JULIETA ROJAS LUNA', 'JULI@GMAIL.COM', '', '50', '2019-04-08');
/*!40000 ALTER TABLE `lmember` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `location` (
  `locationID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `location` varchar(128) NOT NULL,
  `description` text,
  `create_date` date NOT NULL,
  `modify_date` date NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  `active` int(11) NOT NULL,
  PRIMARY KEY (`locationID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `location` DISABLE KEYS */;
INSERT INTO `location` (`locationID`, `location`, `description`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`, `active`) VALUES
	(1, 'Avenida Principal #1204', '', '2019-04-26', '2019-04-26', 1, 1, 1);
/*!40000 ALTER TABLE `location` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `loginlog` (
  `loginlogID` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(45) DEFAULT NULL,
  `browser` varchar(128) DEFAULT NULL,
  `operatingsystem` varchar(128) DEFAULT NULL,
  `login` int(11) unsigned DEFAULT NULL,
  `logout` int(11) unsigned DEFAULT NULL,
  `usertypeID` int(11) DEFAULT NULL,
  `userID` int(11) DEFAULT NULL,
  PRIMARY KEY (`loginlogID`)
) ENGINE=InnoDB AUTO_INCREMENT=170 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `loginlog` DISABLE KEYS */;
INSERT INTO `loginlog` (`loginlogID`, `ip`, `browser`, `operatingsystem`, `login`, `logout`, `usertypeID`, `userID`) VALUES
	(1, '127.0.0.1', 'Mozilla Firefox', 'windows', 1549096771, 1549097071, 1, 1),
	(2, '127.0.0.1', 'Mozilla Firefox', 'windows', 1549098214, 1549098932, 1, 1),
	(3, '127.0.0.1', 'Mozilla Firefox', 'windows', 1549099559, 1549103393, 1, 1),
	(4, '127.0.0.1', 'Mozilla Firefox', 'windows', 1549103405, 1549104520, 1, 1),
	(5, '127.0.0.1', 'Mozilla Firefox', 'windows', 1549104525, 1549105039, 1, 1),
	(6, '127.0.0.1', 'Mozilla Firefox', 'windows', 1549105381, 1549105681, 1, 1),
	(7, '127.0.0.1', 'Mozilla Firefox', 'windows', 1549206634, 1549206934, 1, 1),
	(8, '127.0.0.1', 'Mozilla Firefox', 'windows', 1549181603, 1549181903, 1, 1),
	(9, '127.0.0.1', 'Mozilla Firefox', 'windows', 1549433189, 1549433489, 1, 1),
	(10, '127.0.0.1', 'Mozilla Firefox', 'windows', 1552388212, 1552388512, 1, 1),
	(11, '127.0.0.1', 'Mozilla Firefox', 'windows', 1552634240, 1552634540, 1, 1),
	(12, '127.0.0.1', 'Mozilla Firefox', 'windows', 1552900503, 1552900803, 1, 1),
	(13, '127.0.0.1', 'Mozilla Firefox', 'windows', 1552973867, 1552974167, 1, 1),
	(14, '127.0.0.1', 'Mozilla Firefox', 'windows', 1552987467, 1552987767, 1, 1),
	(15, '127.0.0.1', 'Mozilla Firefox', 'windows', 1552988178, 1552995249, 1, 1),
	(16, '127.0.0.1', 'Google Chrome', 'windows', 1552995194, 1552995238, 1, 1),
	(17, '127.0.0.1', 'Mozilla Firefox', 'windows', 1552995471, 1552995771, 1, 1),
	(18, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553087955, 1553088255, 1, 1),
	(19, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553062051, 1553065521, 1, 1),
	(20, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553065983, 1553066283, 1, 1),
	(21, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553081331, 1553084835, 1, 1),
	(22, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553175052, 1553175352, 1, 1),
	(23, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553184564, 1553184864, 1, 1),
	(24, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553171171, 1553171471, 1, 1),
	(25, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553250277, 1553256113, 1, 1),
	(26, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553354373, 1553354673, 1, 1),
	(27, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553322899, 1553323199, 1, 1),
	(28, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553334068, 1553334368, 1, 1),
	(29, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553434973, 1553439516, 1, 1),
	(30, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553406909, 1553406981, 1, 1),
	(31, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553407378, 1553407678, 1, 1),
	(32, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553525807, 1553525896, 1, 1),
	(33, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553525996, 1553526247, 1, 1),
	(34, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553527842, 1553527858, 1, 1),
	(35, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553527899, 1553491937, 1, 1),
	(36, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553491946, 1553500071, 1, 1),
	(37, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553500213, 1553500513, 1, 1),
	(38, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553508308, 1553513896, 1, 1),
	(39, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553579878, 1553581149, 1, 1),
	(40, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553581153, 1553585954, 1, 1),
	(41, '127.0.0.1', 'Google Chrome', 'windows', 1553583645, 1553583945, 1, 1),
	(42, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553594434, 1553594734, 1, 1),
	(43, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553663819, 1553670502, 1, 1),
	(44, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553688898, 1553694207, 1, 1),
	(45, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553694218, 1553694224, 1, 1),
	(46, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553695253, 1553695284, 1, 1),
	(47, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553695370, 1553696564, 1, 1),
	(48, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553696621, 1553696983, 1, 1),
	(49, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553696988, 1553697091, 1, 1),
	(50, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553697098, 1553697515, 1, 1),
	(51, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553767910, 1553768210, 1, 1),
	(52, '127.0.0.1', 'Mozilla Firefox', 'windows', 1553865107, 1553865407, 1, 1),
	(53, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554133213, 1554133513, 1, 1),
	(54, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554388931, 1554395192, 1, 1),
	(55, '127.0.0.1', 'Google Chrome', 'windows', 1554392602, NULL, 3, 3),
	(56, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554395199, 1554395204, 1, 1),
	(57, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554395280, 1554395301, 1, 1),
	(58, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554395312, 1554395330, 1, 1),
	(59, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554395343, 1554395350, 1, 1),
	(60, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554395368, 1554395378, 1, 1),
	(61, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554395389, 1554395415, 1, 1),
	(62, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554395519, 1554395594, 1, 1),
	(63, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554395985, 1554395994, 1, 1),
	(64, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554396093, 1554396107, 1, 1),
	(65, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554367759, 1554368260, 1, 1),
	(66, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554369414, 1554369714, 1, 1),
	(67, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554472649, 1554474057, 1, 1),
	(68, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554474498, 1554474798, 1, 1),
	(69, '127.0.0.1', 'Google Chrome', 'windows', 1554477076, 1554477376, 1, 1),
	(70, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554443345, 1554445904, 1, 1),
	(71, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554445994, 1554447065, 1, 1),
	(72, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554462931, 1554464773, 1, 1),
	(73, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554465057, 1554465066, 1, 1),
	(74, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554465076, 1554465088, 1, 1),
	(75, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554465118, 1554465418, 1, 1),
	(76, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554543555, 1554543855, 1, 1),
	(77, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554643226, 1554643526, 1, 1),
	(78, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554706759, 1554706969, 1, 1),
	(79, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554706973, 1554706990, 1, 1),
	(80, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554707027, 1554707354, 1, 1),
	(81, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554707359, 1554707377, 1, 1),
	(82, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554707379, 1554707699, 1, 1),
	(83, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554707701, 1554708001, 1, 1),
	(84, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554721695, 1554725175, 1, 1),
	(85, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554725180, 1554725480, 1, 1),
	(86, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554787479, 1554787779, 1, 1),
	(87, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554811025, 1554811325, 1, 1),
	(88, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554903613, 1554903913, 1, 1),
	(89, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554880452, 1554880752, 1, 1),
	(90, '127.0.0.1', 'Google Chrome', 'windows', 1554880697, 1554880997, 2, 4),
	(91, '127.0.0.1', 'Mozilla Firefox', 'windows', 1554974813, 1554975113, 1, 1),
	(92, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555054405, 1555054705, 1, 1),
	(93, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555145127, 1555146440, 1, 1),
	(94, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555146443, 1555148188, 1, 1),
	(95, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555148191, 1555148317, 1, 1),
	(96, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555148319, 1555148619, 1, 1),
	(97, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555333458, 1555333758, 1, 1),
	(98, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555491534, 1555495073, 1, 1),
	(99, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555495084, 1555495105, 1, 1),
	(100, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555495125, 1555495141, 1, 1),
	(101, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555495168, 1555495182, 1, 1),
	(102, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555495187, 1555495196, 1, 1),
	(103, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555495234, 1555495256, 1, 1),
	(104, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555495265, 1555495298, 1, 1),
	(105, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555495306, 1555495319, 1, 1),
	(106, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555495328, 1555495352, 1, 1),
	(107, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555495368, 1555495383, 1, 1),
	(108, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555496161, 1555496177, 1, 1),
	(109, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555496214, 1555496229, 1, 1),
	(110, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555496385, 1555496401, 1, 1),
	(111, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555496407, 1555496422, 1, 1),
	(112, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555496594, 1555496608, 1, 1),
	(113, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555497086, 1555497386, 1, 1),
	(114, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555568372, 1555573105, 1, 1),
	(115, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555573116, 1555574932, 1, 1),
	(116, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555574934, 1555575742, 1, 1),
	(117, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555575745, 1555575784, 1, 1),
	(118, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555575818, 1555575827, 1, 1),
	(119, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555575830, 1555575903, 1, 1),
	(120, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555575907, 1555576207, 1, 1),
	(121, '127.0.0.1', 'Mozilla Firefox', 'windows', 1555932226, 1555932526, 1, 1),
	(122, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556114598, 1556114898, 1, 1),
	(123, '127.0.0.1', 'Google Chrome', 'windows', 1556116344, 1556116350, 1, 1),
	(124, '127.0.0.1', 'Google Chrome', 'windows', 1556116361, 1556116661, 2, 4),
	(125, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556290702, 1556291002, 1, 1),
	(126, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556263478, 1556263778, 1, 1),
	(127, '127.0.0.1', 'Google Chrome', 'windows', 1556263762, 1556264062, 1, 1),
	(128, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556276278, 1556278144, 1, 1),
	(129, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556279741, 1556281721, 1, 1),
	(130, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556371237, 1556371537, 1, 1),
	(131, '127.0.0.1', 'Google Chrome', 'windows', 1556371432, 1556371732, 3, 2),
	(132, '127.0.0.1', 'Google Chrome', 'windows', 1556371493, NULL, 2, 4),
	(133, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556804938, 1556805238, 1, 1),
	(134, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556891440, 1556895382, 1, 1),
	(135, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556895388, 1556895488, 1, 1),
	(136, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556896114, 1556896630, 1, 1),
	(137, '127.0.0.1', 'Google Chrome', 'windows', 1556896430, 1556897320, 2, 8),
	(138, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556897162, 1556897825, 1, 1),
	(139, '127.0.0.1', 'Google Chrome', 'windows', 1556897694, 1556897704, 4, 19),
	(140, '127.0.0.1', 'Google Chrome', 'windows', 1556897709, 1556897715, 5, 2),
	(141, '127.0.0.1', 'Google Chrome', 'windows', 1556897720, 1556897746, 6, 3),
	(142, '127.0.0.1', 'Google Chrome', 'windows', 1556897751, 1556897761, 7, 4),
	(143, '127.0.0.1', 'Google Chrome', 'windows', 1556897769, 1556897773, 3, 19),
	(144, '127.0.0.1', 'Google Chrome', 'windows', 1556897778, 1556862232, 2, 8),
	(145, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556862212, 1556863831, 1, 1),
	(146, '127.0.0.1', 'Google Chrome', 'windows', 1556862238, 1556864337, 1, 1),
	(147, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556863867, 1556870060, 1, 1),
	(148, '127.0.0.1', 'Google Chrome', 'windows', 1556864478, 1556864778, 1, 1),
	(149, '127.0.0.1', 'Google Chrome', 'windows', 1556864539, 1556866802, 2, 8),
	(150, '127.0.0.1', 'Google Chrome', 'windows', 1556866811, 1556866817, 1, 1),
	(151, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556871105, 1556871133, 1, 1),
	(152, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556871214, 1556873262, 1, 1),
	(153, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556877655, 1556878240, 1, 1),
	(154, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556883224, 1556883524, 1, 1),
	(155, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556977536, 1556977836, 1, 1),
	(156, '127.0.0.1', 'Google Chrome', 'windows', 1556978558, 1556978858, 1, 1),
	(157, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556952157, 1556953800, 1, 1),
	(158, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556953817, 1556953828, 1, 1),
	(159, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556953835, 1556953852, 1, 1),
	(160, '127.0.0.1', 'Google Chrome', 'windows', 1556957559, 1556957593, 1, 1),
	(161, '127.0.0.1', 'Google Chrome', 'windows', 1556957604, 1556958526, 3, 19),
	(162, '127.0.0.1', 'Google Chrome', 'windows', 1556957645, 1556959580, 1, 1),
	(163, '127.0.0.1', 'Google Chrome', 'windows', 1556958530, 1556958622, 3, 19),
	(164, '127.0.0.1', 'Google Chrome', 'windows', 1556958626, 1556959599, 3, 19),
	(165, '127.0.0.1', 'Google Chrome', 'windows', 1556959615, NULL, 3, 2),
	(166, '127.0.0.1', 'Google Chrome', 'windows', 1556959750, NULL, 1, 1),
	(167, '127.0.0.1', 'Mozilla Firefox', 'windows', 1556962974, 1556963274, 1, 1),
	(168, '127.0.0.1', 'Mozilla Firefox', 'windows', 1557062016, 1557067112, 1, 1),
	(169, '127.0.0.1', 'Mozilla Firefox', 'windows', 1557067701, NULL, 1, 1);
/*!40000 ALTER TABLE `loginlog` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `mailandsms` (
  `mailandsmsID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `usertypeID` int(11) NOT NULL,
  `users` text NOT NULL,
  `type` varchar(16) NOT NULL,
  `senderusertypeID` int(11) NOT NULL,
  `senderID` int(11) NOT NULL,
  `message` text NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `year` year(4) NOT NULL,
  PRIMARY KEY (`mailandsmsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `mailandsms` DISABLE KEYS */;
/*!40000 ALTER TABLE `mailandsms` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `mailandsmstemplate` (
  `mailandsmstemplateID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `type` varchar(10) NOT NULL,
  `template` text NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`mailandsmstemplateID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `mailandsmstemplate` DISABLE KEYS */;
INSERT INTO `mailandsmstemplate` (`mailandsmstemplateID`, `name`, `usertypeID`, `type`, `template`, `create_date`) VALUES
	(1, 'revisar calificaciones', 3, 'email', 'Al estudiante [name] se recomienda revisar las calificaciones de este mes<br>', '2019-04-05 14:46:50');
/*!40000 ALTER TABLE `mailandsmstemplate` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `mailandsmstemplatetag` (
  `mailandsmstemplatetagID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `usertypeID` int(11) NOT NULL,
  `tagname` varchar(128) NOT NULL,
  `mailandsmstemplatetag_extra` varchar(255) DEFAULT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`mailandsmstemplatetagID`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `mailandsmstemplatetag` DISABLE KEYS */;
INSERT INTO `mailandsmstemplatetag` (`mailandsmstemplatetagID`, `usertypeID`, `tagname`, `mailandsmstemplatetag_extra`, `create_date`) VALUES
	(1, 1, '[name]', NULL, '2016-12-10 20:36:33'),
	(2, 1, '[dob]', NULL, '2016-12-10 20:37:31'),
	(3, 1, '[gender]', NULL, '2016-12-10 20:37:31'),
	(4, 1, '[religion]', NULL, '2016-12-10 20:39:51'),
	(5, 1, '[email]', NULL, '2016-12-10 20:39:51'),
	(6, 1, '[phone]', NULL, '2016-12-10 20:39:51'),
	(7, 1, '[address]', NULL, '2016-12-10 20:39:51'),
	(8, 1, '[jod]', NULL, '2016-12-10 20:39:51'),
	(9, 1, '[username]', NULL, '2016-12-10 20:39:51'),
	(10, 2, '[name]', NULL, '2016-12-10 20:40:50'),
	(11, 2, '[designation]', NULL, '2016-12-10 20:43:27'),
	(12, 2, '[dob]', NULL, '2016-12-10 20:46:21'),
	(13, 2, '[gender]', NULL, '2016-12-10 20:46:21'),
	(14, 2, '[religion]', NULL, '2016-12-10 20:46:21'),
	(15, 2, '[email]', NULL, '2016-12-10 20:46:21'),
	(16, 2, '[phone]', NULL, '2016-12-10 20:46:21'),
	(17, 2, '[address]', NULL, '2016-12-10 20:46:21'),
	(18, 2, '[jod]', NULL, '2016-12-10 20:46:21'),
	(19, 2, '[username]', NULL, '2016-12-10 20:46:21'),
	(20, 3, '[name]', NULL, '2016-12-10 20:47:09'),
	(21, 3, '[dob]', NULL, '2016-12-10 20:55:54'),
	(22, 3, '[gender]', NULL, '2016-12-10 20:55:54'),
	(23, 3, '[blood_group]', NULL, '2016-12-10 20:55:54'),
	(24, 3, '[religion]', NULL, '2016-12-10 20:55:54'),
	(25, 3, '[email]', NULL, '2016-12-10 20:55:54'),
	(26, 3, '[phone]', NULL, '2016-12-10 20:55:54'),
	(27, 3, '[address]', NULL, '2016-12-10 20:55:54'),
	(28, 3, '[state]', NULL, '2017-02-11 18:21:49'),
	(29, 3, '[country]', NULL, '2017-02-11 18:21:27'),
	(30, 3, '[class]', NULL, '2016-12-18 21:34:20'),
	(31, 3, '[section]', NULL, '2016-12-10 20:55:54'),
	(32, 3, '[group]', NULL, '2016-12-10 20:55:54'),
	(33, 3, '[optional_subject]', NULL, '2016-12-10 20:55:54'),
	(34, 3, '[register_no]', NULL, '2017-02-11 18:21:27'),
	(35, 3, '[roll]', NULL, '2017-02-11 18:22:56'),
	(36, 3, '[extra_curricular_activities]', NULL, '2017-02-11 18:22:56'),
	(37, 3, '[remarks]', NULL, '2017-02-11 18:22:56'),
	(38, 3, '[username]', NULL, '2016-12-10 20:55:54'),
	(39, 3, '[result_table]', NULL, '2016-12-10 20:55:54'),
	(40, 4, '[name]', NULL, '2016-12-10 20:57:31'),
	(41, 4, '[father\'s_name]', NULL, '2016-12-10 21:04:19'),
	(42, 4, '[mother\'s_name]', NULL, '2016-12-10 21:04:19'),
	(43, 4, '[father\'s_profession]', NULL, '2016-12-10 21:04:19'),
	(44, 4, '[mother\'s_profession]', NULL, '2016-12-10 21:04:19'),
	(45, 4, '[email]', NULL, '2016-12-10 21:04:19'),
	(46, 4, '[phone]', NULL, '2016-12-10 21:04:19'),
	(47, 4, '[address]', NULL, '2016-12-10 21:04:19'),
	(48, 4, '[username]', NULL, '2016-12-10 21:04:19'),
	(49, 1, '[date]', NULL, '2018-05-11 10:12:12'),
	(50, 2, '[date]', NULL, '2018-05-11 10:12:27'),
	(51, 3, '[date]', NULL, '2018-05-11 10:12:36'),
	(52, 4, '[date]', NULL, '2018-05-11 10:12:49');
/*!40000 ALTER TABLE `mailandsmstemplatetag` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `maininvoice` (
  `maininvoiceID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `maininvoiceschoolyearID` int(11) NOT NULL,
  `maininvoiceclassesID` int(11) NOT NULL,
  `maininvoicestudentID` int(11) NOT NULL,
  `maininvoiceuserID` int(11) DEFAULT NULL,
  `maininvoiceusertypeID` int(11) DEFAULT NULL,
  `maininvoiceuname` varchar(60) DEFAULT NULL,
  `maininvoicedate` date NOT NULL,
  `maininvoicecreate_date` date NOT NULL,
  `maininvoiceday` varchar(20) DEFAULT NULL,
  `maininvoicemonth` varchar(20) DEFAULT NULL,
  `maininvoiceyear` year(4) NOT NULL,
  `maininvoicestatus` int(11) DEFAULT NULL,
  `maininvoicedeleted_at` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`maininvoiceID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `maininvoice` DISABLE KEYS */;
INSERT INTO `maininvoice` (`maininvoiceID`, `maininvoiceschoolyearID`, `maininvoiceclassesID`, `maininvoicestudentID`, `maininvoiceuserID`, `maininvoiceusertypeID`, `maininvoiceuname`, `maininvoicedate`, `maininvoicecreate_date`, `maininvoiceday`, `maininvoicemonth`, `maininvoiceyear`, `maininvoicestatus`, `maininvoicedeleted_at`) VALUES
	(1, 1, 2, 2, 1, 1, 'admin', '2019-04-08', '2019-04-08', '08', '04', '2019', 1, 1),
	(2, 1, 2, 2, 1, 1, 'admin', '2019-04-18', '2019-04-18', '18', '04', '2019', 0, 1),
	(3, 1, 2, 4, 1, 1, 'admin', '2019-04-18', '2019-04-18', '18', '04', '2019', 2, 1),
	(4, 1, 2, 2, 1, 1, 'admin', '2019-04-26', '2019-04-26', '26', '04', '2019', 1, 1),
	(5, 1, 2, 2, 1, 1, 'admin', '2019-04-26', '2019-04-26', '26', '04', '2019', 2, 1),
	(6, 1, 2, 2, 1, 1, 'admin', '2019-04-26', '2019-04-26', '26', '04', '2019', 1, 1);
/*!40000 ALTER TABLE `maininvoice` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `make_payment` (
  `make_paymentID` int(11) NOT NULL AUTO_INCREMENT,
  `month` text NOT NULL,
  `gross_salary` text NOT NULL,
  `total_deduction` text NOT NULL,
  `net_salary` text NOT NULL,
  `payment_amount` text NOT NULL,
  `payment_method` int(11) NOT NULL,
  `comments` text,
  `templateID` int(11) NOT NULL,
  `salaryID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `schoolyearID` int(11) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(60) NOT NULL,
  `create_usertype` varchar(60) NOT NULL,
  `total_hours` text,
  PRIMARY KEY (`make_paymentID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `make_payment` DISABLE KEYS */;
INSERT INTO `make_payment` (`make_paymentID`, `month`, `gross_salary`, `total_deduction`, `net_salary`, `payment_amount`, `payment_method`, `comments`, `templateID`, `salaryID`, `usertypeID`, `userID`, `schoolyearID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`, `total_hours`) VALUES
	(1, '04-2019', '100', '100', '200', '200', 1, '', 1, 1, 2, 4, 1, '2019-04-24 11:01:51', '2019-04-24 11:01:51', 1, 'admin', 'Admin', NULL);
/*!40000 ALTER TABLE `make_payment` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `manage_salary` (
  `manage_salaryID` int(11) NOT NULL AUTO_INCREMENT,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `salary` int(11) NOT NULL,
  `template` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(60) NOT NULL,
  `create_usertype` varchar(60) NOT NULL,
  PRIMARY KEY (`manage_salaryID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `manage_salary` DISABLE KEYS */;
INSERT INTO `manage_salary` (`manage_salaryID`, `userID`, `usertypeID`, `salary`, `template`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`) VALUES
	(1, 4, 2, 1, 1, '2019-04-24 11:01:27', '2019-04-24 11:01:27', 1, 'admin', 'Admin');
/*!40000 ALTER TABLE `manage_salary` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `mark` (
  `markID` int(200) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `examID` int(11) NOT NULL,
  `exam` varchar(60) NOT NULL,
  `studentID` int(11) NOT NULL,
  `classesID` int(11) NOT NULL,
  `subjectID` int(11) NOT NULL,
  `subject` varchar(60) NOT NULL,
  `year` year(4) NOT NULL,
  `create_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL DEFAULT '0',
  `create_usertypeID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`markID`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `mark` DISABLE KEYS */;
INSERT INTO `mark` (`markID`, `schoolyearID`, `examID`, `exam`, `studentID`, `classesID`, `subjectID`, `subject`, `year`, `create_date`, `create_userID`, `create_usertypeID`) VALUES
	(1, 1, 2, 'examen de ciencias', 2, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(2, 1, 2, 'examen de ciencias', 4, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(3, 1, 2, 'examen de ciencias', 5, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(4, 1, 2, 'examen de ciencias', 6, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(5, 1, 2, 'examen de ciencias', 8, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(6, 1, 2, 'examen de ciencias', 9, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(7, 1, 2, 'examen de ciencias', 10, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(8, 1, 2, 'examen de ciencias', 11, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(9, 1, 2, 'examen de ciencias', 1, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(10, 1, 2, 'examen de ciencias', 12, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(11, 1, 2, 'examen de ciencias', 13, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(12, 1, 2, 'examen de ciencias', 14, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(13, 1, 2, 'examen de ciencias', 15, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(14, 1, 2, 'examen de ciencias', 16, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(15, 1, 2, 'examen de ciencias', 17, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(16, 1, 2, 'examen de ciencias', 18, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(17, 1, 2, 'examen de ciencias', 3, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1),
	(18, 1, 2, 'examen de ciencias', 7, 2, 1, 'MATEMÁTICA', '2019', '2019-04-26 11:06:07', 1, 1);
/*!40000 ALTER TABLE `mark` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `markpercentage` (
  `markpercentageID` int(11) NOT NULL AUTO_INCREMENT,
  `markpercentagetype` varchar(100) NOT NULL,
  `percentage` double NOT NULL,
  `examID` int(11) DEFAULT NULL,
  `classesID` int(11) DEFAULT NULL,
  `subjectID` int(11) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(60) NOT NULL,
  `create_usertype` varchar(60) NOT NULL,
  PRIMARY KEY (`markpercentageID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `markpercentage` DISABLE KEYS */;
INSERT INTO `markpercentage` (`markpercentageID`, `markpercentagetype`, `percentage`, `examID`, `classesID`, `subjectID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`) VALUES
	(1, 'Exam', 100, NULL, NULL, NULL, '2017-01-05 06:11:54', '2017-01-05 06:12:08', 1, 'admin', 'Admin');
/*!40000 ALTER TABLE `markpercentage` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `markrelation` (
  `markrelationID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `markID` int(11) NOT NULL,
  `markpercentageID` int(11) NOT NULL,
  `mark` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`markrelationID`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `markrelation` DISABLE KEYS */;
INSERT INTO `markrelation` (`markrelationID`, `markID`, `markpercentageID`, `mark`) VALUES
	(1, 1, 1, '45'),
	(2, 2, 1, '50'),
	(3, 3, 1, '70'),
	(4, 4, 1, '80'),
	(5, 5, 1, '77'),
	(6, 6, 1, '43'),
	(7, 7, 1, '65'),
	(8, 8, 1, '98'),
	(9, 9, 1, '100'),
	(10, 10, 1, '38'),
	(11, 11, 1, '19'),
	(12, 12, 1, '44'),
	(13, 13, 1, '77'),
	(14, 14, 1, '54'),
	(15, 15, 1, '76'),
	(16, 16, 1, '63'),
	(17, 17, 1, '53'),
	(18, 18, 1, '54');
/*!40000 ALTER TABLE `markrelation` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `media` (
  `mediaID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `mcategoryID` int(11) NOT NULL DEFAULT '0',
  `file_name` varchar(255) NOT NULL,
  `file_name_display` varchar(255) NOT NULL,
  PRIMARY KEY (`mediaID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `media` DISABLE KEYS */;
INSERT INTO `media` (`mediaID`, `userID`, `usertypeID`, `mcategoryID`, `file_name`, `file_name_display`) VALUES
	(1, 1, 1, 0, '5255729350953545471.jpg', 'castillo1.jpg'),
	(2, 1, 1, 0, '8707805256358259758.jpg', '500x_froyo.jpg'),
	(3, 1, 1, 0, '2263484908964581077.pdf', '00-Contenido.pdf');
/*!40000 ALTER TABLE `media` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `media_category` (
  `mcategoryID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `folder_name` varchar(255) NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`mcategoryID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `media_category` DISABLE KEYS */;
INSERT INTO `media_category` (`mcategoryID`, `userID`, `usertypeID`, `folder_name`, `create_time`) VALUES
	(1, 1, 1, 'imagenes', '2019-04-05 14:04:32'),
	(2, 1, 1, 'manuales pdf', '2019-04-05 14:04:43');
/*!40000 ALTER TABLE `media_category` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `media_gallery` (
  `media_galleryID` int(11) NOT NULL AUTO_INCREMENT,
  `media_gallery_type` int(11) NOT NULL,
  `file_type` varchar(40) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `file_original_name` varchar(255) DEFAULT NULL,
  `file_title` text NOT NULL,
  `file_size` varchar(40) DEFAULT NULL,
  `file_width_height` varchar(40) DEFAULT NULL,
  `file_upload_date` datetime DEFAULT NULL,
  `file_caption` text,
  `file_alt_text` varchar(255) DEFAULT NULL,
  `file_description` text,
  `file_length` varchar(128) DEFAULT NULL,
  `file_artist` varchar(128) DEFAULT NULL,
  `file_album` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`media_galleryID`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `media_gallery` DISABLE KEYS */;
INSERT INTO `media_gallery` (`media_galleryID`, `media_gallery_type`, `file_type`, `file_name`, `file_original_name`, `file_title`, `file_size`, `file_width_height`, `file_upload_date`, `file_caption`, `file_alt_text`, `file_description`, `file_length`, `file_artist`, `file_album`) VALUES
	(10, 1, 'jpg', '1d57bf3b819d5c7655ca617f487926934e5ed8a42c6d2179aa912abeb29cf917afe06e7963c96cf33242e30292ccf8142cd9ca4e6cf8401e268877708697df3b.jpg', 'LESSON PRO.jpg', 'LESSON PRO', '136.94 KB', '1349 x 645', '2019-04-10 10:54:12', NULL, NULL, NULL, NULL, NULL, NULL),
	(11, 1, 'jpg', 'f49d8aa928fdc652c75ca2d62a7343c4e0ec26c56d9251603dfdb8fb38641e01404feedd1bfef9746109ca38c0cf91deec318dc146396e8bc7231f8493e2d7c4.jpg', 'SCHOOL.jpg', 'SCHOOL', '131.56 KB', '1349 x 645', '2019-04-10 10:54:31', NULL, NULL, NULL, NULL, NULL, NULL),
	(12, 1, 'jpg', '0d44b2a3bda4a6a43fec191a1497d855d1ae1cd8590d9956deadb940cbe18b8f2c92a4f45e75de347f22edb20bac1695bf8dbea0856fb80103d1356e0cf525d1.jpg', 'school.jpg', 'school', '102.44 KB', '1008 x 516', '2019-04-10 11:18:01', NULL, NULL, NULL, NULL, NULL, NULL),
	(13, 1, 'jpg', 'c23b4f873d7f41d6050730c558a7d725b3a2124c3871d33d579dca16940a7ca97e89b401becb710749cdd288051e4722888038fa9dc7f9004a895ad358f4b827.jpg', 'clases.jpg', 'clases', '1.85 MB', '1600 x 1200', '2019-04-10 11:23:08', NULL, NULL, NULL, NULL, NULL, NULL);
/*!40000 ALTER TABLE `media_gallery` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `media_share` (
  `shareID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `classesID` int(11) NOT NULL DEFAULT '0',
  `public` int(11) NOT NULL,
  `file_or_folder` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`shareID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `media_share` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_share` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `menu` (
  `menuID` int(11) NOT NULL AUTO_INCREMENT,
  `menuName` varchar(128) NOT NULL,
  `link` varchar(512) NOT NULL,
  `icon` varchar(128) DEFAULT NULL,
  `pullRight` text,
  `status` int(11) NOT NULL DEFAULT '1',
  `parentID` int(11) NOT NULL DEFAULT '0',
  `priority` int(11) NOT NULL DEFAULT '1000',
  PRIMARY KEY (`menuID`)
) ENGINE=InnoDB AUTO_INCREMENT=150 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `menu` DISABLE KEYS */;
INSERT INTO `menu` (`menuID`, `menuName`, `link`, `icon`, `pullRight`, `status`, `parentID`, `priority`) VALUES
	(1, 'dashboard', 'dashboard', 'fa-laptop', '', 1, 0, 10000),
	(2, 'student', 'student', 'icon-student', NULL, 1, 0, 1000),
	(3, 'parents', 'parents', 'fa-user', NULL, 1, 0, 1000),
	(4, 'teacher', 'teacher', 'icon-teacher', NULL, 1, 0, 1000),
	(5, 'user', 'user', 'fa-users', NULL, 1, 0, 1000),
	(6, 'main_academic', '#', 'icon-academicmain', '', 1, 0, 1000),
	(7, 'main_attendance', '#', 'icon-attendance', NULL, 1, 0, 1000),
	(8, 'main_exam', '#', 'icon-exam', NULL, 1, 0, 1000),
	(9, 'main_mark', '#', 'icon-markmain', NULL, 1, 0, 1000),
	(10, 'conversation', 'conversation', 'fa-envelope', NULL, 1, 0, 1000),
	(11, 'media', 'media', 'fa-film', NULL, 1, 0, 1000),
	(12, 'mailandsms', 'mailandsms', 'icon-mailandsms', NULL, 1, 0, 1000),
	(13, 'main_library', '#', 'icon-library', '', 1, 0, 390),
	(14, 'main_transport', '#', 'icon-bus', '', 1, 0, 350),
	(15, 'main_hostel', '#', 'icon-hhostel', '', 1, 0, 320),
	(16, 'main_account', '#', 'icon-account', '', 1, 0, 280),
	(17, 'main_announcement', '#', 'icon-noticemain', '', 1, 0, 230),
	(18, 'main_report', '#', 'fa-clipboard', '', 1, 0, 190),
	(19, 'visitorinfo', 'visitorinfo', 'icon-visitorinfo', '', 1, 0, 150),
	(20, 'main_administrator', '#', 'icon-administrator', '', 1, 0, 140),
	(21, 'main_settings', '#', 'fa-gavel', '', 1, 0, 30),
	(22, 'classes', 'classes', 'fa-sitemap', NULL, 1, 6, 5000),
	(23, 'section', 'section', 'fa-star', '', 1, 6, 4500),
	(24, 'subject', 'subject', 'icon-subject', '', 1, 6, 4000),
	(25, 'routine', 'routine', 'icon-routine', NULL, 1, 6, 1000),
	(26, 'syllabus', 'syllabus', 'icon-syllabus', NULL, 1, 6, 3500),
	(27, 'assignment', 'assignment', 'icon-assignment', NULL, 1, 6, 3000),
	(28, 'sattendance', 'sattendance', 'icon-sattendance', NULL, 1, 7, 1000),
	(29, 'tattendance', 'tattendance', 'icon-tattendance', NULL, 1, 7, 1000),
	(30, 'exam', 'exam', 'fa-pencil', NULL, 1, 8, 1000),
	(31, 'examschedule', 'examschedule', 'fa-puzzle-piece', NULL, 1, 8, 1000),
	(32, 'grade', 'grade', 'fa-signal', NULL, 1, 8, 1000),
	(33, 'eattendance', 'eattendance', 'icon-eattendance', NULL, 1, 8, 1000),
	(34, 'mark', 'mark', 'fa-flask', NULL, 1, 9, 1000),
	(35, 'markpercentage', 'markpercentage', 'icon-markpercentage', NULL, 1, 9, 1000),
	(36, 'promotion', 'promotion', 'icon-promotion', NULL, 1, 9, 1000),
	(37, 'notice', 'notice', 'fa-calendar', '', 1, 17, 220),
	(38, 'event', 'event', 'fa-calendar-check-o', '', 1, 17, 210),
	(39, 'holiday', 'holiday', 'icon-holiday', '', 1, 17, 200),
	(40, 'classreport', 'classesreport', 'icon-classreport', '', 1, 18, 1000),
	(41, 'attendancereport', 'attendancereport', 'icon-attendancereport', '', 1, 18, 940),
	(42, 'studentreport', 'studentreport', 'icon-studentreport', '', 1, 18, 990),
	(43, 'schoolyear', 'schoolyear', 'fa fa-calendar-plus-o', '', 1, 20, 130),
	(44, 'mailandsmstemplate', 'mailandsmstemplate', 'icon-template', '', 1, 20, 100),
	(46, 'backup', 'backup', 'fa-download', '', 1, 20, 80),
	(47, 'systemadmin', 'systemadmin', 'icon-systemadmin', '', 1, 20, 120),
	(48, 'resetpassword', 'resetpassword', 'icon-reset_password', '', 1, 20, 110),
	(49, 'permission', 'permission', 'icon-permission', '', 1, 20, 60),
	(50, 'usertype', 'usertype', 'icon-role', '', 1, 20, 70),
	(51, 'setting', 'setting', 'fa-gears', '', 1, 21, 30),
	(52, 'paymentsettings', 'paymentsettings', 'icon-paymentsettings', '', 1, 21, 20),
	(53, 'smssettings', 'smssettings', 'fa-wrench', '', 1, 21, 10),
	(54, 'invoice', 'invoice', 'icon-invoice', '', 1, 16, 260),
	(55, 'paymenthistory', 'paymenthistory', 'icon-payment', '', 1, 16, 250),
	(56, 'transport', 'transport', 'icon-sbus', '', 1, 14, 340),
	(57, 'member', 'tmember', 'icon-member', '', 1, 14, 330),
	(58, 'hostel', 'hostel', 'icon-hostel', '', 1, 15, 310),
	(59, 'category', 'category', 'fa-leaf', '', 1, 15, 300),
	(61, 'member', 'hmember', 'icon-member', '', 1, 15, 290),
	(62, 'feetypes', 'feetypes', 'icon-feetypes', '', 1, 16, 270),
	(63, 'expense', 'expense', 'icon-expense', '', 1, 16, 240),
	(64, 'member', 'lmember', 'icon-member', '', 1, 13, 380),
	(65, 'books', 'book', 'icon-lbooks', '', 1, 13, 370),
	(66, 'issue', 'issue', 'icon-issue', '', 1, 13, 360),
	(69, 'import', 'bulkimport', 'fa-upload', '', 1, 20, 90),
	(70, 'update', 'update', 'fa-refresh', '', 1, 20, 50),
	(71, 'main_child', '#', 'fa-child', '', 1, 0, 430),
	(72, 'activitiescategory', 'activitiescategory', 'fa-pagelines', '', 1, 71, 420),
	(73, 'activities', 'activities', 'fa-fighter-jet', '', 1, 71, 410),
	(74, 'childcare', 'childcare', 'fa-wheelchair', '', 1, 71, 400),
	(75, 'uattendance', 'uattendance', 'fa-user-secret', NULL, 1, 7, 1000),
	(76, 'studentgroup', 'studentgroup', 'fa-object-group', '', 1, 20, 129),
	(77, 'vendor', 'vendor', 'fa-rss', '', 1, 96, 1000),
	(78, 'location', 'location', 'fa-newspaper-o', '', 1, 96, 1000),
	(79, 'asset_category', 'asset_category', 'fa-life-ring', '', 1, 96, 1000),
	(80, 'asset', 'asset', 'fa-fax', '', 1, 96, 1000),
	(81, 'complain', 'complain', 'fa-commenting', '', 1, 20, 128),
	(82, 'question_group', 'question_group', 'fa-question-circle', '', 1, 88, 1000),
	(83, 'question_level', 'question_level', 'fa-level-up', '', 1, 88, 1000),
	(84, 'question_bank', 'question_bank', 'fa-qrcode', '', 1, 88, 1000),
	(85, 'online_exam', 'online_exam', 'fa-slideshare', '', 1, 88, 1000),
	(86, 'instruction', 'instruction', 'fa-map-signs', '', 1, 88, 1000),
	(87, 'take_exam', 'take_exam', 'fa-user-secret', '', 1, 88, 1000),
	(88, 'online_exam', '#', 'fa-graduation-cap', '', 1, 0, 1000),
	(89, 'certificatereport', 'certificatereport', 'fa-diamond', '', 1, 18, 860),
	(90, 'certificate_template', 'certificate_template', 'fa-certificate', '', 1, 20, 128),
	(91, 'main_payroll', '#', 'fa-usd', NULL, 1, 0, 1000),
	(92, 'salary_template', 'salary_template', 'fa-calculator', '', 1, 91, 1000),
	(93, 'hourly_template', 'hourly_template', 'fa fa-clock-o', '', 1, 91, 1000),
	(94, 'manage_salary', 'manage_salary', 'fa-beer', '', 1, 91, 1000),
	(95, 'make_payment', 'make_payment', 'fa-money', NULL, 1, 91, 1000),
	(96, 'main_asset_management', '#', 'fa-archive', NULL, 1, 0, 1000),
	(97, 'asset_assignment', 'asset_assignment', 'fa-plug', NULL, 1, 96, 1000),
	(98, 'purchase', 'purchase', 'fa-cart-plus', NULL, 1, 96, 1000),
	(99, 'main_frontend', '#', 'fa-home', '', 1, 0, 40),
	(100, 'pages', 'pages', 'fa-connectdevelop', '', 1, 99, 1000),
	(101, 'frontend_setting', 'frontend_setting', 'fa-asterisk', '', 1, 21, 25),
	(102, 'routinereport', 'routinereport', 'iniicon-routinereport', '', 1, 18, 960),
	(103, 'examschedulereport', 'examschedulereport', 'iniicon-examschedulereport', '', 1, 18, 950),
	(104, 'feesreport', 'feesreport', 'iniicon-feesreport', '', 1, 18, 850),
	(105, 'duefeesreport', 'duefeesreport', 'iniicon-duefeesreport', '', 1, 18, 840),
	(106, 'balancefeesreport', 'balancefeesreport', 'iniicon-balancefeesreport', '', 1, 18, 830),
	(107, 'transactionreport', 'transactionreport', 'iniicon-transactionreport', '', 1, 18, 820),
	(108, 'sociallink', 'sociallink', 'iniicon-sociallink', '', 1, 20, 109),
	(109, 'idcardreport', 'idcardreport', 'iniicon-idcardreport', '', 1, 18, 980),
	(110, 'admitcardreport', 'admitcardreport', 'iniicon-admitcardreport', '', 1, 18, 970),
	(111, 'studentfinereport', 'studentfinereport', 'iniicon-studentfinereport', '', 1, 18, 810),
	(112, 'attendanceoverviewreport', 'attendanceoverviewreport', 'iniicon-attendanceoverviewreport', '', 1, 18, 930),
	(113, 'income', 'income', 'iniicon-income', '', 1, 16, 239),
	(114, 'global_payment', 'global_payment', 'fa-balance-scale', '', 1, 16, 238),
	(115, 'terminalreport', 'terminalreport', 'iniicon-terminalreport', '', 1, 18, 920),
	(116, 'tabulationsheetreport', 'tabulationsheetreport', 'iniicon-tabulationsheetreport', '', 1, 18, 900),
	(117, 'marksheetreport', 'marksheetreport', 'iniicon-marksheetreport', '', 1, 18, 890),
	(118, 'meritstagereport', 'meritstagereport', 'iniicon-meritstagereport', '', 1, 18, 910),
	(119, 'progresscardreport', 'progresscardreport', 'iniicon-progresscardreport', '', 1, 18, 880),
	(120, 'onlineexamreport', 'onlineexamreport', 'iniicon-onlineexamreport', '', 1, 18, 870),
	(121, 'main_inventory', '#', 'iniicon-maininventory', '', 1, 0, 1000),
	(122, 'productcategory', 'productcategory', 'iniicon-productcategory', '', 1, 121, 1000),
	(123, 'product', 'product', 'iniicon-product', '', 1, 121, 1000),
	(124, 'productwarehouse', 'productwarehouse', 'iniicon-productwarehouse', '', 1, 121, 1000),
	(125, 'productsupplier', 'productsupplier', 'iniicon-productsupplier', '', 1, 121, 1000),
	(126, 'productpurchase', 'productpurchase', 'iniicon-productpurchase', '', 1, 121, 1000),
	(127, 'productsale', 'productsale', 'iniicon-productsale', '', 1, 121, 1000),
	(128, 'main_leaveapplication', '#', 'iniicon-mainleaveapplication', '', 1, 0, 1000),
	(129, 'leavecategory', 'leavecategory', 'iniicon-leavecategory', '', 1, 128, 1000),
	(130, 'leaveassign', 'leaveassign', 'iniicon-leaveassign', '', 1, 128, 1000),
	(131, 'leaveapply', 'leaveapply', 'iniicon-leaveapply', '', 1, 128, 1000),
	(132, 'leaveapplication', 'leaveapplication', 'iniicon-leaveapplication', '', 1, 128, 1000),
	(133, 'librarybooksreport', 'librarybooksreport', 'iniicon-librarybooksreport', '', 1, 18, 925),
	(134, 'searchpaymentfeesreport', 'searchpaymentfeesreport', 'iniicon-searchpaymentfeesreport', '', 1, 18, 852),
	(135, 'salaryreport', 'salaryreport', 'iniicon-salaryreport', '', 1, 18, 805),
	(136, 'productpurchasereport', 'productpurchasereport', 'iniicon-productpurchasereport', '', 1, 18, 854),
	(137, 'productsalereport', 'productsalereport', 'iniicon-productsalereport', '', 1, 18, 853),
	(138, 'leaveapplicationreport', 'leaveapplicationreport', 'iniicon-leaveapplicationreport', '', 1, 18, 855),
	(139, 'posts', 'posts', 'fa-thumb-tack', '', 1, 99, 1005),
	(140, 'posts_categories', 'posts_categories', 'fa-anchor', NULL, 1, 99, 1010),
	(141, 'menu', 'frontendmenu', 'iniicon-fmenu', '', 1, 99, 1000),
	(142, 'librarycardreport', 'librarycardreport', 'iniicon-librarycardreport', '', 1, 18, 924),
	(143, 'librarybookissuereport', 'librarybookissuereport', 'iniicon-librarybookissuereport', '', 1, 18, 923),
	(144, 'onlineexamquestionreport', 'onlineexamquestionreport', 'iniicon-onlineexamquestionreport', '', 1, 18, 865),
	(145, 'ebooks', 'ebooks', 'iniicon-ebook', '', 1, 13, 350),
	(146, 'accountledgerreport', 'accountledgerreport', 'iniicon-accountledgerreport', '', 1, 18, 800),
	(147, 'onlineadmission', 'onlineadmission', 'iniicon-onlineadmission', '', 1, 0, 160),
	(148, 'emailsetting', 'emailsetting', 'iniicon-ini-emailsetting', '', 1, 21, 5),
	(149, 'onlineadmissionreport', 'onlineadmissionreport', 'iniicon-onlineadmissionreport', '', 1, 18, 863);
/*!40000 ALTER TABLE `menu` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `migrations` (
  `version` int(3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` (`version`) VALUES
	(1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `notice` (
  `noticeID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(128) NOT NULL,
  `notice` text NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `date` date NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `create_userID` int(11) NOT NULL DEFAULT '0',
  `create_usertypeID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`noticeID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `notice` DISABLE KEYS */;
INSERT INTO `notice` (`noticeID`, `title`, `notice`, `schoolyearID`, `date`, `create_date`, `create_userID`, `create_usertypeID`) VALUES
	(1, 'TODOS INVITADOS AL ANIVERSARIO', 'FIESTA EN EL SALÓN DE LA INSTITUCIÓN<br>', 1, '2019-06-07', '2019-04-06 19:02:17', 1, 1);
/*!40000 ALTER TABLE `notice` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `onlineadmission` (
  `onlineadmissionID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `sex` varchar(10) DEFAULT NULL,
  `religion` varchar(25) DEFAULT NULL,
  `email` varchar(40) DEFAULT NULL,
  `phone` tinytext,
  `address` varchar(200) DEFAULT NULL,
  `classesID` int(11) DEFAULT NULL,
  `bloodgroup` varchar(5) DEFAULT NULL,
  `country` varchar(128) DEFAULT NULL,
  `photo` varchar(200) DEFAULT NULL,
  `schoolyearID` int(11) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `modify_date` datetime DEFAULT NULL,
  `studentID` int(11) NOT NULL DEFAULT '0',
  `status` int(11) DEFAULT '0' COMMENT '0 = New, 1=Approved, 2 = Waiting, 3 = Declined',
  PRIMARY KEY (`onlineadmissionID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `onlineadmission` DISABLE KEYS */;
INSERT INTO `onlineadmission` (`onlineadmissionID`, `name`, `dob`, `sex`, `religion`, `email`, `phone`, `address`, `classesID`, `bloodgroup`, `country`, `photo`, `schoolyearID`, `create_date`, `modify_date`, `studentID`, `status`) VALUES
	(1, 'eeee', '2013-09-30', 'Male', 'cc', 'eee@GMAIL.COM', 'r345345345', 'ttt', 2, NULL, 'PE', 'default.png', 1, '2019-04-07 10:30:03', '2019-04-07 10:30:03', 0, 0);
/*!40000 ALTER TABLE `onlineadmission` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `online_exam` (
  `onlineExamID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(512) NOT NULL,
  `description` text,
  `classID` int(11) DEFAULT '0',
  `sectionID` int(11) DEFAULT '0',
  `studentGroupID` int(11) DEFAULT '0',
  `subjectID` int(11) DEFAULT '0',
  `userTypeID` int(11) DEFAULT '0',
  `instructionID` int(11) DEFAULT '0',
  `examStatus` varchar(11) NOT NULL,
  `schoolYearID` int(11) NOT NULL,
  `examTypeNumber` int(11) DEFAULT NULL,
  `startDateTime` datetime DEFAULT NULL,
  `endDateTime` datetime DEFAULT NULL,
  `duration` int(11) DEFAULT '0',
  `random` int(11) DEFAULT '0',
  `public` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '1',
  `markType` int(11) NOT NULL,
  `negativeMark` int(11) DEFAULT '0',
  `bonusMark` int(11) DEFAULT '0',
  `point` int(11) DEFAULT '0',
  `percentage` int(11) DEFAULT '0',
  `showMarkAfterExam` int(11) DEFAULT '0',
  `judge` int(11) DEFAULT '1' COMMENT 'Auto Judge = 1, Manually Judge = 0',
  `paid` int(11) DEFAULT '0' COMMENT '0 = Unpaid, 1 = Paid',
  `validDays` int(11) DEFAULT '0',
  `cost` int(11) DEFAULT '0',
  `img` varchar(512) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  `published` int(11) NOT NULL,
  PRIMARY KEY (`onlineExamID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `online_exam` DISABLE KEYS */;
INSERT INTO `online_exam` (`onlineExamID`, `name`, `description`, `classID`, `sectionID`, `studentGroupID`, `subjectID`, `userTypeID`, `instructionID`, `examStatus`, `schoolYearID`, `examTypeNumber`, `startDateTime`, `endDateTime`, `duration`, `random`, `public`, `status`, `markType`, `negativeMark`, `bonusMark`, `point`, `percentage`, `showMarkAfterExam`, `judge`, `paid`, `validDays`, `cost`, `img`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`, `published`) VALUES
	(1, 'examen de conocimiento de ciencias naturales', NULL, 2, 1, 1, 2, 3, 1, '2', 1, 4, '2019-05-04 00:00:00', '2019-05-05 00:00:00', 1, 80, 0, 1, 5, 50, 0, 0, 100, 0, 0, 0, 0, 0, NULL, '2019-04-24 10:50:51', '2019-05-04 17:24:50', 1, 1, 1),
	(2, 'aritmética', NULL, 2, 1, 1, 1, 3, 1, '1', 1, 4, '2019-05-04 00:00:00', '2019-05-04 00:00:00', 20, 80, 0, 1, 10, 50, 0, 0, 100, 0, 0, 0, 0, 0, NULL, '2019-05-04 16:41:18', '2019-05-04 17:22:38', 1, 1, 1);
/*!40000 ALTER TABLE `online_exam` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `online_exam_question` (
  `onlineExamQuestionID` int(11) NOT NULL AUTO_INCREMENT,
  `onlineExamID` int(11) NOT NULL,
  `questionID` int(11) DEFAULT NULL,
  PRIMARY KEY (`onlineExamQuestionID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `online_exam_question` DISABLE KEYS */;
INSERT INTO `online_exam_question` (`onlineExamQuestionID`, `onlineExamID`, `questionID`) VALUES
	(1, 1, 1),
	(3, 2, 3),
	(4, 2, 1);
/*!40000 ALTER TABLE `online_exam_question` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `online_exam_type` (
  `onlineExamTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(512) DEFAULT NULL,
  `examTypeNumber` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`onlineExamTypeID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `online_exam_type` DISABLE KEYS */;
INSERT INTO `online_exam_type` (`onlineExamTypeID`, `title`, `examTypeNumber`, `status`) VALUES
	(1, 'La fecha, la hora y la duración', 5, 1),
	(2, 'La fecha y la duración', 4, 1),
	(3, 'Solo la fecha', 3, 0),
	(4, 'Solo la duración', 2, 1),
	(5, 'Ninguno', 1, 0);
/*!40000 ALTER TABLE `online_exam_type` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `online_exam_user_answer` (
  `onlineExamUserAnswerID` int(11) NOT NULL AUTO_INCREMENT,
  `onlineExamQuestionID` int(11) NOT NULL,
  `onlineExamRegisteredUserID` int(11) DEFAULT NULL,
  `userID` int(11) DEFAULT NULL,
  PRIMARY KEY (`onlineExamUserAnswerID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `online_exam_user_answer` DISABLE KEYS */;
INSERT INTO `online_exam_user_answer` (`onlineExamUserAnswerID`, `onlineExamQuestionID`, `onlineExamRegisteredUserID`, `userID`) VALUES
	(1, 1, NULL, 2),
	(2, 1, NULL, 2),
	(3, 1, NULL, 2),
	(4, 1, NULL, 2),
	(5, 1, NULL, 2),
	(6, 1, NULL, 2),
	(7, 1, NULL, 2),
	(8, 1, NULL, 2);
/*!40000 ALTER TABLE `online_exam_user_answer` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `online_exam_user_answer_option` (
  `onlineExamUserAnswerOptionID` int(11) NOT NULL AUTO_INCREMENT,
  `questionID` int(11) NOT NULL,
  `optionID` int(11) DEFAULT NULL,
  `typeID` int(11) NOT NULL,
  `text` text,
  `time` datetime NOT NULL,
  PRIMARY KEY (`onlineExamUserAnswerOptionID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `online_exam_user_answer_option` DISABLE KEYS */;
INSERT INTO `online_exam_user_answer_option` (`onlineExamUserAnswerOptionID`, `questionID`, `optionID`, `typeID`, `text`, `time`) VALUES
	(1, 1, 1, 1, NULL, '2019-05-04 16:55:34'),
	(2, 1, 1, 1, NULL, '2019-05-04 17:08:26'),
	(3, 1, 1, 1, NULL, '2019-05-04 17:12:29'),
	(4, 1, 3, 1, NULL, '2019-05-04 17:15:53'),
	(5, 1, 1, 1, NULL, '2019-05-04 17:17:43'),
	(6, 1, 2, 1, NULL, '2019-05-04 17:18:08'),
	(7, 1, 2, 1, NULL, '2019-05-04 17:19:15'),
	(8, 1, 3, 1, NULL, '2019-05-04 17:26:01');
/*!40000 ALTER TABLE `online_exam_user_answer_option` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `online_exam_user_status` (
  `onlineExamUserStatus` int(11) NOT NULL AUTO_INCREMENT,
  `onlineExamID` int(11) NOT NULL,
  `duration` int(11) NOT NULL,
  `score` int(11) NOT NULL,
  `totalQuestion` int(11) NOT NULL,
  `totalAnswer` int(11) NOT NULL,
  `nagetiveMark` int(11) NOT NULL,
  `time` datetime NOT NULL,
  `userID` int(11) NOT NULL,
  `classesID` int(11) DEFAULT NULL,
  `sectionID` int(11) DEFAULT NULL,
  `examtimeID` int(11) DEFAULT NULL,
  `totalCurrectAnswer` int(11) DEFAULT NULL,
  `totalMark` varchar(40) DEFAULT NULL,
  `totalObtainedMark` int(11) DEFAULT NULL,
  `totalPercentage` double DEFAULT NULL,
  `statusID` int(11) DEFAULT NULL,
  PRIMARY KEY (`onlineExamUserStatus`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `online_exam_user_status` DISABLE KEYS */;
INSERT INTO `online_exam_user_status` (`onlineExamUserStatus`, `onlineExamID`, `duration`, `score`, `totalQuestion`, `totalAnswer`, `nagetiveMark`, `time`, `userID`, `classesID`, `sectionID`, `examtimeID`, `totalCurrectAnswer`, `totalMark`, `totalObtainedMark`, `totalPercentage`, `statusID`) VALUES
	(1, 1, 20, 1, 1, 1, 50, '2019-05-04 16:55:34', 2, 2, 1, 1, 1, '100', 100, 100, 5),
	(2, 1, 20, 1, 1, 1, 50, '2019-05-04 17:08:26', 2, 2, 1, 2, 1, '100', 100, 100, 5),
	(3, 1, 20, 1, 1, 1, 50, '2019-05-04 17:12:29', 2, 2, 1, 2, 1, '100', 100, 100, 5),
	(4, 1, 20, 0, 1, 0, 50, '2019-05-04 17:14:59', 2, 2, 1, 2, 0, '100', 0, 0, 10),
	(5, 1, 20, 0, 1, 1, 50, '2019-05-04 17:15:53', 2, 2, 1, 2, 0, '100', 0, 0, 10),
	(6, 1, 1, 1, 1, 1, 50, '2019-05-04 17:17:43', 2, 2, 1, 2, 1, '100', 100, 100, 5),
	(7, 1, 1, 0, 1, 1, 50, '2019-05-04 17:18:08', 2, 2, 1, 2, 0, '100', 0, 0, 10),
	(8, 1, 1, 0, 1, 1, 50, '2019-05-04 17:19:15', 2, 2, 1, 2, 0, '100', 0, 0, 10),
	(9, 1, 1, 0, 1, 1, 50, '2019-05-04 17:26:01', 2, 2, 1, 2, 0, '100', 0, 0, 10);
/*!40000 ALTER TABLE `online_exam_user_status` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `pages` (
  `pagesID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(128) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `content` text,
  `status` int(11) DEFAULT NULL COMMENT '1 => active, 2 => draft, 3 => trash, 4 => review  ',
  `visibility` int(11) DEFAULT NULL COMMENT '1 => public 2 => protected 3 => private ',
  `publish_date` datetime DEFAULT NULL,
  `parentID` int(11) NOT NULL DEFAULT '0',
  `pageorder` int(11) NOT NULL DEFAULT '0',
  `template` varchar(250) DEFAULT NULL,
  `featured_image` varchar(11) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `modify_date` datetime DEFAULT NULL,
  `create_userID` int(11) DEFAULT NULL,
  `create_username` varchar(60) DEFAULT NULL,
  `create_usertypeID` int(11) DEFAULT NULL,
  `password` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`pagesID`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` (`pagesID`, `title`, `url`, `content`, `status`, `visibility`, `publish_date`, `parentID`, `pageorder`, `template`, `featured_image`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertypeID`, `password`) VALUES
	(1, 'Inicio', 'home', '<p><br>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Dolores atque alias est distinctio expedita beatae consequuntur repudiandae dolor incidunt cumque eos nihil cupiditate dignissimos inventore, minima hic aliquam consectetur, debitis voluptates saepe. Et soluta dignissimos in numquam enim! Veniam aliquam commodi optio blanditiis aut impedit incidunt, ducimus quos vel, ut.Et soluta dignissimos in numquam enim! Veniam aliquam commodi optio blanditiis aut impedit incidunt, ducimus quos vel, ut.</p><p> <br><br></p><br><p></p>', 1, 1, '2019-03-29 09:12:01', 0, 0, 'home', '12', '2019-03-29 09:13:41', '2019-04-10 11:18:13', 1, 'admin', 1, '12345678'),
	(3, 'Contacto', 'contacto', '', 1, 1, '2019-04-04 17:29:01', 0, 0, 'contact', '', '2019-04-04 05:29:40', '2019-05-03 04:43:03', 1, 'admin', 1, NULL),
	(4, 'Acerca De', 'acerca-de', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Dolores atque alias est distinctio expedita beatae consequuntur repudiandae dolor incidunt cumque eos nihil cupiditate dignissimos inventore, minima hic aliquam consectetur, debitis voluptates saepe. Et soluta dignissimos in numquam enim! Veniam aliquam commodi optio blanditiis aut impedit incidunt, ducimus quos vel, ut.Lorem <b>ipsum </b>dolor sit amet, consectetur adipisicing elit. Dolores atque alias est distinctio expedita beatae consequuntur repudiandae dolor incidunt cumque eos nihil cupiditate dignissimos inventore, minima hic aliquam consectetur, debitis voluptates saepe. Et soluta dignissimos in numquam enim! Veniam aliquam commodi optio blanditiis aut impedit incidunt, ducimus quos vel, ut.Lorem ipsum dolor sit amet, consectetur adipisicing elit. Dolores atque alias est distinctio expedita beatae consequuntur repudiandae dolor incidunt cumque eos <b>nihil </b>cupiditate dignissimos inventore, minima hic aliquam consectetur, debitis voluptates saepe. Et soluta dignissimos in numquam enim! Veniam aliquam commodi optio blanditiis aut impedit incidunt, ducimus quos vel, ut.<b>Lorem </b>ipsum dolor sit amet, consectetur adipisicing elit. Dolores atque alias est distinctio expedita beatae consequuntur repudiandae </p><p>dolor incidunt cumque eos nihil cupiditate dignissimos inventore, minima hic aliquam <b>consectetur</b>, debitis voluptates saepe. Et soluta dignissimos in numquam enim! Veniam aliquam commodi optio blanditiis aut impedit incidunt, ducimus quos vel, ut.Lorem ipsum dolor sit amet, consectetur adipisicing elit. Dolores atque alias est distinctio expedita beatae consequuntur repudiandae dolor incidunt cumque eos nihil cupiditate dignissimos inventore, minima hic aliquam consectetur, debitis voluptates saepe. Et soluta dignissimos in numquam enim! Veniam aliquam commodi optio blanditiis aut impedit incidunt, ducimus quos vel, ut.Lorem ipsum dolor sit amet, consectetur adipisicing elit. Dolores atque alias est distincti<u>o expedita beatae consequuntur repudiandae dolor incidunt cumque eos nihil </u>cupiditate dignissimos inventore, minima hic aliquam consectetur, debitis voluptates saepe. Et soluta dignissimos in numquam enim! Ve</p><ul><li><b>niam aliquam commodi optio blanditiis aut impedit</b></li><li><b>niam aliquam commodi optio blanditiis aut impedit</b></li><li><b>niam aliquam commodi optio blanditiis aut impedit</b></li><li><b>niam aliquam commodi optio blanditiis aut impedit</b></li><li><b><br></b><br></li></ul><p>niam aliquam commodi optio blanditiis aut impedit incidunt, ducimus quos vel, ut.Lorem ipsum dolor sit amet, consectetur adipisicing elit. <b>Dolores </b>atque alias est distinctio expedita beatae consequuntur repudiandae dolor incidunt cumque eos nihil cupiditate dignissimos inventore, minima hic aliquam consectetur, debitis voluptates saepe. Et soluta dignissimos in numquam enim! Veniam <b>aliquam commodi optio blanditiis aut impedit incidunt, duci</b>mus quos vel, ut.Lorem ipsum dolor sit amet, consectetur adipisicing<b> elit. Dolores atque alias est </b>distinctio expedita beatae consequuntur repudiandae dolor incidunt cumque eos nihil cupiditate dignissimos inventore<b>, </b>minima hic aliquam consectetur, debitis voluptates saepe. Et soluta dignissimos in numquam enim! Veniam aliquam commodi optio blanditiis aut impedit incidunt, ducimus quos vel, ut.Lorem ipsum dolor sit amet, consectetur adipisicing elit. Dolores atque alias est distinctio expedita beatae consequuntur repudiandae dolor incidunt cumque eos nihil cupiditate dignissimos inventore, minima hic aliquam consectetur, debitis voluptates saepe. Et soluta dignissimos in numquam enim! Veniam aliquam commodi optio blanditiis aut impedit incidunt, ducimus quos vel, ut.<br></p>', 1, 1, '2019-04-04 17:29:01', 0, 0, 'about', '', '2019-04-04 05:30:06', '2019-04-10 10:17:21', 1, 'admin', 1, NULL),
	(5, 'Evento', 'evento', '', 1, 1, '2019-04-04 17:30:01', 0, 0, 'event', '', '2019-04-04 05:30:18', '2019-04-06 05:50:04', 1, 'admin', 1, NULL),
	(6, 'Profesor', 'profesor', '', 1, 1, '2019-04-04 17:30:01', 0, 0, 'teacher', '', '2019-04-04 05:30:33', '2019-04-06 06:14:58', 1, 'admin', 1, NULL),
	(7, 'Galeria', 'galeria', '', 1, 1, '2019-04-04 17:30:01', 0, 0, 'gallery', '', '2019-04-04 05:30:46', '2019-04-04 05:32:38', 1, 'admin', 1, NULL),
	(8, 'Noticias', 'noticias', '', 1, 1, '2019-04-04 17:30:01', 0, 0, 'notice', '', '2019-04-04 05:30:58', '2019-04-04 05:32:48', 1, 'admin', 1, NULL),
	(9, 'Blog', 'blog', '', 1, 1, '2019-04-04 17:31:01', 0, 0, 'blog', '', '2019-04-04 05:31:21', '2019-04-04 05:32:57', 1, 'admin', 1, NULL),
	(10, 'Admisión', 'admision', '', 1, 1, '2019-04-04 17:31:01', 0, 0, 'admission', '', '2019-04-04 05:31:32', '2019-04-10 11:29:13', 1, 'admin', 1, NULL);
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `parents` (
  `parentsID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `father_name` varchar(60) NOT NULL,
  `mother_name` varchar(60) NOT NULL,
  `father_profession` varchar(40) NOT NULL,
  `mother_profession` varchar(40) NOT NULL,
  `email` varchar(40) DEFAULT NULL,
  `phone` tinytext,
  `address` text,
  `photo` varchar(200) DEFAULT NULL,
  `username` varchar(40) NOT NULL,
  `password` varchar(128) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(60) NOT NULL,
  `create_usertype` varchar(60) NOT NULL,
  `active` int(11) NOT NULL,
  PRIMARY KEY (`parentsID`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `parents` DISABLE KEYS */;
INSERT INTO `parents` (`parentsID`, `name`, `father_name`, `mother_name`, `father_profession`, `mother_profession`, `email`, `phone`, `address`, `photo`, `username`, `password`, `usertypeID`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`, `active`) VALUES
	(1, 'OMAR FERREIRA', 'OMAR FERREIRA', 'ESTELA LOPEZ', 'ARQUITECTO', 'ARTISTA', 'OMAR@FERREIRA.COM', '546789555', 'CALLE INDEPENDENCIA', 'default.png', 'omar', '754b760db57636cdd76823849f7c411d3de4903a50417cd546a23532f514d1dd05498dcf91e3905a4cf762f7524b2e83864cc9b32a823d1b1fb02b120a5ac7bd', 4, '2019-03-25 02:40:04', '2019-03-25 02:40:04', 1, 'admin', 'Admin', 1),
	(2, 'PERCY ROJAS', 'PERCY ROJAS', 'MONICA LUNA', 'CHEF', 'MECANICO', 'PERCY@GMAIL.COM', '23523536', 'CALLE TORTUGA', 'default.png', 'percy', '1a65efd78baa7aa51785b4091776a288b9423ab1d1cda3ceb41de52d4c1aef52026073318e74ad34d234adc41af09e3c907845286bda23c42a43c317cba1b19a', 4, '2019-03-25 06:32:12', '2019-03-25 06:32:12', 1, 'admin', 'Admin', 1),
	(3, 'JAIME FLORES', 'JAIME FLORES', 'TEREZA VASQUEZ', 'AGRICULTOR', 'ARQUEOLOGO', 'JAIME@GMAIL.COM', '466345523', 'CALLE SOLAR', 'default.png', 'jaime', '51f3b4e91cbbbe0934de7ca0b9d32781675969fc275a176d33c046a1fe6f9662195af270e681aae0f73283bb62b59e799d230d3ee5033f05a082fd67f6111351', 4, '2019-03-25 06:34:45', '2019-03-25 06:34:45', 1, 'admin', 'Admin', 1),
	(4, 'JULIA VALENCIA', 'FELIPE LOZA', 'JULIA VALENCIA', 'ELECTRICISTA', 'PROFESOR', 'JULIA@GMAIL.COM', '534645457', 'CALLE LIMON', 'default.png', 'julia', '365e58f194fa1940811a6c0b61a6aabbfbaf2001e48f753d46d273f1cf71ea285cf2d3f795a82cc038a7a2b7390c29c41641ce9f388104129382a40cba92d450', 4, '2019-03-25 06:36:36', '2019-03-25 06:36:36', 1, 'admin', 'Admin', 1),
	(5, 'ROSMERY DOMINGO', 'TOMAS PLACIDO', 'ROSMERY DOMINGO', 'ANALISTA EN SISTEMAS', 'PERIODISTA', 'ROSMERY@GMAIL.COM', '235256252', '', 'default.png', 'rosmery', 'da5547db6c197c375b83ed3181e4e0561eff89ceaeb119837daf91e1796cd781a2039d35d025e016acdbcadaa306c7ef5ce84a7d0656b1353fe72a4d72d386c8', 4, '2019-03-25 06:38:16', '2019-03-25 06:38:16', 1, 'admin', 'Admin', 1),
	(6, 'FRANCISO FONTANER', 'FRANCISO FONTANER', 'ANA DALAS', 'SECRETARIA', '', 'FRANCISCO@GMAIL.COM', '4243525235', 'CALLE MANZANA', 'default.png', 'francisco', '520cd95397e8442f60f2cbe2a50e3e8c5644286d5f1e85b032d7f7c0bf3f0f29d0069d606281c35e9fde600930770abe789a60a274cd69bac299851d1a183e48', 4, '2019-03-25 06:40:14', '2019-03-25 06:40:14', 1, 'admin', 'Admin', 1),
	(7, 'LUCAS GONZALES', 'LUCAS GONZALES', 'VERONICA BARRAGAN', '', '', 'LUCAS@GMAIL.COM', '', '', 'default.png', 'lucas', '8178781b5e6575f3dbfa3c76d76a7fb8ac1652b14be40234cc9eb3ba1b762fca72ae1fee83068d0e53c31977963d5aedc6b2748052b60c24a72aedcd483d99a2', 4, '2019-03-25 06:41:08', '2019-03-25 06:43:14', 1, 'admin', 'Admin', 1),
	(8, 'JORGE RESTREPO', 'JORGE RESTREPO', 'ROXANA GOMEZ', 'MUSICO', '', 'JORGE@GMAIL.COM', '', '', 'default.png', 'jorge', '989ca0579e9f12f4a1f2700ec29b0b71b2d90c8ccf201256b9dbfc9e40e2bae7a2de32294bd8d57394689ad39ecbf2b7f34d2316c7b82ee062ebf5fe8a74681f', 4, '2019-03-25 06:42:41', '2019-03-25 06:43:34', 1, 'admin', 'Admin', 1),
	(9, 'ALVARO MENDOZA', 'ALVARO MENDOZA', 'LIDIA TAMBO', '', '', 'ALVARO@GMAIL.COM', '', '', 'default.png', 'alvaro', '66bc195b2111a799e176f65af7854b7ef1a47dc4b58a2a6b5d038b588123a7fb9a3ff65dfb8978387cf3c590ea1def81ea090d78c82a4e2b940c11ad292a7b48', 4, '2019-03-25 06:44:24', '2019-03-25 06:44:24', 1, 'admin', 'Admin', 1),
	(10, 'MARTHA AVALOS', 'ADRIAN ORTEGA', 'MARTHA AVALOS', '', '', 'MARTHA@GMAIL.COM', '', '', 'default.png', 'martha', '7f3908f482b516ea986fb7c7fc149efc2436a38aef653979738a4c8a370adf1615bd6c252ea6d93512d2423205a31f27caf9c4c6ffa7d27672a6c50f87c210b5', 4, '2019-03-25 06:46:17', '2019-03-25 06:46:17', 1, 'admin', 'Admin', 1),
	(11, 'MARIA VARGAS', '', 'MARIA VARGAS', '', '', 'MARIA@GMAIL.COM', '', '', 'default.png', 'maria', '75f82d35f7ba9059a649e831d778dde5b62e1b90d38eb4961f54dcabcd056a09f00f3d4e9b3e79de66d433bbbaa541d2b11bbdeaaed256b7503cc3e0720fbbc3', 4, '2019-03-25 06:47:01', '2019-03-25 06:47:01', 1, 'admin', 'Admin', 1),
	(12, 'FELIX NINA', 'FELIX NINA', 'LUCIA RAMIREZ', '', '', 'FELIX@GMAIL.COM', '', '', 'default.png', 'felix', '61a3ed55e4ea80a61d13d604340eb765fae0d3aae4fdd6cd7b6004fafa1e7cd048556b3a138b9ca443b2a126a7896cb39f4c93a7f14bdb122767a36b2a5ceeab', 4, '2019-03-25 06:48:12', '2019-03-25 06:48:12', 1, 'admin', 'Admin', 1),
	(13, 'ARTURO DURAN', 'ARTURO DURAN', 'BEATRIZ SANCHEZ', '', '', 'ARTURO@GMAIL.COM', '', '', 'default.png', 'arturo', 'c642ae4488cbdb0579a2e0644d3216772179350f20de2780057a22c9863f367f17a00ea34b1401d5d124299e7e208dceb321fa59398301c83d89329688104ed2', 4, '2019-03-25 06:48:57', '2019-03-25 06:48:57', 1, 'admin', 'Admin', 1),
	(14, 'CARMEN PINTO', 'DANIEL MARTINEZ', 'CARMEN PINTO', '', '', 'CARMEN@GMAIL.COM', '', '', 'default.png', 'carmen', '433f6ef518305ed0941960de7735eb1340ce768990f954e6fcefdc67a3b9f1c231769e188859dc69f1fe145495c9870cfaf4e26b5313d373271900504a367d30', 4, '2019-03-25 06:49:59', '2019-03-25 06:49:59', 1, 'admin', 'Admin', 1),
	(15, 'DANNA VELASCO', 'RODRIGO TORREZ', 'DANNA VELASCO', '', '', 'DANNA@GMAIL.COM', '', '', 'default.png', 'danna', '9da66ed4bc3572ba1236cac017474754fc17b3de96a7e86903f51759782e73a921bedb3de8253e226eda9942fbbf1b4df1612b1ddd6bc5a08dd76894d40cb75d', 4, '2019-03-25 06:51:29', '2019-03-25 06:51:29', 1, 'admin', 'Admin', 1),
	(16, 'OSCAR PLATA', 'CELESTE HEREDIA', 'OSCAR PLATA', '', '', 'OSCAR@GMAIL.COM', '', '', 'default.png', 'oscar', '610397571f985a7d43e75ec3081b5ae5978b0f9c776441e641818ff2892fd09ab34c35a8e8300bc4702aaffd81cd8caf106f681ca56ea4eb013e56c804474623', 4, '2019-03-25 06:52:48', '2019-03-25 06:52:48', 1, 'admin', 'Admin', 1),
	(17, 'GUILLERMO LUJAN', 'GUILLERMO LUJAN', 'GABRIELA SANTOS', '', '', 'GUILLERMO@GMAIL.COM', '', '', 'default.png', 'guillermo', 'c284549f86e9858a35dbd9d28a83bbdfb3284c8ebdfa8c0bef7fbe8b88751aab5da9cd1b3f55b2ce97e8aef491b129355daf8bfceb94a4ed08be48b34b9a0167', 4, '2019-03-25 06:54:01', '2019-03-25 06:54:01', 1, 'admin', 'Admin', 1),
	(18, 'ENRIQUE MARQUEZ', 'ENRIQUE MARQUEZ', 'CAROLA ROLDAN', '', '', 'ENRIQUE@GMAIL.COM', '', '', 'default.png', 'enrique', '359fbcbc33f56df81ac10a97a7f2a55b159301313b8747be944d6adb00b8462bef1972b89e47539d2bc9b1ac0ad88d612d2a792b12641ea362cc2d55cc0a0457', 4, '2019-03-25 06:56:02', '2019-03-25 06:56:02', 1, 'admin', 'Admin', 1),
	(19, 'Adrian Montes', 'Adrian Montes', '', 'ARQUITECTO', '', 'ADRIAN@GMAIL.COM', '586786790', 'CALLE INDEPENDENCIA', 'default.png', 'padres', 'fe961c391c311e4e14fe6c8360f47c3bba093399bd46cfe20698d4bc814fb295a2a9d947ea85c6e1f9f85b8a0ec40832775475b4e6a9b633f63f48f4d97f52c1', 4, '2019-05-03 11:30:03', '2019-05-03 11:30:03', 1, 'admin', 'Admin', 1);
/*!40000 ALTER TABLE `parents` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `payment` (
  `paymentID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `invoiceID` int(11) NOT NULL,
  `studentID` int(11) NOT NULL,
  `paymentamount` double DEFAULT NULL,
  `paymenttype` varchar(128) NOT NULL,
  `paymentdate` date NOT NULL,
  `paymentday` varchar(11) NOT NULL,
  `paymentmonth` varchar(10) NOT NULL,
  `paymentyear` year(4) NOT NULL,
  `userID` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `uname` varchar(60) NOT NULL,
  `transactionID` text,
  `globalpaymentID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`paymentID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `payment` DISABLE KEYS */;
INSERT INTO `payment` (`paymentID`, `schoolyearID`, `invoiceID`, `studentID`, `paymentamount`, `paymenttype`, `paymentdate`, `paymentday`, `paymentmonth`, `paymentyear`, `userID`, `usertypeID`, `uname`, `transactionID`, `globalpaymentID`) VALUES
	(1, 1, 1, 2, 3, 'Cash', '2019-04-08', '08', '04', '2019', 1, 1, 'admin', 'CASHANDCHEQUE2366361578439850747', 1),
	(2, 1, 3, 4, 2.94, 'Cash', '2019-04-18', '18', '04', '2019', 1, 1, 'admin', 'CASHANDCHEQUE7064948193366286308', 2),
	(3, 1, 4, 2, 4, 'Cash', '2019-04-26', '26', '04', '2019', 1, 1, 'admin', 'CASHANDCHEQUE9504109061358722670', 3),
	(4, 1, 7, 2, 4, 'Cash', '2019-04-26', '26', '04', '2019', 1, 1, 'admin', 'CASHANDCHEQUE1662523013195685244', 4),
	(5, 1, 8, 2, 3, 'Cheque', '2019-04-26', '26', '04', '2019', 1, 1, 'admin', 'CASHANDCHEQUE9225817207331173348', 5);
/*!40000 ALTER TABLE `payment` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `permissions` (
  `permissionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'In most cases, this should be the name of the module (e.g. news)',
  `active` enum('yes','no') CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`permissionID`)
) ENGINE=InnoDB AUTO_INCREMENT=870 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` (`permissionID`, `description`, `name`, `active`) VALUES
	(501, 'Dashboard', 'dashboard', 'yes'),
	(502, 'Estudiante', 'student', 'yes'),
	(503, 'Agregar estudiate', 'student_add', 'yes'),
	(504, 'Editar estudiante', 'student_edit', 'yes'),
	(505, 'Borrar estudiante', 'student_delete', 'yes'),
	(506, 'Ver estudiante', 'student_view', 'yes'),
	(507, 'Padres', 'parents', 'yes'),
	(508, 'Agregar padres', 'parents_add', 'yes'),
	(509, 'Editar padres', 'parents_edit', 'yes'),
	(510, 'Borrar padres', 'parents_delete', 'yes'),
	(511, 'Ver padres', 'parents_view', 'yes'),
	(512, 'Docentes', 'teacher', 'yes'),
	(513, 'Agregar docentes', 'teacher_add', 'yes'),
	(514, 'Editar docentes', 'teacher_edit', 'yes'),
	(515, 'Borrar docentes', 'teacher_delete', 'yes'),
	(516, 'Ver docente', 'teacher_view', 'yes'),
	(517, 'Usuario', 'user', 'yes'),
	(518, 'Agregar usuario', 'user_add', 'yes'),
	(519, 'Editar usuario', 'user_edit', 'yes'),
	(520, 'Borrar usuario', 'user_delete', 'yes'),
	(521, 'Ver usuario', 'user_view', 'yes'),
	(522, 'Clases', 'classes', 'yes'),
	(523, 'Agregar clase', 'classes_add', 'yes'),
	(524, 'Editar clase', 'classes_edit', 'yes'),
	(525, 'Borrar clase', 'classes_delete', 'yes'),
	(526, 'Sección', 'section', 'yes'),
	(527, 'Agregar sección', 'section_add', 'yes'),
	(528, 'Editar sección', 'section_edit', 'yes'),
	(529, 'Borrar semestre', 'semester_delete', 'yes'),
	(530, 'Borrar sección', 'section_delete', 'yes'),
	(531, 'Asignatura', 'subject', 'yes'),
	(532, 'Agregar asignatura', 'subject_add', 'yes'),
	(533, 'Editar asignatura', 'subject_edit', 'yes'),
	(534, 'Borrar asignatura', 'subject_delete', 'yes'),
	(535, 'Plan de estudios', 'syllabus', 'yes'),
	(536, 'Agregar plan de estudio', 'syllabus_add', 'yes'),
	(537, 'Editar plan de estudio', 'syllabus_edit', 'yes'),
	(538, 'Borrar plan de estudio', 'syllabus_delete', 'yes'),
	(539, 'Tarea', 'assignment', 'yes'),
	(540, 'Agregar tarea', 'assignment_add', 'yes'),
	(541, 'Editar tarea', 'assignment_edit', 'yes'),
	(542, 'Borrar tarea', 'assignment_delete', 'yes'),
	(543, 'Ver tarea', 'assignment_view', 'yes'),
	(544, 'Horario', 'routine', 'yes'),
	(545, 'Agregar horario', 'routine_add', 'yes'),
	(546, 'Editar horario', 'routine_edit', 'yes'),
	(547, 'Borrar horario', 'routine_delete', 'yes'),
	(548, 'Asistencia estudiante', 'sattendance', 'yes'),
	(549, 'Agregar asistencia estudiante', 'sattendance_add', 'yes'),
	(550, 'Ver asistencia estudiante', 'sattendance_view', 'yes'),
	(551, 'Asistencia docente', 'tattendance', 'yes'),
	(552, 'Agregar asistencia docente', 'tattendance_add', 'yes'),
	(553, 'Ver asistencia docente', 'tattendance_view', 'yes'),
	(554, 'Asistencia usuario', 'uattendance', 'yes'),
	(555, 'Agregar asistencia usuario', 'uattendance_add', 'yes'),
	(556, 'Ver asistencia usuario', 'uattendance_view', 'yes'),
	(557, 'Examen', 'exam', 'yes'),
	(558, 'Agregar examen', 'exam_add', 'yes'),
	(559, 'Editar examen', 'exam_edit', 'yes'),
	(560, 'Borrar examen', 'exam_delete', 'yes'),
	(561, 'Programa de examen', 'examschedule', 'yes'),
	(562, 'Agregar programa de examen', 'examschedule_add', 'yes'),
	(563, 'Editar programa de examen', 'examschedule_edit', 'yes'),
	(564, 'Borrar programa de examen', 'examschedule_delete', 'yes'),
	(565, 'Grado', 'grade', 'yes'),
	(566, 'Agregar grado', 'grade_add', 'yes'),
	(567, 'Editar grado', 'grade_edit', 'yes'),
	(568, 'Borrar grado', 'grade_delete', 'yes'),
	(569, 'Asistencia al examen', 'eattendance', 'yes'),
	(570, 'Agregar asistencia al examen', 'eattendance_add', 'yes'),
	(571, 'Calificación', 'mark', 'yes'),
	(572, 'Agregar calificación', 'mark_add', 'yes'),
	(573, 'Ver calificación', 'mark_view', 'yes'),
	(574, 'Porcentaje de calificación', 'markpercentage', 'yes'),
	(575, 'Agregar porcentaje de calificación', 'markpercentage_add', 'yes'),
	(576, 'Editar porcentaje de calificación', 'markpercentage_edit', 'yes'),
	(577, 'Borrar porcentaje de calificación', 'markpercentage_delete', 'yes'),
	(578, 'Promoción', 'promotion', 'yes'),
	(579, 'Mensaje', 'conversation', 'yes'),
	(580, 'Medios multimedia', 'media', 'yes'),
	(581, 'Agregar medios multimedia', 'media_add', 'yes'),
	(582, 'Borrar medios multimedia', 'media_delete', 'yes'),
	(583, 'Mail / SMS', 'mailandsms', 'yes'),
	(584, 'Agregar Mail / SMS', 'mailandsms_add', 'yes'),
	(585, 'Ver Mail / SMS', 'mailandsms_view', 'yes'),
	(586, 'Grupo de preguntas', 'question_group', 'yes'),
	(587, 'Agregar grupo de preguntas', 'question_group_add', 'yes'),
	(588, 'Editar grupo de preguntas', 'question_group_edit', 'yes'),
	(589, 'Borrar grupo de preguntas', 'question_group_delete', 'yes'),
	(590, 'Nivel  de pregunta', 'question_level', 'yes'),
	(591, 'Agregar nivel de pregunta', 'question_level_add', 'yes'),
	(592, 'Editar nivel de pregunta', 'question_level_edit', 'yes'),
	(593, 'Borrar nivel de pregunta', 'question_level_delete', 'yes'),
	(594, 'Banco de preguntas', 'question_bank', 'yes'),
	(595, 'Agregar banco de preguntas', 'question_bank_add', 'yes'),
	(596, 'Editar banco de preguntas', 'question_bank_edit', 'yes'),
	(597, 'Borrar banco de preguntas', 'question_bank_delete', 'yes'),
	(598, 'Ver banco de preguntas', 'question_bank_view', 'yes'),
	(599, 'Examen Online', 'online_exam', 'yes'),
	(600, 'Agregar examen Online', 'online_exam_add', 'yes'),
	(601, 'Editar examen Online', 'online_exam_edit', 'yes'),
	(602, 'Borrar examen Online', 'online_exam_delete', 'yes'),
	(603, 'Instrucción', 'instruction', 'yes'),
	(604, 'Agregar instrucción', 'instruction_add', 'yes'),
	(605, 'Editar instrucción', 'instruction_edit', 'yes'),
	(606, 'Borrar instrucción', 'instruction_delete', 'yes'),
	(607, 'Ver instrucción', 'instruction_view', 'yes'),
	(608, 'Plantilla de salario', 'salary_template', 'yes'),
	(609, 'Agregar plantilla de salario', 'salary_template_add', 'yes'),
	(610, 'Editar plantilla de salario', 'salary_template_edit', 'yes'),
	(611, 'Borrar plantilla de salario', 'salary_template_delete', 'yes'),
	(612, 'Ver plantilla de salario', 'salary_template_view', 'yes'),
	(613, 'Plantilla por hora', 'hourly_template', 'yes'),
	(614, 'Agregar plantilla por hora', 'hourly_template_add', 'yes'),
	(615, 'Editar plantilla por hora', 'hourly_template_edit', 'yes'),
	(616, 'Borrar plantilla por hora', 'hourly_template_delete', 'yes'),
	(617, 'Administrar salario', 'manage_salary', 'yes'),
	(618, 'Agregar administrar salario', 'manage_salary_add', 'yes'),
	(619, 'Editar administrar salario', 'manage_salary_edit', 'yes'),
	(620, 'Borrar administrar salario', 'manage_salary_delete', 'yes'),
	(621, 'Ver administrar salario', 'manage_salary_view', 'yes'),
	(622, 'Hacer pago', 'make_payment', 'yes'),
	(623, 'Vendedor', 'vendor', 'yes'),
	(624, 'Agregar vendedor', 'vendor_add', 'yes'),
	(625, 'Editar vendedor', 'vendor_edit', 'yes'),
	(626, 'Borrar vendedor', 'vendor_delete', 'yes'),
	(627, 'Ubicación', 'location', 'yes'),
	(628, 'Agregar ubicación', 'location_add', 'yes'),
	(629, 'Editar ubicación', 'location_edit', 'yes'),
	(630, 'Borrar ubicación', 'location_delete', 'yes'),
	(631, 'Categoría de activos', 'asset_category', 'yes'),
	(632, 'Agregar categoría de activos', 'asset_category_add', 'yes'),
	(633, 'Editar categoría de activos', 'asset_category_edit', 'yes'),
	(634, 'Borrar categoría de activos', 'asset_category_delete', 'yes'),
	(635, 'Activos', 'asset', 'yes'),
	(636, 'Agregar activos', 'asset_add', 'yes'),
	(637, 'Editar activos', 'asset_edit', 'yes'),
	(638, 'Borrar activos', 'asset_delete', 'yes'),
	(639, 'Ver activos', 'asset_view', 'yes'),
	(640, 'Asignación de activos', 'asset_assignment', 'yes'),
	(641, 'Agregar asignación de activos', 'asset_assignment_add', 'yes'),
	(642, 'Editar asignación de activos', 'asset_assignment_edit', 'yes'),
	(643, 'Borrar asignación de activos', 'asset_assignment_delete', 'yes'),
	(644, 'Ver asignación de activos', 'asset_assignment_view', 'yes'),
	(645, 'Compra', 'purchase', 'yes'),
	(646, 'Agregar compra', 'purchase_add', 'yes'),
	(647, 'Editar compra', 'purchase_edit', 'yes'),
	(648, 'Borrar compra', 'purchase_delete', 'yes'),
	(649, 'Categoría producto', 'productcategory', 'yes'),
	(650, 'Agregar categoría producto', 'productcategory_add', 'yes'),
	(651, 'Editar categoría producto', 'productcategory_edit', 'yes'),
	(652, 'Borrar categoría producto', 'productcategory_delete', 'yes'),
	(653, 'Producto', 'product', 'yes'),
	(654, 'Agregar producto', 'product_add', 'yes'),
	(655, 'Editar producto', 'product_edit', 'yes'),
	(656, 'Borrar producto', 'product_delete', 'yes'),
	(657, 'Almacén', 'productwarehouse', 'yes'),
	(658, 'Agregar almacén', 'productwarehouse_add', 'yes'),
	(659, 'Editar almacén', 'productwarehouse_edit', 'yes'),
	(660, 'Borrar almacén', 'productwarehouse_delete', 'yes'),
	(661, 'Proveedor', 'productsupplier', 'yes'),
	(662, 'Agregar proveedor', 'productsupplier_add', 'yes'),
	(663, 'Editar proveedor', 'productsupplier_edit', 'yes'),
	(664, 'Borrar proveedor', 'productsupplier_delete', 'yes'),
	(665, 'Comprar productos', 'productpurchase', 'yes'),
	(666, 'Agregar comprar productos', 'productpurchase_add', 'yes'),
	(667, 'Editar compra productos', 'productpurchase_edit', 'yes'),
	(668, 'Borrar compra productos', 'productpurchase_delete', 'yes'),
	(669, 'Ver compra productos', 'productpurchase_view', 'yes'),
	(670, 'Venta', 'productsale', 'yes'),
	(671, 'Agregar venta', 'productsale_add', 'yes'),
	(672, 'Editar venta', 'productsale_edit', 'yes'),
	(673, 'Borrar venta', 'productsale_delete', 'yes'),
	(674, 'Ver venta', 'productsale_view', 'yes'),
	(675, 'Permiso categoría', 'leavecategory', 'yes'),
	(676, 'Agregar permiso categoría', 'leavecategory_add', 'yes'),
	(677, 'Editar permiso categoría', 'leavecategory_edit', 'yes'),
	(678, 'Borrar permiso categoría', 'leavecategory_delete', 'yes'),
	(679, 'Asignar permiso', 'leaveassign', 'yes'),
	(680, 'Agregar asignar permiso', 'leaveassign_add', 'yes'),
	(681, 'Editar asignar permiso', 'leaveassign_edit', 'yes'),
	(682, 'Borrar asignar permiso', 'leaveassign_delete', 'yes'),
	(683, 'Solicitar permiso', 'leaveapply', 'yes'),
	(684, 'Agregar solicitar permiso', 'leaveapply_add', 'yes'),
	(685, 'Editar solicitar permiso', 'leaveapply_edit', 'yes'),
	(686, 'Borrar solicitar permiso', 'leaveapply_delete', 'yes'),
	(687, 'Ver solicitar permiso', 'leaveapply_view', 'yes'),
	(688, 'Solicitud de permiso', 'leaveapplication', 'yes'),
	(689, 'Categoría de actividades', 'activitiescategory', 'yes'),
	(690, 'Agregar categoría de actividades', 'activitiescategory_add', 'yes'),
	(691, 'Editar categoría de actividades', 'activitiescategory_edit', 'yes'),
	(692, 'Borrar categoría de actividades', 'activitiescategory_delete', 'yes'),
	(693, 'Actividades', 'activities', 'yes'),
	(694, 'Agregar actividades', 'activities_add', 'yes'),
	(695, 'Borrar actividades', 'activities_delete', 'yes'),
	(696, 'Cuidado de niños', 'childcare', 'yes'),
	(697, 'Agregar cuidado de niños', 'childcare_add', 'yes'),
	(698, 'Editar cuidado de niños', 'childcare_edit', 'yes'),
	(699, 'Borrar cuidado de niños', 'childcare_delete', 'yes'),
	(700, 'Miembro de la biblioteca', 'lmember', 'yes'),
	(701, 'Agregar miembro de la biblioteca', 'lmember_add', 'yes'),
	(702, 'Editar miembro de la biblioteca', 'lmember_edit', 'yes'),
	(703, 'Borrar miembro de la biblioteca', 'lmember_delete', 'yes'),
	(704, 'Ver miembro de la biblioteca', 'lmember_view', 'yes'),
	(705, 'Libros', 'book', 'yes'),
	(706, 'Agregar libros', 'book_add', 'yes'),
	(707, 'Editar libros', 'book_edit', 'yes'),
	(708, 'Borrar libros', 'book_delete', 'yes'),
	(709, 'Prestamo de libros', 'issue', 'yes'),
	(710, 'Agregar prestamo de libros', 'issue_add', 'yes'),
	(711, 'Editar prestamo de libros', 'issue_edit', 'yes'),
	(712, 'Ver prestamo de libros', 'issue_view', 'yes'),
	(713, 'E-Books', 'ebooks', 'yes'),
	(714, 'Agregar E-Books', 'ebooks_add', 'yes'),
	(715, 'Editar E-Books', 'ebooks_edit', 'yes'),
	(716, 'Borrar E-Books', 'ebooks_delete', 'yes'),
	(717, 'Ver E-Books', 'ebooks_view', 'yes'),
	(718, 'Transporte', 'transport', 'yes'),
	(719, 'Agregar transporte', 'transport_add', 'yes'),
	(720, 'Editar transporte', 'transport_edit', 'yes'),
	(721, 'Borrar transporte', 'transport_delete', 'yes'),
	(722, 'Miembro de transporte', 'tmember', 'yes'),
	(723, 'Agregar miembro de transporte', 'tmember_add', 'yes'),
	(724, 'Editar miembro de transporte', 'tmember_edit', 'yes'),
	(725, 'Borrar miembro de transporte', 'tmember_delete', 'yes'),
	(726, 'Ver miembro de transporte', 'tmember_view', 'yes'),
	(727, 'Hostal', 'hostel', 'yes'),
	(728, 'Agregar hostal', 'hostel_add', 'yes'),
	(729, 'Editar hostal', 'hostel_edit', 'yes'),
	(730, 'Borrar hostal', 'hostel_delete', 'yes'),
	(731, 'Categoría hostal', 'category', 'yes'),
	(732, 'Agregar categoría hostal', 'category_add', 'yes'),
	(733, 'Editar categoría hostal', 'category_edit', 'yes'),
	(734, 'Borrar categoría hostal', 'category_delete', 'yes'),
	(735, 'Miembro del hostal', 'hmember', 'yes'),
	(736, 'Agregar miembro del hostal', 'hmember_add', 'yes'),
	(737, 'Editar miembro del hostal', 'hmember_edit', 'yes'),
	(738, 'Borrar miembro del hostal', 'hmember_delete', 'yes'),
	(739, 'Ver miembro del hostal', 'hmember_view', 'yes'),
	(740, 'Tipos de tarifas', 'feetypes', 'yes'),
	(741, 'Agregar tipos de tarifas', 'feetypes_add', 'yes'),
	(742, 'Editar tipos de tarifas', 'feetypes_edit', 'yes'),
	(743, 'Borrar tipos de tarifas', 'feetypes_delete', 'yes'),
	(744, 'Factura', 'invoice', 'yes'),
	(745, 'Agregar factura', 'invoice_add', 'yes'),
	(746, 'Editar factura', 'invoice_edit', 'yes'),
	(747, 'Borrar factura', 'invoice_delete', 'yes'),
	(748, 'Ver factura', 'invoice_view', 'yes'),
	(749, 'Historial de pagos', 'paymenthistory', 'yes'),
	(750, 'Editar historial de pagos', 'paymenthistory_edit', 'yes'),
	(751, 'Borrar historial de pagos', 'paymenthistory_delete', 'yes'),
	(752, 'Gastos', 'expense', 'yes'),
	(753, 'Agregar gastos', 'expense_add', 'yes'),
	(754, 'Editar gastos', 'expense_edit', 'yes'),
	(755, 'Borrar gastos', 'expense_delete', 'yes'),
	(756, 'Ingresos', 'income', 'yes'),
	(757, 'Agregar ingresos', 'income_add', 'yes'),
	(758, 'Editar ingresos', 'income_edit', 'yes'),
	(759, 'Borrar ingresos', 'income_delete', 'yes'),
	(760, 'Pago global', 'global_payment', 'yes'),
	(761, 'Aviso', 'notice', 'yes'),
	(762, 'Agregar aviso', 'notice_add', 'yes'),
	(763, 'Editar aviso', 'notice_edit', 'yes'),
	(764, 'Borrar aviso', 'notice_delete', 'yes'),
	(765, 'Ver aviso', 'notice_view', 'yes'),
	(766, 'Evento', 'event', 'yes'),
	(767, 'Agregar evento', 'event_add', 'yes'),
	(768, 'Editar evento', 'event_edit', 'yes'),
	(769, 'Borrar evento', 'event_delete', 'yes'),
	(770, 'Ver evento', 'event_view', 'yes'),
	(771, 'Vacaciones', 'holiday', 'yes'),
	(772, 'Agregar vacaciones', 'holiday_add', 'yes'),
	(773, 'Editar vacaciones', 'holiday_edit', 'yes'),
	(774, 'Borrar vacaciones', 'holiday_delete', 'yes'),
	(775, 'Ver vacaciones', 'holiday_view', 'yes'),
	(776, 'Informe de clase', 'classesreport', 'yes'),
	(777, 'Informe de estudiante', 'studentreport', 'yes'),
	(778, 'Informe de tarjeta de indentificación', 'idcardreport', 'yes'),
	(779, 'Informe de tarjeta de admisión', 'admitcardreport', 'yes'),
	(780, 'Informe de horario', 'routinereport', 'yes'),
	(781, 'Informe del programa de exámenes', 'examschedulereport', 'yes'),
	(782, 'Informe de asistencia', 'attendancereport', 'yes'),
	(783, 'Informe de resumen de asistencia', 'attendanceoverviewreport', 'yes'),
	(784, 'Informe de libros de la biblioteca', 'librarybooksreport', 'yes'),
	(785, 'Informe de la tarjeta de la biblioteca', 'librarycardreport', 'yes'),
	(786, 'Informe de préstamos de libros de la biblioteca', 'librarybookissuereport', 'yes'),
	(787, 'Informe de libreta', 'terminalreport', 'yes'),
	(788, 'Informe de etapa de mérito', 'meritstagereport', 'yes'),
	(789, 'Informe de hoja de tabulación', 'tabulationsheetreport', 'yes'),
	(790, 'Informe hoja de calificación', 'marksheetreport', 'yes'),
	(791, 'Informe de la tarjeta de progreso', 'progresscardreport', 'yes'),
	(792, 'Informe de examen Online', 'onlineexamreport', 'yes'),
	(793, 'Informe de preguntas del examen Online', 'onlineexamquestionreport', 'yes'),
	(794, 'Informe de admisión Online', 'onlineadmissionreport', 'yes'),
	(795, 'Informe de certificado', 'certificatereport', 'yes'),
	(796, 'Informe de permiso', 'leaveapplicationreport', 'yes'),
	(797, 'Informe de compra del producto', 'productpurchasereport', 'yes'),
	(798, 'Informe de venta de productos', 'productsalereport', 'yes'),
	(799, 'Informe de tarifas de pago de búsqueda', 'searchpaymentfeesreport', 'yes'),
	(800, 'Informe de tarifas', 'feesreport', 'yes'),
	(801, 'Informe de tasas adeudadas', 'duefeesreport', 'yes'),
	(802, 'Informe de tarifas de balance', 'balancefeesreport', 'yes'),
	(803, 'Informe de transacciones', 'transactionreport', 'yes'),
	(804, 'Informe multa de estudiante', 'studentfinereport', 'yes'),
	(805, 'Informe de salario', 'salaryreport', 'yes'),
	(806, 'Informe del libro mayor de cuentas', 'accountledgerreport', 'yes'),
	(807, 'Admisión Online', 'onlineadmission', 'yes'),
	(808, 'Información del visitante', 'visitorinfo', 'yes'),
	(809, 'Borrar información del visitante', 'visitorinfo_delete', 'yes'),
	(810, 'Ver información del visitante', 'visitorinfo_view', 'yes'),
	(811, 'Año académico', 'schoolyear', 'yes'),
	(812, 'Agregar año académico', 'schoolyear_add', 'yes'),
	(813, 'Editar año académico', 'schoolyear_edit', 'yes'),
	(814, 'Borrar año académico', 'schoolyear_delete', 'yes'),
	(815, 'Grupo de estudiantes', 'studentgroup', 'yes'),
	(816, 'Agregar grupo de estudiantes', 'studentgroup_add', 'yes'),
	(817, 'Editar grupo de estudiantes', 'studentgroup_edit', 'yes'),
	(818, 'Borrar grupo de estudiantes', 'studentgroup_delete', 'yes'),
	(819, 'Reclamo', 'complain', 'yes'),
	(820, 'Agregar reclamo', 'complain_add', 'yes'),
	(821, 'Editar reclamo', 'complain_edit', 'yes'),
	(822, 'Borrar reclamo', 'complain_delete', 'yes'),
	(823, 'Ver reclamo', 'complain_view', 'yes'),
	(824, 'Plantilla de certificado', 'certificate_template', 'yes'),
	(825, 'Agregar plantilla de certificado', 'certificate_template_add', 'yes'),
	(826, 'Editar plantilla de certificado', 'certificate_template_edit', 'yes'),
	(827, 'Borrar plantilla de certificado', 'certificate_template_delete', 'yes'),
	(828, 'Ver plantilla de certificado', 'certificate_template_view', 'yes'),
	(829, 'Administrador del sistema', 'systemadmin', 'yes'),
	(830, 'Agregar administrador del sistema', 'systemadmin_add', 'yes'),
	(831, 'Editar administrador del sistema', 'systemadmin_edit', 'yes'),
	(832, 'Borrar administrador del sistema', 'systemadmin_delete', 'yes'),
	(833, 'Ver administrador del sistema', 'systemadmin_view', 'yes'),
	(834, 'Restaurar contraseña', 'resetpassword', 'yes'),
	(835, 'Redes sociales', 'sociallink', 'yes'),
	(836, 'Agregar redes sociales', 'sociallink_add', 'yes'),
	(837, 'Editar redes sociales', 'sociallink_edit', 'yes'),
	(838, 'Borrar redes sociales', 'sociallink_delete', 'yes'),
	(839, 'Plantillla Mail / SMS', 'mailandsmstemplate', 'yes'),
	(840, 'Agregar plantilla Mail / SMS', 'mailandsmstemplate_add', 'yes'),
	(841, 'Editar plantilla Mail / SMS', 'mailandsmstemplate_edit', 'yes'),
	(842, 'Borrar plantilla Mail / SMS', 'mailandsmstemplate_delete', 'yes'),
	(843, 'Ver plantilla Mail / SMS', 'mailandsmstemplate_view', 'yes'),
	(844, 'Importar', 'bulkimport ', 'yes'),
	(845, 'Backup', 'backup', 'yes'),
	(846, 'Rol', 'usertype', 'yes'),
	(847, 'Agregar rol', 'usertype_add', 'yes'),
	(848, 'Editar rol', 'usertype_edit', 'yes'),
	(849, 'Borrar rol', 'usertype_delete', 'yes'),
	(850, 'Permiso', 'permission', 'yes'),
	(851, 'Actualización', 'update', 'yes'),
	(852, 'Categoría Post', 'posts_categories', 'yes'),
	(853, 'Agregar categoría post', 'posts_categories_add', 'yes'),
	(854, 'Editar categoría post', 'posts_categories_edit', 'yes'),
	(855, 'Borrar categoría post', 'posts_categories_delete', 'yes'),
	(856, 'Post', 'posts', 'yes'),
	(857, 'Agregar post', 'posts_add', 'yes'),
	(858, 'Editar post', 'posts_edit', 'yes'),
	(859, 'Borrar post', 'posts_delete', 'yes'),
	(860, 'Páginas', 'pages', 'yes'),
	(861, 'Agregar páginas', 'pages_add', 'yes'),
	(862, 'Editar páginas', 'pages_edit', 'yes'),
	(863, 'Editar páginas', 'pages_delete', 'yes'),
	(864, 'Menú', 'frontendmenu', 'yes'),
	(865, 'Configuración general', 'setting', 'yes'),
	(866, 'Configuración frontend', 'frontend_setting', 'yes'),
	(867, 'Configuración de pago', 'paymentsettings', 'yes'),
	(868, 'Configuración SMS', 'smssettings', 'yes'),
	(869, 'Configuración de Email SMTP', 'emailsetting', 'yes');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `permission_relationships` (
  `permission_id` int(11) NOT NULL,
  `usertype_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*!40000 ALTER TABLE `permission_relationships` DISABLE KEYS */;
INSERT INTO `permission_relationships` (`permission_id`, `usertype_id`) VALUES
	(501, 1),
	(502, 1),
	(503, 1),
	(504, 1),
	(505, 1),
	(506, 1),
	(507, 1),
	(508, 1),
	(509, 1),
	(510, 1),
	(511, 1),
	(512, 1),
	(513, 1),
	(514, 1),
	(515, 1),
	(516, 1),
	(517, 1),
	(518, 1),
	(519, 1),
	(520, 1),
	(521, 1),
	(522, 1),
	(523, 1),
	(524, 1),
	(525, 1),
	(526, 1),
	(527, 1),
	(528, 1),
	(530, 1),
	(531, 1),
	(532, 1),
	(533, 1),
	(534, 1),
	(535, 1),
	(536, 1),
	(537, 1),
	(538, 1),
	(539, 1),
	(540, 1),
	(541, 1),
	(542, 1),
	(543, 1),
	(544, 1),
	(545, 1),
	(546, 1),
	(547, 1),
	(548, 1),
	(549, 1),
	(550, 1),
	(551, 1),
	(552, 1),
	(553, 1),
	(554, 1),
	(555, 1),
	(556, 1),
	(557, 1),
	(558, 1),
	(559, 1),
	(560, 1),
	(561, 1),
	(562, 1),
	(563, 1),
	(564, 1),
	(565, 1),
	(566, 1),
	(567, 1),
	(568, 1),
	(569, 1),
	(570, 1),
	(571, 1),
	(572, 1),
	(573, 1),
	(574, 1),
	(575, 1),
	(576, 1),
	(577, 1),
	(578, 1),
	(579, 1),
	(580, 1),
	(581, 1),
	(582, 1),
	(583, 1),
	(584, 1),
	(585, 1),
	(586, 1),
	(587, 1),
	(588, 1),
	(589, 1),
	(590, 1),
	(591, 1),
	(592, 1),
	(593, 1),
	(594, 1),
	(595, 1),
	(596, 1),
	(597, 1),
	(598, 1),
	(599, 1),
	(600, 1),
	(601, 1),
	(602, 1),
	(603, 1),
	(604, 1),
	(605, 1),
	(606, 1),
	(607, 1),
	(608, 1),
	(609, 1),
	(610, 1),
	(611, 1),
	(612, 1),
	(613, 1),
	(614, 1),
	(615, 1),
	(616, 1),
	(617, 1),
	(618, 1),
	(619, 1),
	(620, 1),
	(621, 1),
	(622, 1),
	(623, 1),
	(624, 1),
	(625, 1),
	(626, 1),
	(627, 1),
	(628, 1),
	(629, 1),
	(630, 1),
	(631, 1),
	(632, 1),
	(633, 1),
	(634, 1),
	(635, 1),
	(636, 1),
	(637, 1),
	(638, 1),
	(639, 1),
	(640, 1),
	(641, 1),
	(642, 1),
	(643, 1),
	(644, 1),
	(645, 1),
	(646, 1),
	(647, 1),
	(648, 1),
	(649, 1),
	(650, 1),
	(651, 1),
	(652, 1),
	(653, 1),
	(654, 1),
	(655, 1),
	(656, 1),
	(657, 1),
	(658, 1),
	(659, 1),
	(660, 1),
	(661, 1),
	(662, 1),
	(663, 1),
	(664, 1),
	(665, 1),
	(666, 1),
	(667, 1),
	(668, 1),
	(669, 1),
	(670, 1),
	(671, 1),
	(672, 1),
	(673, 1),
	(674, 1),
	(675, 1),
	(676, 1),
	(677, 1),
	(678, 1),
	(679, 1),
	(680, 1),
	(681, 1),
	(682, 1),
	(683, 1),
	(684, 1),
	(685, 1),
	(686, 1),
	(687, 1),
	(688, 1),
	(689, 1),
	(690, 1),
	(691, 1),
	(692, 1),
	(693, 1),
	(694, 1),
	(695, 1),
	(696, 1),
	(697, 1),
	(698, 1),
	(699, 1),
	(700, 1),
	(701, 1),
	(702, 1),
	(703, 1),
	(704, 1),
	(705, 1),
	(706, 1),
	(707, 1),
	(708, 1),
	(709, 1),
	(710, 1),
	(711, 1),
	(712, 1),
	(713, 1),
	(714, 1),
	(715, 1),
	(716, 1),
	(717, 1),
	(718, 1),
	(719, 1),
	(720, 1),
	(721, 1),
	(722, 1),
	(723, 1),
	(724, 1),
	(725, 1),
	(726, 1),
	(727, 1),
	(728, 1),
	(729, 1),
	(730, 1),
	(731, 1),
	(732, 1),
	(733, 1),
	(734, 1),
	(735, 1),
	(736, 1),
	(737, 1),
	(738, 1),
	(739, 1),
	(740, 1),
	(741, 1),
	(742, 1),
	(743, 1),
	(744, 1),
	(745, 1),
	(746, 1),
	(747, 1),
	(748, 1),
	(749, 1),
	(750, 1),
	(751, 1),
	(752, 1),
	(753, 1),
	(754, 1),
	(755, 1),
	(756, 1),
	(757, 1),
	(758, 1),
	(759, 1),
	(760, 1),
	(761, 1),
	(762, 1),
	(763, 1),
	(764, 1),
	(765, 1),
	(766, 1),
	(767, 1),
	(768, 1),
	(769, 1),
	(770, 1),
	(771, 1),
	(772, 1),
	(773, 1),
	(774, 1),
	(775, 1),
	(776, 1),
	(777, 1),
	(778, 1),
	(779, 1),
	(780, 1),
	(781, 1),
	(782, 1),
	(783, 1),
	(784, 1),
	(785, 1),
	(786, 1),
	(787, 1),
	(788, 1),
	(789, 1),
	(790, 1),
	(791, 1),
	(792, 1),
	(793, 1),
	(794, 1),
	(795, 1),
	(796, 1),
	(797, 1),
	(798, 1),
	(799, 1),
	(800, 1),
	(801, 1),
	(802, 1),
	(803, 1),
	(804, 1),
	(805, 1),
	(806, 1),
	(807, 1),
	(808, 1),
	(809, 1),
	(810, 1),
	(811, 1),
	(812, 1),
	(813, 1),
	(814, 1),
	(815, 1),
	(816, 1),
	(817, 1),
	(818, 1),
	(819, 1),
	(820, 1),
	(821, 1),
	(822, 1),
	(823, 1),
	(824, 1),
	(825, 1),
	(826, 1),
	(827, 1),
	(828, 1),
	(829, 1),
	(830, 1),
	(831, 1),
	(832, 1),
	(833, 1),
	(834, 1),
	(835, 1),
	(836, 1),
	(837, 1),
	(838, 1),
	(839, 1),
	(840, 1),
	(841, 1),
	(842, 1),
	(843, 1),
	(844, 1),
	(845, 1),
	(846, 1),
	(847, 1),
	(848, 1),
	(849, 1),
	(850, 1),
	(851, 1),
	(852, 1),
	(853, 1),
	(854, 1),
	(855, 1),
	(856, 1),
	(857, 1),
	(858, 1),
	(859, 1),
	(860, 1),
	(861, 1),
	(862, 1),
	(863, 1),
	(864, 1),
	(865, 1),
	(866, 1),
	(867, 1),
	(868, 1),
	(869, 1),
	(501, 2),
	(502, 2),
	(506, 2),
	(507, 2),
	(511, 2),
	(512, 2),
	(516, 2),
	(531, 2),
	(535, 2),
	(536, 2),
	(537, 2),
	(538, 2),
	(539, 2),
	(540, 2),
	(541, 2),
	(542, 2),
	(543, 2),
	(544, 2),
	(548, 2),
	(549, 2),
	(550, 2),
	(551, 2),
	(553, 2),
	(554, 2),
	(556, 2),
	(561, 2),
	(569, 2),
	(570, 2),
	(571, 2),
	(572, 2),
	(573, 2),
	(579, 2),
	(580, 2),
	(581, 2),
	(582, 2),
	(586, 2),
	(587, 2),
	(588, 2),
	(590, 2),
	(591, 2),
	(592, 2),
	(594, 2),
	(595, 2),
	(596, 2),
	(598, 2),
	(599, 2),
	(600, 2),
	(601, 2),
	(603, 2),
	(604, 2),
	(605, 2),
	(607, 2),
	(683, 2),
	(684, 2),
	(685, 2),
	(686, 2),
	(687, 2),
	(688, 2),
	(693, 2),
	(694, 2),
	(695, 2),
	(705, 2),
	(713, 2),
	(717, 2),
	(718, 2),
	(727, 2),
	(731, 2),
	(761, 2),
	(765, 2),
	(766, 2),
	(770, 2),
	(771, 2),
	(775, 2),
	(777, 2),
	(780, 2),
	(781, 2),
	(782, 2),
	(783, 2),
	(787, 2),
	(788, 2),
	(789, 2),
	(790, 2),
	(791, 2),
	(792, 2),
	(793, 2),
	(819, 2),
	(820, 2),
	(823, 2),
	(501, 4),
	(502, 4),
	(506, 4),
	(512, 4),
	(516, 4),
	(531, 4),
	(535, 4),
	(544, 4),
	(548, 4),
	(550, 4),
	(561, 4),
	(571, 4),
	(573, 4),
	(579, 4),
	(580, 4),
	(693, 4),
	(696, 4),
	(700, 4),
	(704, 4),
	(705, 4),
	(709, 4),
	(712, 4),
	(718, 4),
	(722, 4),
	(726, 4),
	(727, 4),
	(731, 4),
	(735, 4),
	(739, 4),
	(744, 4),
	(748, 4),
	(749, 4),
	(761, 4),
	(765, 4),
	(766, 4),
	(770, 4),
	(771, 4),
	(775, 4),
	(819, 4),
	(820, 4),
	(823, 4),
	(501, 5),
	(512, 5),
	(516, 5),
	(554, 5),
	(556, 5),
	(579, 5),
	(580, 5),
	(608, 5),
	(609, 5),
	(610, 5),
	(611, 5),
	(612, 5),
	(613, 5),
	(614, 5),
	(615, 5),
	(616, 5),
	(617, 5),
	(618, 5),
	(619, 5),
	(620, 5),
	(621, 5),
	(622, 5),
	(649, 5),
	(650, 5),
	(651, 5),
	(652, 5),
	(653, 5),
	(654, 5),
	(655, 5),
	(656, 5),
	(657, 5),
	(658, 5),
	(659, 5),
	(660, 5),
	(661, 5),
	(662, 5),
	(663, 5),
	(664, 5),
	(665, 5),
	(666, 5),
	(667, 5),
	(668, 5),
	(669, 5),
	(670, 5),
	(671, 5),
	(672, 5),
	(673, 5),
	(674, 5),
	(683, 5),
	(684, 5),
	(685, 5),
	(686, 5),
	(687, 5),
	(718, 5),
	(722, 5),
	(723, 5),
	(724, 5),
	(725, 5),
	(726, 5),
	(727, 5),
	(731, 5),
	(735, 5),
	(736, 5),
	(737, 5),
	(738, 5),
	(739, 5),
	(740, 5),
	(741, 5),
	(742, 5),
	(743, 5),
	(744, 5),
	(745, 5),
	(746, 5),
	(747, 5),
	(748, 5),
	(749, 5),
	(750, 5),
	(751, 5),
	(752, 5),
	(753, 5),
	(754, 5),
	(755, 5),
	(756, 5),
	(757, 5),
	(758, 5),
	(759, 5),
	(760, 5),
	(761, 5),
	(765, 5),
	(766, 5),
	(770, 5),
	(771, 5),
	(775, 5),
	(797, 5),
	(798, 5),
	(799, 5),
	(800, 5),
	(801, 5),
	(802, 5),
	(803, 5),
	(804, 5),
	(805, 5),
	(819, 5),
	(820, 5),
	(823, 5),
	(501, 6),
	(512, 6),
	(516, 6),
	(531, 6),
	(554, 6),
	(556, 6),
	(579, 6),
	(580, 6),
	(683, 6),
	(684, 6),
	(685, 6),
	(686, 6),
	(687, 6),
	(700, 6),
	(701, 6),
	(702, 6),
	(703, 6),
	(704, 6),
	(705, 6),
	(706, 6),
	(707, 6),
	(708, 6),
	(709, 6),
	(710, 6),
	(711, 6),
	(712, 6),
	(713, 6),
	(714, 6),
	(715, 6),
	(716, 6),
	(717, 6),
	(718, 6),
	(727, 6),
	(731, 6),
	(761, 6),
	(765, 6),
	(766, 6),
	(770, 6),
	(771, 6),
	(775, 6),
	(777, 6),
	(784, 6),
	(785, 6),
	(786, 6),
	(819, 6),
	(820, 6),
	(823, 6),
	(501, 7),
	(502, 7),
	(506, 7),
	(507, 7),
	(511, 7),
	(512, 7),
	(516, 7),
	(517, 7),
	(521, 7),
	(548, 7),
	(550, 7),
	(551, 7),
	(553, 7),
	(554, 7),
	(556, 7),
	(579, 7),
	(580, 7),
	(683, 7),
	(684, 7),
	(685, 7),
	(686, 7),
	(687, 7),
	(727, 7),
	(731, 7),
	(761, 7),
	(765, 7),
	(766, 7),
	(770, 7),
	(771, 7),
	(775, 7),
	(808, 7),
	(809, 7),
	(810, 7),
	(819, 7),
	(820, 7),
	(823, 7),
	(501, 3),
	(502, 3),
	(512, 3),
	(516, 3),
	(531, 3),
	(539, 3),
	(543, 3),
	(544, 3),
	(548, 3),
	(561, 3),
	(571, 3),
	(579, 3),
	(580, 3),
	(683, 3),
	(684, 3),
	(685, 3),
	(686, 3),
	(687, 3),
	(693, 3),
	(700, 3),
	(705, 3),
	(709, 3),
	(712, 3),
	(713, 3),
	(717, 3),
	(718, 3),
	(722, 3),
	(727, 3),
	(731, 3),
	(744, 3),
	(748, 3),
	(749, 3),
	(761, 3),
	(765, 3),
	(766, 3),
	(770, 3),
	(771, 3),
	(775, 3),
	(819, 3),
	(820, 3),
	(823, 3);
/*!40000 ALTER TABLE `permission_relationships` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `posts` (
  `postsID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(128) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `content` text,
  `status` int(11) DEFAULT NULL COMMENT '1 => active, 2 => draft, 3 => trash, 4 => review  ',
  `visibility` int(11) DEFAULT NULL COMMENT '1 => public 2 => protected 3 => private ',
  `publish_date` datetime DEFAULT NULL,
  `parentID` int(11) NOT NULL DEFAULT '0',
  `postorder` int(11) NOT NULL DEFAULT '0',
  `featured_image` varchar(11) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `modify_date` datetime DEFAULT NULL,
  `create_userID` int(11) DEFAULT NULL,
  `create_username` varchar(60) DEFAULT NULL,
  `create_usertypeID` int(11) DEFAULT NULL,
  `password` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`postsID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` (`postsID`, `title`, `url`, `content`, `status`, `visibility`, `publish_date`, `parentID`, `postorder`, `featured_image`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertypeID`, `password`) VALUES
	(2, 'Carreras A Elección', 'carreras-a-eleccion', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Neque, ex quas nam temporibus, expedita tenetur perspiciatis necessitatibus maxime nobis deleniti reiciendis eos quia, laboriosam consectetur atque unde impedit, quidem rerum. Consectetur, repudiandae? Pariatur dolorum a rem dolore quidem, repellendus minus est laudantium reiciendis ad! Quis necessitatibus, asperiores sit animi voluptatibus ad. Sed natus perferendis ipsam eum, ratione cum! Atque iusto itaque expedita, quasi consequatur ratione? Inventore neque eius repellendus error libero adipisci, eligendi saepe doloremque et assumenda praesentium dolores deserunt optio sequi facilis nihil est sapiente dicta mollitia fugit sunt officiis animi fugiat suscipit at. Repudiandae id provident et maiores.Lorem ipsum dolor sit amet, consectetur adipisicing elit. Neque, ex quas nam temporibus, expedita tenetur perspiciatis necessitatibus maxime nobis deleniti reiciendis eos quia, laboriosam consectetur atque unde impedit, quidem rerum. Consectetur, repudiandae? Pariatur dolorum a rem dolore quidem, repellendus minus est laudantium reiciendis ad! Quis necessitatibus, asperiores sit animi voluptatibus ad. Sed natus perferendis ipsam eum, ratione cum! Atque iusto itaque expedita, quasi consequatur ratione? Inventore neque eius repellendus error libero adipisci, eligendi saepe doloremque et assumenda praesentium </p><h2>Lorem ipsum<br></h2><p>dolores deserunt optio sequi facilis nihil est sapiente dicta mollitia fugit sunt officiis animi fugiat suscipit at. Repudiandae id provident et maiores.Lorem ipsum dolor sit amet, consectetur adipisicing elit. Neque, ex quas nam temporibus, expedita tenetur perspiciatis necessitatibus maxime nobis deleniti reiciendis eos quia, laboriosam consectetur atque unde impedit, quidem rerum. Consectetur, repudiandae? Pariatur dolorum a rem dolore quidem, repellendus minus est laudantium reiciendis ad! Quis necessitatibus, asperiores sit animi voluptatibus ad. Sed natus perferendis ipsam eum, ratione cum! Atque iusto itaque expedita, quasi consequatur ratione? Inventore neque eius repellendus error libero adipisci, eligendi saepe doloremque et assumenda praesentium dolores deserunt optio sequi facilis nihil est sapiente dicta mollitia fugit sunt officiis animi fugiat suscipit at. Repudiandae id provident et maiores.<br></p>', 1, 3, '2019-04-01 12:33:01', 0, 0, '13', '2019-04-01 12:38:05', '2019-04-10 11:23:12', 1, 'admin', 1, NULL),
	(3, 'Nuevas Materias O Asignaturas', 'nuevas-materias-o-asignaturas', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Neque, ex quas nam temporibus, expedita tenetur perspiciatis necessitatibus maxime nobis deleniti reiciendis eos quia, laboriosam consectetur atque unde impedit, quidem rerum. Consectetur, repudiandae? Pariatur dolorum a rem dolore quidem, repellendus minus est laudantium reiciendis ad! Quis necessitatibus, asperiores sit animi voluptatibus ad. Sed natus perferendis ipsam eum, ratione cum! Atque iusto itaque expedita, quasi consequatur ratione? Inventore neque eius repellendus error libero adipisci, eligendi saepe doloremque et assumenda praesentium dolores deserunt optio sequi facilis nihil est sapiente dicta mollitia fugit sunt officiis animi fugiat suscipit at. Repudiandae id provident et maiores.</p><h2>Lorem ipsum dolor sit amet<br></h2><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Neque, ex quas nam temporibus, expedita tenetur perspiciatis necessitatibus maxime nobis deleniti reiciendis eos quia, laboriosam consectetur atque unde impedit, quidem rerum. Consectetur, repudiandae? Pariatur dolorum a rem dolore quidem, repellendus minus est laudantium reiciendis ad! Quis necessitatibus, asperiores sit animi voluptatibus ad. Sed natus perferendis ipsam eum, ratione cum! Atque iusto itaque expedita, quasi consequatur ratione? Inventore neque eius repellendus error libero adipisci, eligendi saepe doloremque et assumenda praesentium dolores deserunt optio sequi facilis nihil est sapiente dicta mollitia fugit sunt officiis animi fugiat suscipit at. Repudiandae id provident et maiores.</p>', 1, 2, '2019-04-01 12:41:01', 0, 0, '12', '2019-04-01 12:42:12', '2019-04-10 11:21:00', 1, 'admin', 1, '');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `posts_categories` (
  `posts_categoriesID` int(11) NOT NULL AUTO_INCREMENT,
  `posts_categories` varchar(40) DEFAULT NULL,
  `posts_slug` varchar(250) DEFAULT NULL,
  `posts_parent` int(11) DEFAULT '0',
  `posts_description` text,
  PRIMARY KEY (`posts_categoriesID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `posts_categories` DISABLE KEYS */;
INSERT INTO `posts_categories` (`posts_categoriesID`, `posts_categories`, `posts_slug`, `posts_parent`, `posts_description`) VALUES
	(1, 'ciencia', '#', 0, 'qqqqqq'),
	(2, 'inscripciones', '#', 0, ''),
	(3, 'curricula', '#', 0, ''),
	(4, 'manual', '#', 0, ''),
	(5, 'educación', '#', 0, ''),
	(6, 'mensualidades', '#', 0, '');
/*!40000 ALTER TABLE `posts_categories` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `posts_category` (
  `posts_categoryID` int(11) NOT NULL AUTO_INCREMENT,
  `postsID` int(11) NOT NULL,
  `posts_categoriesID` int(11) NOT NULL,
  PRIMARY KEY (`posts_categoryID`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `posts_category` DISABLE KEYS */;
INSERT INTO `posts_category` (`posts_categoryID`, `postsID`, `posts_categoriesID`) VALUES
	(17, 1, 1),
	(18, 3, 2),
	(19, 2, 2);
/*!40000 ALTER TABLE `posts_category` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `product` (
  `productID` int(11) NOT NULL AUTO_INCREMENT,
  `productcategoryID` int(11) NOT NULL,
  `productname` varchar(128) NOT NULL,
  `productbuyingprice` double NOT NULL,
  `productsellingprice` double NOT NULL,
  `productdesc` text NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `product` DISABLE KEYS */;
INSERT INTO `product` (`productID`, `productcategoryID`, `productname`, `productbuyingprice`, `productsellingprice`, `productdesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES
	(1, 1, 'BOLÍGRAFOS', 0.5, 2, '', '2019-03-25 18:07:02', '2019-03-25 18:07:02', 1, 1),
	(2, 2, 'TINTA PARA IMPRESORA', 56, 80, '', '2019-03-25 18:08:41', '2019-03-25 18:08:41', 1, 1),
	(3, 1, 'PAPEL CARTA', 50, 95, '', '2019-03-25 18:09:03', '2019-03-25 18:09:03', 1, 1),
	(4, 1, 'MARCADORES PARA PIZARRA', 56, 60, '', '2019-03-25 18:10:08', '2019-03-25 18:10:08', 1, 1),
	(5, 1, 'BORRADORES', 5, 10, '', '2019-03-25 18:10:29', '2019-03-25 18:10:29', 1, 1),
	(6, 1, 'LAPICES', 2, 5, '', '2019-03-25 18:10:53', '2019-03-25 18:10:53', 1, 1);
/*!40000 ALTER TABLE `product` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `productcategory` (
  `productcategoryID` int(11) NOT NULL AUTO_INCREMENT,
  `productcategoryname` varchar(128) NOT NULL,
  `productcategorydesc` text NOT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productcategoryID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `productcategory` DISABLE KEYS */;
INSERT INTO `productcategory` (`productcategoryID`, `productcategoryname`, `productcategorydesc`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES
	(1, 'MATERIAL ESCOLAR', '', '2019-03-25 18:06:23', '2019-03-25 18:08:22', 1, 1),
	(2, 'MATERIAL PARA OFICINA', '', '2019-03-25 18:08:13', '2019-03-25 18:08:13', 1, 1);
/*!40000 ALTER TABLE `productcategory` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `productpurchase` (
  `productpurchaseID` int(11) NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `productsupplierID` int(11) NOT NULL,
  `productwarehouseID` int(11) NOT NULL,
  `productpurchasereferenceno` varchar(100) NOT NULL,
  `productpurchasedate` date NOT NULL,
  `productpurchasefile` varchar(200) DEFAULT NULL,
  `productpurchasefileorginalname` varchar(200) DEFAULT NULL,
  `productpurchasedescription` text,
  `productpurchasestatus` int(11) NOT NULL COMMENT '0 = pending, 1 = partial_paid,  2 = fully_paid',
  `productpurchaserefund` int(11) NOT NULL DEFAULT '0' COMMENT '0 = not refund, 1 = refund ',
  `productpurchasetaxID` int(11) NOT NULL DEFAULT '0',
  `productpurchasetaxamount` double NOT NULL DEFAULT '0',
  `productpurchasediscount` double NOT NULL DEFAULT '0',
  `productpurchaseshipping` double NOT NULL DEFAULT '0',
  `productpurchasepaymentterm` int(11) NOT NULL DEFAULT '0',
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productpurchaseID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `productpurchase` DISABLE KEYS */;
INSERT INTO `productpurchase` (`productpurchaseID`, `schoolyearID`, `productsupplierID`, `productwarehouseID`, `productpurchasereferenceno`, `productpurchasedate`, `productpurchasefile`, `productpurchasefileorginalname`, `productpurchasedescription`, `productpurchasestatus`, `productpurchaserefund`, `productpurchasetaxID`, `productpurchasetaxamount`, `productpurchasediscount`, `productpurchaseshipping`, `productpurchasepaymentterm`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES
	(1, 1, 1, 1, '5756869', '2019-03-25', '', '', 'COMPRA DE MATERIAL ESCOLAR PARA SECUNDARIA', 0, 0, 0, 0, 0, 0, 0, '2019-03-25 18:16:16', '2019-03-25 18:16:16', 1, 1);
/*!40000 ALTER TABLE `productpurchase` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `productpurchaseitem` (
  `productpurchaseitemID` int(11) NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `productpurchaseID` int(11) NOT NULL,
  `productID` int(11) NOT NULL,
  `productpurchaseunitprice` double NOT NULL,
  `productpurchasequantity` double NOT NULL,
  PRIMARY KEY (`productpurchaseitemID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `productpurchaseitem` DISABLE KEYS */;
INSERT INTO `productpurchaseitem` (`productpurchaseitemID`, `schoolyearID`, `productpurchaseID`, `productID`, `productpurchaseunitprice`, `productpurchasequantity`) VALUES
	(1, 1, 1, 6, 2, 2);
/*!40000 ALTER TABLE `productpurchaseitem` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `productpurchasepaid` (
  `productpurchasepaidID` int(11) NOT NULL AUTO_INCREMENT,
  `productpurchasepaidschoolyearID` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `productpurchaseID` int(11) NOT NULL,
  `productpurchasepaiddate` date NOT NULL,
  `productpurchasepaidreferenceno` varchar(100) NOT NULL,
  `productpurchasepaidamount` double NOT NULL,
  `productpurchasepaidpaymentmethod` int(11) NOT NULL COMMENT '1 = cash, 2 = cheque, 3 = crediit card, 4 = other',
  `productpurchasepaidfile` varchar(200) DEFAULT NULL,
  `productpurchasepaidorginalname` varchar(200) DEFAULT NULL,
  `productpurchasepaiddescription` text,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productpurchasepaidID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `productpurchasepaid` DISABLE KEYS */;
/*!40000 ALTER TABLE `productpurchasepaid` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `productsale` (
  `productsaleID` int(11) NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `productsalecustomertypeID` int(11) NOT NULL,
  `productsalecustomerID` int(11) NOT NULL,
  `productsalereferenceno` varchar(100) NOT NULL,
  `productsaledate` date NOT NULL,
  `productsalefile` varchar(200) DEFAULT NULL,
  `productsalefileorginalname` varchar(200) DEFAULT NULL,
  `productsaledescription` text,
  `productsalestatus` int(11) NOT NULL COMMENT '0 = select_payment_status, 1 = due,  2 = partial, 3 = Paid',
  `productsalerefund` int(11) NOT NULL DEFAULT '0' COMMENT '0 = not refund, 1 = refund ',
  `productsaletaxID` int(11) NOT NULL DEFAULT '0',
  `productsaletaxamount` double NOT NULL DEFAULT '0',
  `productsalediscount` double NOT NULL DEFAULT '0',
  `productsaleshipping` double NOT NULL DEFAULT '0',
  `productsalepaymentterm` int(11) NOT NULL DEFAULT '0',
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productsaleID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `productsale` DISABLE KEYS */;
INSERT INTO `productsale` (`productsaleID`, `schoolyearID`, `productsalecustomertypeID`, `productsalecustomerID`, `productsalereferenceno`, `productsaledate`, `productsalefile`, `productsalefileorginalname`, `productsaledescription`, `productsalestatus`, `productsalerefund`, `productsaletaxID`, `productsaletaxamount`, `productsalediscount`, `productsaleshipping`, `productsalepaymentterm`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES
	(1, 1, 1, 1, '21311', '2019-03-25', '', '', '', 2, 0, 0, 0, 0, 0, 0, '2019-03-25 18:19:38', '2019-03-25 18:19:38', 1, 1);
/*!40000 ALTER TABLE `productsale` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `productsaleitem` (
  `productsaleitemID` int(11) NOT NULL AUTO_INCREMENT,
  `schoolyearID` int(11) NOT NULL,
  `productsaleID` int(11) NOT NULL,
  `productID` int(11) NOT NULL,
  `productsaleserialno` varchar(100) DEFAULT '0',
  `productsaleunitprice` double NOT NULL,
  `productsalequantity` double NOT NULL,
  PRIMARY KEY (`productsaleitemID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `productsaleitem` DISABLE KEYS */;
INSERT INTO `productsaleitem` (`productsaleitemID`, `schoolyearID`, `productsaleID`, `productID`, `productsaleserialno`, `productsaleunitprice`, `productsalequantity`) VALUES
	(1, 1, 1, 6, '0', 5, 2);
/*!40000 ALTER TABLE `productsaleitem` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `productsalepaid` (
  `productsalepaidID` int(11) NOT NULL AUTO_INCREMENT,
  `productsalepaidschoolyearID` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `productsaleID` int(11) NOT NULL,
  `productsalepaiddate` date NOT NULL,
  `productsalepaidreferenceno` varchar(100) NOT NULL,
  `productsalepaidamount` double NOT NULL,
  `productsalepaidpaymentmethod` int(11) NOT NULL COMMENT '1 = cash, 2 = cheque, 3 = crediit card, 4 = other',
  `productsalepaidfile` varchar(200) DEFAULT NULL,
  `productsalepaidorginalname` varchar(200) DEFAULT NULL,
  `productsalepaiddescription` text,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productsalepaidID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `productsalepaid` DISABLE KEYS */;
INSERT INTO `productsalepaid` (`productsalepaidID`, `productsalepaidschoolyearID`, `schoolyearID`, `productsaleID`, `productsalepaiddate`, `productsalepaidreferenceno`, `productsalepaidamount`, `productsalepaidpaymentmethod`, `productsalepaidfile`, `productsalepaidorginalname`, `productsalepaiddescription`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES
	(1, 1, 1, 1, '2019-03-25', '556', 4, 1, '', '', '', '2019-03-25 18:19:38', '2019-03-25 18:19:38', 1, 1);
/*!40000 ALTER TABLE `productsalepaid` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `productsupplier` (
  `productsupplierID` int(11) NOT NULL AUTO_INCREMENT,
  `productsuppliercompanyname` varchar(128) NOT NULL,
  `productsuppliername` varchar(40) NOT NULL,
  `productsupplieremail` varchar(40) DEFAULT NULL,
  `productsupplierphone` varchar(20) DEFAULT NULL,
  `productsupplieraddress` text,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productsupplierID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `productsupplier` DISABLE KEYS */;
INSERT INTO `productsupplier` (`productsupplierID`, `productsuppliercompanyname`, `productsuppliername`, `productsupplieremail`, `productsupplierphone`, `productsupplieraddress`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES
	(1, 'AMERICAS', 'ARTURO VARGAS', 'ARTURO@CORREO.COM', '87763522', 'CALLE LOMA', '2019-03-25 18:14:08', '2019-03-25 18:14:08', 1, 1),
	(2, 'GRAFICOS S.A.', 'SUSANA TORREZ', 'SUSANA@GMAIL.COM', '655543622', 'CALLE JUPITER', '2019-03-25 18:15:07', '2019-03-25 18:15:07', 1, 1);
/*!40000 ALTER TABLE `productsupplier` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `productwarehouse` (
  `productwarehouseID` int(11) NOT NULL AUTO_INCREMENT,
  `productwarehousename` varchar(128) NOT NULL,
  `productwarehousecode` varchar(128) NOT NULL,
  `productwarehouseemail` varchar(40) DEFAULT NULL,
  `productwarehousephone` varchar(20) DEFAULT NULL,
  `productwarehouseaddress` text,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`productwarehouseID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `productwarehouse` DISABLE KEYS */;
INSERT INTO `productwarehouse` (`productwarehouseID`, `productwarehousename`, `productwarehousecode`, `productwarehouseemail`, `productwarehousephone`, `productwarehouseaddress`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES
	(1, 'LIBRERIA ALEXANDER', 'EWQ24', 'INFO@LIBRERIA.COM', '65444323', 'CALLE LIBERTADORES', '2019-03-25 18:11:45', '2019-03-25 18:11:45', 1, 1),
	(2, 'EL MAESTRO S.A.', 'EW4U5', 'INFO@MAESTRO.COM', '757888564', '', '2019-03-25 18:12:19', '2019-03-25 18:12:19', 1, 1),
	(3, 'ALMACEN LORETO', 'TU532', 'LORETO@CORREO.COM', '885656436', '', '2019-03-25 18:12:57', '2019-03-25 18:12:57', 1, 1);
/*!40000 ALTER TABLE `productwarehouse` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `promotionlog` (
  `promotionLogID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `promotionType` varchar(50) DEFAULT NULL,
  `classesID` int(11) NOT NULL,
  `jumpClassID` int(11) NOT NULL,
  `schoolYearID` int(11) NOT NULL,
  `jumpSchoolYearID` int(11) NOT NULL,
  `subjectandsubjectcodeandmark` longtext,
  `exams` longtext,
  `markpercentages` longtext,
  `promoteStudents` longtext,
  `status` int(11) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  PRIMARY KEY (`promotionLogID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `promotionlog` DISABLE KEYS */;
/*!40000 ALTER TABLE `promotionlog` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `purchase` (
  `purchaseID` int(11) NOT NULL AUTO_INCREMENT,
  `assetID` int(11) NOT NULL,
  `vendorID` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit` int(11) DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `service_date` date DEFAULT NULL,
  `purchase_price` double NOT NULL,
  `purchased_by` int(11) NOT NULL,
  `usertypeID` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `expire_date` date DEFAULT NULL,
  `create_date` date NOT NULL,
  `modify_date` date NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`purchaseID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `purchase` DISABLE KEYS */;
INSERT INTO `purchase` (`purchaseID`, `assetID`, `vendorID`, `quantity`, `unit`, `purchase_date`, `service_date`, `purchase_price`, `purchased_by`, `usertypeID`, `status`, `expire_date`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES
	(1, 1, 1, 53, 2, '2019-04-26', '2019-04-26', 50, 1, 5, 1, '2020-02-10', '2019-04-26', '2019-04-26', 1, 1);
/*!40000 ALTER TABLE `purchase` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `question_answer` (
  `answerID` int(11) NOT NULL AUTO_INCREMENT,
  `questionID` int(11) NOT NULL,
  `optionID` int(11) DEFAULT NULL,
  `typeNumber` int(11) NOT NULL,
  `text` text,
  PRIMARY KEY (`answerID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `question_answer` DISABLE KEYS */;
INSERT INTO `question_answer` (`answerID`, `questionID`, `optionID`, `typeNumber`, `text`) VALUES
	(1, 1, 1, 1, NULL),
	(2, 2, 11, 2, NULL),
	(3, 2, 13, 2, NULL),
	(5, 3, 21, 2, NULL);
/*!40000 ALTER TABLE `question_answer` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `question_bank` (
  `questionBankID` int(11) NOT NULL AUTO_INCREMENT,
  `question` text NOT NULL,
  `explanation` text,
  `levelID` int(11) DEFAULT NULL,
  `groupID` int(11) DEFAULT NULL,
  `totalQuestion` int(11) DEFAULT '0',
  `totalOption` int(11) DEFAULT NULL,
  `typeNumber` int(11) DEFAULT NULL,
  `parentID` int(11) DEFAULT '0',
  `time` int(11) DEFAULT '0',
  `mark` int(11) DEFAULT '0',
  `hints` text,
  `upload` varchar(512) DEFAULT NULL,
  `subjectID` int(11) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_usertypeID` int(11) NOT NULL,
  PRIMARY KEY (`questionBankID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `question_bank` DISABLE KEYS */;
INSERT INTO `question_bank` (`questionBankID`, `question`, `explanation`, `levelID`, `groupID`, `totalQuestion`, `totalOption`, `typeNumber`, `parentID`, `time`, `mark`, `hints`, `upload`, `subjectID`, `create_date`, `modify_date`, `create_userID`, `create_usertypeID`) VALUES
	(1, 'Día de la independencia de EEUU', '', 1, 2, 0, 3, 1, 0, 0, 100, '', '', NULL, '2019-04-05 14:20:21', '2019-04-05 14:20:21', 1, 1),
	(2, '2 de los siguientes son animales vertebrados<br>', '', 2, 3, 0, 4, 2, 0, 0, 100, '', '', NULL, '2019-04-05 14:23:05', '2019-04-05 14:23:05', 1, 1),
	(3, '5+5', '', 1, 4, 0, 3, 2, 0, 0, 100, '', '', NULL, '2019-05-04 16:43:04', '2019-05-04 17:05:50', 1, 1);
/*!40000 ALTER TABLE `question_bank` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `question_group` (
  `questionGroupID` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) NOT NULL,
  PRIMARY KEY (`questionGroupID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `question_group` DISABLE KEYS */;
INSERT INTO `question_group` (`questionGroupID`, `title`) VALUES
	(1, 'Razonamiento'),
	(2, 'Conocimiento general'),
	(3, 'General'),
	(4, 'Matemáticas');
/*!40000 ALTER TABLE `question_group` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `question_level` (
  `questionLevelID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  PRIMARY KEY (`questionLevelID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `question_level` DISABLE KEYS */;
INSERT INTO `question_level` (`questionLevelID`, `name`) VALUES
	(1, 'Fácil'),
	(2, 'Medio'),
	(3, 'Difícil');
/*!40000 ALTER TABLE `question_level` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `question_option` (
  `optionID` int(11) NOT NULL AUTO_INCREMENT,
  `questionID` int(11) NOT NULL,
  `name` varchar(512) NOT NULL,
  `img` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`optionID`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `question_option` DISABLE KEYS */;
INSERT INTO `question_option` (`optionID`, `questionID`, `name`, `img`) VALUES
	(1, 1, '4 julio', ''),
	(2, 1, '1 julio', ''),
	(3, 1, '4 junio', ''),
	(4, 1, '', NULL),
	(5, 1, '', NULL),
	(6, 1, '', NULL),
	(7, 1, '', NULL),
	(8, 1, '', NULL),
	(9, 1, '', NULL),
	(10, 1, '', NULL),
	(11, 2, 'raton', ''),
	(12, 2, 'araña', ''),
	(13, 2, 'pez', ''),
	(14, 2, 'pulpo', ''),
	(15, 2, '', NULL),
	(16, 2, '', NULL),
	(17, 2, '', NULL),
	(18, 2, '', NULL),
	(19, 2, '', NULL),
	(20, 2, '', NULL),
	(21, 3, '10', NULL);
/*!40000 ALTER TABLE `question_option` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `question_type` (
  `questionTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `typeNumber` int(11) NOT NULL,
  `name` varchar(512) NOT NULL,
  PRIMARY KEY (`questionTypeID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `question_type` DISABLE KEYS */;
INSERT INTO `question_type` (`questionTypeID`, `typeNumber`, `name`) VALUES
	(1, 1, 'Simple respuesta'),
	(2, 2, 'Multiples respuestas'),
	(3, 3, 'Responada los campos vacios');
/*!40000 ALTER TABLE `question_type` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `reset` (
  `resetID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `keyID` varchar(128) NOT NULL,
  `email` varchar(60) NOT NULL,
  PRIMARY KEY (`resetID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `reset` DISABLE KEYS */;
/*!40000 ALTER TABLE `reset` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `routine` (
  `routineID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `classesID` int(11) NOT NULL,
  `sectionID` int(11) NOT NULL,
  `subjectID` int(11) NOT NULL,
  `schoolyearID` int(11) NOT NULL,
  `teacherID` int(11) NOT NULL,
  `day` varchar(60) NOT NULL,
  `start_time` varchar(10) NOT NULL,
  `end_time` varchar(10) NOT NULL,
  `room` tinytext NOT NULL,
  PRIMARY KEY (`routineID`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `routine` DISABLE KEYS */;
INSERT INTO `routine` (`routineID`, `classesID`, `sectionID`, `subjectID`, `schoolyearID`, `teacherID`, `day`, `start_time`, `end_time`, `room`) VALUES
	(1, 2, 1, 1, 1, 4, 'LUNES', '7:00 AM', '8:00 AM', 'A3'),
	(2, 2, 1, 2, 1, 5, 'LUNES', '8:00 AM', '9:00 AM', 'AE4'),
	(3, 2, 1, 3, 1, 7, 'LUNES', '9:00 AM', '10:00 AM', 'A34'),
	(4, 2, 1, 5, 1, 6, 'MARTES', '8:00 AM', '9:00 AM', 'AT5'),
	(5, 2, 1, 6, 1, 9, 'MIERCOLES', '10:11 AM', '10:12 AM', 'U7'),
	(6, 2, 1, 8, 1, 11, 'MIERCOLES', '10:15 AM', '11:15 AM', 'AE4'),
	(7, 2, 1, 10, 1, 13, 'JUEVES', '12:00 PM', '1:00 PM', 'D54'),
	(8, 2, 1, 12, 1, 15, 'VIERNES', '2:15 PM', '3:15 PM', 'E45'),
	(9, 2, 1, 13, 1, 16, 'VIERNES', '9:15 AM', '11:15 AM', 'W34'),
	(10, 2, 1, 9, 1, 12, 'VIERNES', '7:30 AM', '8:50 AM', 'WR5');
/*!40000 ALTER TABLE `routine` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `salary_option` (
  `salary_optionID` int(11) NOT NULL AUTO_INCREMENT,
  `salary_templateID` int(11) NOT NULL,
  `option_type` int(11) NOT NULL COMMENT 'Allowances =1, Dllowances = 2, Increment = 3',
  `label_name` varchar(128) DEFAULT NULL,
  `label_amount` double NOT NULL,
  PRIMARY KEY (`salary_optionID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `salary_option` DISABLE KEYS */;
INSERT INTO `salary_option` (`salary_optionID`, `salary_templateID`, `option_type`, `label_name`, `label_amount`) VALUES
	(1, 1, 1, 'House Rent', 100),
	(2, 1, 2, 'Fondo de Previsión', 100);
/*!40000 ALTER TABLE `salary_option` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `salary_template` (
  `salary_templateID` int(11) NOT NULL AUTO_INCREMENT,
  `salary_grades` varchar(128) NOT NULL,
  `basic_salary` text NOT NULL,
  `overtime_rate` text NOT NULL,
  PRIMARY KEY (`salary_templateID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `salary_template` DISABLE KEYS */;
INSERT INTO `salary_template` (`salary_templateID`, `salary_grades`, `basic_salary`, `overtime_rate`) VALUES
	(1, 'rrr', '200', '5');
/*!40000 ALTER TABLE `salary_template` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `schoolyear` (
  `schoolyearID` int(11) NOT NULL AUTO_INCREMENT,
  `schooltype` varchar(40) DEFAULT NULL,
  `schoolyear` varchar(128) NOT NULL,
  `schoolyeartitle` varchar(128) DEFAULT NULL,
  `startingdate` date NOT NULL,
  `endingdate` date NOT NULL,
  `semestercode` int(11) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `modify_date` datetime NOT NULL,
  `create_userID` int(11) NOT NULL,
  `create_username` varchar(100) NOT NULL,
  `create_usertype` varchar(100) NOT NULL,
  PRIMARY KEY (`schoolyearID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `schoolyear` DISABLE KEYS */;
INSERT INTO `schoolyear` (`schoolyearID`, `schooltype`, `schoolyear`, `schoolyeartitle`, `startingdate`, `endingdate`, `semestercode`, `create_date`, `modify_date`, `create_userID`, `create_username`, `create_usertype`) VALUES
	(1, 'classbase', '2019-2020', '', '2019-01-01', '2019-12-31', NULL, '2019-01-01 12:35:25', '2019-01-01 12:35:25', 1, 'admin', 'Admin'),
	(2, 'classbase', '2021', '', '2021-01-01', '2021-12-31', NULL, '2019-04-24 11:07:11', '2019-04-24 11:07:55', 1, 'admin', 'Admin');
/*!40000 ALTER TABLE `schoolyear` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `school_sessions` (
  `id` varchar(128) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `school_sessions` DISABLE KEYS */;
INSERT INTO `school_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES
	('k6f0mqnnd99bl5s78al0ckblnau9gpge', '::1', 1556906352, _binary 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),
	('23fcljfk8r6lb800k8mo77icfghafh5u', '::1', 1556906422, _binary 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),
	('0uc58mh1gk00skt4kf37iok66ngpcdce', '::1', 1556906905, _binary 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),
	('sj4ukeec104fljkn2u1b9b2jt0j2iqi0', '::1', 1556907081, _binary 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),
	('e19akeu1f4uf9a3terhcr40vodn3q6vr', '::1', 1556907633, _binary 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),
	('d1bnbrkgq2j8e1oe3i6965ouniq87h1c', '::1', 1556907706, _binary 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),
	('2ufvr2611mepl46r7t4nlre9knrn1e5b', '::1', 1556907863, _binary 0x5F5F63695F6C6173745F726567656E65726174657C693A313535363930373733393B6C616E677C733A373A227370616E697368223B6C6F67696E7573657249447C733A313A2238223B6E616D657C733A31323A22416E6472657320526F6A6173223B656D61696C7C733A31363A22636F7272656F40676D61696C2E636F6D223B757365727479706549447C733A313A2232223B75736572747970657C733A373A22446F63656E7465223B757365726E616D657C733A373A22646F63656E7465223B70686F746F7C733A31313A2264656661756C742E706E67223B64656661756C747363686F6F6C7965617249447C733A313A2231223B76617269667976616C6964757365727C4E3B6C6F67676564696E7C623A313B6765745F7065726D697373696F6E7C623A313B6D61737465725F7065726D697373696F6E5F7365747C613A3336393A7B733A393A2264617368626F617264223B733A333A22796573223B733A373A2273747564656E74223B733A333A22796573223B733A31323A2273747564656E745F76696577223B733A333A22796573223B733A373A22706172656E7473223B733A333A22796573223B733A31323A22706172656E74735F76696577223B733A333A22796573223B733A373A2274656163686572223B733A333A22796573223B733A31323A22746561636865725F76696577223B733A333A22796573223B733A373A227375626A656374223B733A333A22796573223B733A383A2273796C6C61627573223B733A333A22796573223B733A31323A2273796C6C616275735F616464223B733A333A22796573223B733A31333A2273796C6C616275735F65646974223B733A333A22796573223B733A31353A2273796C6C616275735F64656C657465223B733A333A22796573223B733A31303A2261737369676E6D656E74223B733A333A22796573223B733A31343A2261737369676E6D656E745F616464223B733A333A22796573223B733A31353A2261737369676E6D656E745F65646974223B733A333A22796573223B733A31373A2261737369676E6D656E745F64656C657465223B733A333A22796573223B733A31353A2261737369676E6D656E745F76696577223B733A333A22796573223B733A373A22726F7574696E65223B733A333A22796573223B733A31313A2273617474656E64616E6365223B733A333A22796573223B733A31353A2273617474656E64616E63655F616464223B733A333A22796573223B733A31363A2273617474656E64616E63655F76696577223B733A333A22796573223B733A31313A2274617474656E64616E6365223B733A333A22796573223B733A31363A2274617474656E64616E63655F76696577223B733A333A22796573223B733A31313A2275617474656E64616E6365223B733A333A22796573223B733A31363A2275617474656E64616E63655F76696577223B733A333A22796573223B733A31323A226578616D7363686564756C65223B733A333A22796573223B733A31313A2265617474656E64616E6365223B733A333A22796573223B733A31353A2265617474656E64616E63655F616464223B733A333A22796573223B733A343A226D61726B223B733A333A22796573223B733A383A226D61726B5F616464223B733A333A22796573223B733A393A226D61726B5F76696577223B733A333A22796573223B733A31323A22636F6E766572736174696F6E223B733A333A22796573223B733A353A226D65646961223B733A333A22796573223B733A393A226D656469615F616464223B733A333A22796573223B733A31323A226D656469615F64656C657465223B733A333A22796573223B733A31343A227175657374696F6E5F67726F7570223B733A333A22796573223B733A31383A227175657374696F6E5F67726F75705F616464223B733A333A22796573223B733A31393A227175657374696F6E5F67726F75705F65646974223B733A333A22796573223B733A31343A227175657374696F6E5F6C6576656C223B733A333A22796573223B733A31383A227175657374696F6E5F6C6576656C5F616464223B733A333A22796573223B733A31393A227175657374696F6E5F6C6576656C5F65646974223B733A333A22796573223B733A31333A227175657374696F6E5F62616E6B223B733A333A22796573223B733A31373A227175657374696F6E5F62616E6B5F616464223B733A333A22796573223B733A31383A227175657374696F6E5F62616E6B5F65646974223B733A333A22796573223B733A31383A227175657374696F6E5F62616E6B5F76696577223B733A333A22796573223B733A31313A226F6E6C696E655F6578616D223B733A333A22796573223B733A31353A226F6E6C696E655F6578616D5F616464223B733A333A22796573223B733A31363A226F6E6C696E655F6578616D5F65646974223B733A333A22796573223B733A31313A22696E737472756374696F6E223B733A333A22796573223B733A31353A22696E737472756374696F6E5F616464223B733A333A22796573223B733A31363A22696E737472756374696F6E5F65646974223B733A333A22796573223B733A31363A22696E737472756374696F6E5F76696577223B733A333A22796573223B733A31303A226C656176656170706C79223B733A333A22796573223B733A31343A226C656176656170706C795F616464223B733A333A22796573223B733A31353A226C656176656170706C795F65646974223B733A333A22796573223B733A31373A226C656176656170706C795F64656C657465223B733A333A22796573223B733A31353A226C656176656170706C795F76696577223B733A333A22796573223B733A31363A226C656176656170706C69636174696F6E223B733A333A22796573223B733A31303A2261637469766974696573223B733A333A22796573223B733A31343A22616374697669746965735F616464223B733A333A22796573223B733A31373A22616374697669746965735F64656C657465223B733A333A22796573223B733A343A22626F6F6B223B733A333A22796573223B733A363A2265626F6F6B73223B733A333A22796573223B733A31313A2265626F6F6B735F76696577223B733A333A22796573223B733A393A227472616E73706F7274223B733A333A22796573223B733A363A22686F7374656C223B733A333A22796573223B733A383A2263617465676F7279223B733A333A22796573223B733A363A226E6F74696365223B733A333A22796573223B733A31313A226E6F746963655F76696577223B733A333A22796573223B733A353A226576656E74223B733A333A22796573223B733A31303A226576656E745F76696577223B733A333A22796573223B733A373A22686F6C69646179223B733A333A22796573223B733A31323A22686F6C696461795F76696577223B733A333A22796573223B733A31333A2273747564656E747265706F7274223B733A333A22796573223B733A31333A22726F7574696E657265706F7274223B733A333A22796573223B733A31383A226578616D7363686564756C657265706F7274223B733A333A22796573223B733A31363A22617474656E64616E63657265706F7274223B733A333A22796573223B733A32343A22617474656E64616E63656F766572766965777265706F7274223B733A333A22796573223B733A31343A227465726D696E616C7265706F7274223B733A333A22796573223B733A31363A226D6572697473746167657265706F7274223B733A333A22796573223B733A32313A22746162756C6174696F6E73686565747265706F7274223B733A333A22796573223B733A31353A226D61726B73686565747265706F7274223B733A333A22796573223B733A31383A2270726F6772657373636172647265706F7274223B733A333A22796573223B733A31363A226F6E6C696E656578616D7265706F7274223B733A333A22796573223B733A32343A226F6E6C696E656578616D7175657374696F6E7265706F7274223B733A333A22796573223B733A383A22636F6D706C61696E223B733A333A22796573223B733A31323A22636F6D706C61696E5F616464223B733A333A22796573223B733A31333A22636F6D706C61696E5F76696577223B733A333A22796573223B733A31313A2273747564656E745F616464223B733A323A226E6F223B733A31323A2273747564656E745F65646974223B733A323A226E6F223B733A31343A2273747564656E745F64656C657465223B733A323A226E6F223B733A31313A22706172656E74735F616464223B733A323A226E6F223B733A31323A22706172656E74735F65646974223B733A323A226E6F223B733A31343A22706172656E74735F64656C657465223B733A323A226E6F223B733A31313A22746561636865725F616464223B733A323A226E6F223B733A31323A22746561636865725F65646974223B733A323A226E6F223B733A31343A22746561636865725F64656C657465223B733A323A226E6F223B733A343A2275736572223B733A323A226E6F223B733A383A22757365725F616464223B733A323A226E6F223B733A393A22757365725F65646974223B733A323A226E6F223B733A31313A22757365725F64656C657465223B733A323A226E6F223B733A393A22757365725F76696577223B733A323A226E6F223B733A373A22636C6173736573223B733A323A226E6F223B733A31313A22636C61737365735F616464223B733A323A226E6F223B733A31323A22636C61737365735F65646974223B733A323A226E6F223B733A31343A22636C61737365735F64656C657465223B733A323A226E6F223B733A373A2273656374696F6E223B733A323A226E6F223B733A31313A2273656374696F6E5F616464223B733A323A226E6F223B733A31323A2273656374696F6E5F65646974223B733A323A226E6F223B733A31353A2273656D65737465725F64656C657465223B733A323A226E6F223B733A31343A2273656374696F6E5F64656C657465223B733A323A226E6F223B733A31313A227375626A6563745F616464223B733A323A226E6F223B733A31323A227375626A6563745F65646974223B733A323A226E6F223B733A31343A227375626A6563745F64656C657465223B733A323A226E6F223B733A31313A22726F7574696E655F616464223B733A323A226E6F223B733A31323A22726F7574696E655F65646974223B733A323A226E6F223B733A31343A22726F7574696E655F64656C657465223B733A323A226E6F223B733A31353A2274617474656E64616E63655F616464223B733A323A226E6F223B733A31353A2275617474656E64616E63655F616464223B733A323A226E6F223B733A343A226578616D223B733A323A226E6F223B733A383A226578616D5F616464223B733A323A226E6F223B733A393A226578616D5F65646974223B733A323A226E6F223B733A31313A226578616D5F64656C657465223B733A323A226E6F223B733A31363A226578616D7363686564756C655F616464223B733A323A226E6F223B733A31373A226578616D7363686564756C655F65646974223B733A323A226E6F223B733A31393A226578616D7363686564756C655F64656C657465223B733A323A226E6F223B733A353A226772616465223B733A323A226E6F223B733A393A2267726164655F616464223B733A323A226E6F223B733A31303A2267726164655F65646974223B733A323A226E6F223B733A31323A2267726164655F64656C657465223B733A323A226E6F223B733A31343A226D61726B70657263656E74616765223B733A323A226E6F223B733A31383A226D61726B70657263656E746167655F616464223B733A323A226E6F223B733A31393A226D61726B70657263656E746167655F65646974223B733A323A226E6F223B733A32313A226D61726B70657263656E746167655F64656C657465223B733A323A226E6F223B733A393A2270726F6D6F74696F6E223B733A323A226E6F223B733A31303A226D61696C616E64736D73223B733A323A226E6F223B733A31343A226D61696C616E64736D735F616464223B733A323A226E6F223B733A31353A226D61696C616E64736D735F76696577223B733A323A226E6F223B733A32313A227175657374696F6E5F67726F75705F64656C657465223B733A323A226E6F223B733A32313A227175657374696F6E5F6C6576656C5F64656C657465223B733A323A226E6F223B733A32303A227175657374696F6E5F62616E6B5F64656C657465223B733A323A226E6F223B733A31383A226F6E6C696E655F6578616D5F64656C657465223B733A323A226E6F223B733A31383A22696E737472756374696F6E5F64656C657465223B733A323A226E6F223B733A31353A2273616C6172795F74656D706C617465223B733A323A226E6F223B733A31393A2273616C6172795F74656D706C6174655F616464223B733A323A226E6F223B733A32303A2273616C6172795F74656D706C6174655F65646974223B733A323A226E6F223B733A32323A2273616C6172795F74656D706C6174655F64656C657465223B733A323A226E6F223B733A32303A2273616C6172795F74656D706C6174655F76696577223B733A323A226E6F223B733A31353A22686F75726C795F74656D706C617465223B733A323A226E6F223B733A31393A22686F75726C795F74656D706C6174655F616464223B733A323A226E6F223B733A32303A22686F75726C795F74656D706C6174655F65646974223B733A323A226E6F223B733A32323A22686F75726C795F74656D706C6174655F64656C657465223B733A323A226E6F223B733A31333A226D616E6167655F73616C617279223B733A323A226E6F223B733A31373A226D616E6167655F73616C6172795F616464223B733A323A226E6F223B733A31383A226D616E6167655F73616C6172795F65646974223B733A323A226E6F223B733A32303A226D616E6167655F73616C6172795F64656C657465223B733A323A226E6F223B733A31383A226D616E6167655F73616C6172795F76696577223B733A323A226E6F223B733A31323A226D616B655F7061796D656E74223B733A323A226E6F223B733A363A2276656E646F72223B733A323A226E6F223B733A31303A2276656E646F725F616464223B733A323A226E6F223B733A31313A2276656E646F725F65646974223B733A323A226E6F223B733A31333A2276656E646F725F64656C657465223B733A323A226E6F223B733A383A226C6F636174696F6E223B733A323A226E6F223B733A31323A226C6F636174696F6E5F616464223B733A323A226E6F223B733A31333A226C6F636174696F6E5F65646974223B733A323A226E6F223B733A31353A226C6F636174696F6E5F64656C657465223B733A323A226E6F223B733A31343A2261737365745F63617465676F7279223B733A323A226E6F223B733A31383A2261737365745F63617465676F72795F616464223B733A323A226E6F223B733A31393A2261737365745F63617465676F72795F65646974223B733A323A226E6F223B733A32313A2261737365745F63617465676F72795F64656C657465223B733A323A226E6F223B733A353A226173736574223B733A323A226E6F223B733A393A2261737365745F616464223B733A323A226E6F223B733A31303A2261737365745F65646974223B733A323A226E6F223B733A31323A2261737365745F64656C657465223B733A323A226E6F223B733A31303A2261737365745F76696577223B733A323A226E6F223B733A31363A2261737365745F61737369676E6D656E74223B733A323A226E6F223B733A32303A2261737365745F61737369676E6D656E745F616464223B733A323A226E6F223B733A32313A2261737365745F61737369676E6D656E745F65646974223B733A323A226E6F223B733A32333A2261737365745F61737369676E6D656E745F64656C657465223B733A323A226E6F223B733A32313A2261737365745F61737369676E6D656E745F76696577223B733A323A226E6F223B733A383A227075726368617365223B733A323A226E6F223B733A31323A2270757263686173655F616464223B733A323A226E6F223B733A31333A2270757263686173655F65646974223B733A323A226E6F223B733A31353A2270757263686173655F64656C657465223B733A323A226E6F223B733A31353A2270726F6475637463617465676F7279223B733A323A226E6F223B733A31393A2270726F6475637463617465676F72795F616464223B733A323A226E6F223B733A32303A2270726F6475637463617465676F72795F65646974223B733A323A226E6F223B733A32323A2270726F6475637463617465676F72795F64656C657465223B733A323A226E6F223B733A373A2270726F64756374223B733A323A226E6F223B733A31313A2270726F647563745F616464223B733A323A226E6F223B733A31323A2270726F647563745F65646974223B733A323A226E6F223B733A31343A2270726F647563745F64656C657465223B733A323A226E6F223B733A31363A2270726F6475637477617265686F757365223B733A323A226E6F223B733A32303A2270726F6475637477617265686F7573655F616464223B733A323A226E6F223B733A32313A2270726F6475637477617265686F7573655F65646974223B733A323A226E6F223B733A32333A2270726F6475637477617265686F7573655F64656C657465223B733A323A226E6F223B733A31353A2270726F64756374737570706C696572223B733A323A226E6F223B733A31393A2270726F64756374737570706C6965725F616464223B733A323A226E6F223B733A32303A2270726F64756374737570706C6965725F65646974223B733A323A226E6F223B733A32323A2270726F64756374737570706C6965725F64656C657465223B733A323A226E6F223B733A31353A2270726F647563747075726368617365223B733A323A226E6F223B733A31393A2270726F6475637470757263686173655F616464223B733A323A226E6F223B733A32303A2270726F6475637470757263686173655F65646974223B733A323A226E6F223B733A32323A2270726F6475637470757263686173655F64656C657465223B733A323A226E6F223B733A32303A2270726F6475637470757263686173655F76696577223B733A323A226E6F223B733A31313A2270726F6475637473616C65223B733A323A226E6F223B733A31353A2270726F6475637473616C655F616464223B733A323A226E6F223B733A31363A2270726F6475637473616C655F65646974223B733A323A226E6F223B733A31383A2270726F6475637473616C655F64656C657465223B733A323A226E6F223B733A31363A2270726F6475637473616C655F76696577223B733A323A226E6F223B733A31333A226C6561766563617465676F7279223B733A323A226E6F223B733A31373A226C6561766563617465676F72795F616464223B733A323A226E6F223B733A31383A226C6561766563617465676F72795F65646974223B733A323A226E6F223B733A32303A226C6561766563617465676F72795F64656C657465223B733A323A226E6F223B733A31313A226C6561766561737369676E223B733A323A226E6F223B733A31353A226C6561766561737369676E5F616464223B733A323A226E6F223B733A31363A226C6561766561737369676E5F65646974223B733A323A226E6F223B733A31383A226C6561766561737369676E5F64656C657465223B733A323A226E6F223B733A31383A226163746976697469657363617465676F7279223B733A323A226E6F223B733A32323A226163746976697469657363617465676F72795F616464223B733A323A226E6F223B733A32333A226163746976697469657363617465676F72795F65646974223B733A323A226E6F223B733A32353A226163746976697469657363617465676F72795F64656C657465223B733A323A226E6F223B733A393A226368696C6463617265223B733A323A226E6F223B733A31333A226368696C64636172655F616464223B733A323A226E6F223B733A31343A226368696C64636172655F65646974223B733A323A226E6F223B733A31363A226368696C64636172655F64656C657465223B733A323A226E6F223B733A373A226C6D656D626572223B733A323A226E6F223B733A31313A226C6D656D6265725F616464223B733A323A226E6F223B733A31323A226C6D656D6265725F65646974223B733A323A226E6F223B733A31343A226C6D656D6265725F64656C657465223B733A323A226E6F223B733A31323A226C6D656D6265725F76696577223B733A323A226E6F223B733A383A22626F6F6B5F616464223B733A323A226E6F223B733A393A22626F6F6B5F65646974223B733A323A226E6F223B733A31313A22626F6F6B5F64656C657465223B733A323A226E6F223B733A353A226973737565223B733A323A226E6F223B733A393A2269737375655F616464223B733A323A226E6F223B733A31303A2269737375655F65646974223B733A323A226E6F223B733A31303A2269737375655F76696577223B733A323A226E6F223B733A31303A2265626F6F6B735F616464223B733A323A226E6F223B733A31313A2265626F6F6B735F65646974223B733A323A226E6F223B733A31333A2265626F6F6B735F64656C657465223B733A323A226E6F223B733A31333A227472616E73706F72745F616464223B733A323A226E6F223B733A31343A227472616E73706F72745F65646974223B733A323A226E6F223B733A31363A227472616E73706F72745F64656C657465223B733A323A226E6F223B733A373A22746D656D626572223B733A323A226E6F223B733A31313A22746D656D6265725F616464223B733A323A226E6F223B733A31323A22746D656D6265725F65646974223B733A323A226E6F223B733A31343A22746D656D6265725F64656C657465223B733A323A226E6F223B733A31323A22746D656D6265725F76696577223B733A323A226E6F223B733A31303A22686F7374656C5F616464223B733A323A226E6F223B733A31313A22686F7374656C5F65646974223B733A323A226E6F223B733A31333A22686F7374656C5F64656C657465223B733A323A226E6F223B733A31323A2263617465676F72795F616464223B733A323A226E6F223B733A31333A2263617465676F72795F65646974223B733A323A226E6F223B733A31353A2263617465676F72795F64656C657465223B733A323A226E6F223B733A373A22686D656D626572223B733A323A226E6F223B733A31313A22686D656D6265725F616464223B733A323A226E6F223B733A31323A22686D656D6265725F65646974223B733A323A226E6F223B733A31343A22686D656D6265725F64656C657465223B733A323A226E6F223B733A31323A22686D656D6265725F76696577223B733A323A226E6F223B733A383A226665657479706573223B733A323A226E6F223B733A31323A2266656574797065735F616464223B733A323A226E6F223B733A31333A2266656574797065735F65646974223B733A323A226E6F223B733A31353A2266656574797065735F64656C657465223B733A323A226E6F223B733A373A22696E766F696365223B733A323A226E6F223B733A31313A22696E766F6963655F616464223B733A323A226E6F223B733A31323A22696E766F6963655F65646974223B733A323A226E6F223B733A31343A22696E766F6963655F64656C657465223B733A323A226E6F223B733A31323A22696E766F6963655F76696577223B733A323A226E6F223B733A31343A227061796D656E74686973746F7279223B733A323A226E6F223B733A31393A227061796D656E74686973746F72795F65646974223B733A323A226E6F223B733A32313A227061796D656E74686973746F72795F64656C657465223B733A323A226E6F223B733A373A22657870656E7365223B733A323A226E6F223B733A31313A22657870656E73655F616464223B733A323A226E6F223B733A31323A22657870656E73655F65646974223B733A323A226E6F223B733A31343A22657870656E73655F64656C657465223B733A323A226E6F223B733A363A22696E636F6D65223B733A323A226E6F223B733A31303A22696E636F6D655F616464223B733A323A226E6F223B733A31313A22696E636F6D655F65646974223B733A323A226E6F223B733A31333A22696E636F6D655F64656C657465223B733A323A226E6F223B733A31343A22676C6F62616C5F7061796D656E74223B733A323A226E6F223B733A31303A226E6F746963655F616464223B733A323A226E6F223B733A31313A226E6F746963655F65646974223B733A323A226E6F223B733A31333A226E6F746963655F64656C657465223B733A323A226E6F223B733A393A226576656E745F616464223B733A323A226E6F223B733A31303A226576656E745F65646974223B733A323A226E6F223B733A31323A226576656E745F64656C657465223B733A323A226E6F223B733A31313A22686F6C696461795F616464223B733A323A226E6F223B733A31323A22686F6C696461795F65646974223B733A323A226E6F223B733A31343A22686F6C696461795F64656C657465223B733A323A226E6F223B733A31333A22636C61737365737265706F7274223B733A323A226E6F223B733A31323A226964636172647265706F7274223B733A323A226E6F223B733A31353A2261646D6974636172647265706F7274223B733A323A226E6F223B733A31383A226C696272617279626F6F6B737265706F7274223B733A323A226E6F223B733A31373A226C696272617279636172647265706F7274223B733A323A226E6F223B733A32323A226C696272617279626F6F6B69737375657265706F7274223B733A323A226E6F223B733A32313A226F6E6C696E6561646D697373696F6E7265706F7274223B733A323A226E6F223B733A31373A2263657274696669636174657265706F7274223B733A323A226E6F223B733A32323A226C656176656170706C69636174696F6E7265706F7274223B733A323A226E6F223B733A32313A2270726F6475637470757263686173657265706F7274223B733A323A226E6F223B733A31373A2270726F6475637473616C657265706F7274223B733A323A226E6F223B733A32333A227365617263687061796D656E74666565737265706F7274223B733A323A226E6F223B733A31303A22666565737265706F7274223B733A323A226E6F223B733A31333A22647565666565737265706F7274223B733A323A226E6F223B733A31373A2262616C616E6365666565737265706F7274223B733A323A226E6F223B733A31373A227472616E73616374696F6E7265706F7274223B733A323A226E6F223B733A31373A2273747564656E7466696E657265706F7274223B733A323A226E6F223B733A31323A2273616C6172797265706F7274223B733A323A226E6F223B733A31393A226163636F756E746C65646765727265706F7274223B733A323A226E6F223B733A31353A226F6E6C696E6561646D697373696F6E223B733A323A226E6F223B733A31313A2276697369746F72696E666F223B733A323A226E6F223B733A31383A2276697369746F72696E666F5F64656C657465223B733A323A226E6F223B733A31363A2276697369746F72696E666F5F76696577223B733A323A226E6F223B733A31303A227363686F6F6C79656172223B733A323A226E6F223B733A31343A227363686F6F6C796561725F616464223B733A323A226E6F223B733A31353A227363686F6F6C796561725F65646974223B733A323A226E6F223B733A31373A227363686F6F6C796561725F64656C657465223B733A323A226E6F223B733A31323A2273747564656E7467726F7570223B733A323A226E6F223B733A31363A2273747564656E7467726F75705F616464223B733A323A226E6F223B733A31373A2273747564656E7467726F75705F65646974223B733A323A226E6F223B733A31393A2273747564656E7467726F75705F64656C657465223B733A323A226E6F223B733A31333A22636F6D706C61696E5F65646974223B733A323A226E6F223B733A31353A22636F6D706C61696E5F64656C657465223B733A323A226E6F223B733A32303A2263657274696669636174655F74656D706C617465223B733A323A226E6F223B733A32343A2263657274696669636174655F74656D706C6174655F616464223B733A323A226E6F223B733A32353A2263657274696669636174655F74656D706C6174655F65646974223B733A323A226E6F223B733A32373A2263657274696669636174655F74656D706C6174655F64656C657465223B733A323A226E6F223B733A32353A2263657274696669636174655F74656D706C6174655F76696577223B733A323A226E6F223B733A31313A2273797374656D61646D696E223B733A323A226E6F223B733A31353A2273797374656D61646D696E5F616464223B733A323A226E6F223B733A31363A2273797374656D61646D696E5F65646974223B733A323A226E6F223B733A31383A2273797374656D61646D696E5F64656C657465223B733A323A226E6F223B733A31363A2273797374656D61646D696E5F76696577223B733A323A226E6F223B733A31333A22726573657470617373776F7264223B733A323A226E6F223B733A31303A22736F6369616C6C696E6B223B733A323A226E6F223B733A31343A22736F6369616C6C696E6B5F616464223B733A323A226E6F223B733A31353A22736F6369616C6C696E6B5F65646974223B733A323A226E6F223B733A31373A22736F6369616C6C696E6B5F64656C657465223B733A323A226E6F223B733A31383A226D61696C616E64736D7374656D706C617465223B733A323A226E6F223B733A32323A226D61696C616E64736D7374656D706C6174655F616464223B733A323A226E6F223B733A32333A226D61696C616E64736D7374656D706C6174655F65646974223B733A323A226E6F223B733A32353A226D61696C616E64736D7374656D706C6174655F64656C657465223B733A323A226E6F223B733A32333A226D61696C616E64736D7374656D706C6174655F76696577223B733A323A226E6F223B733A31313A2262756C6B696D706F727420223B733A323A226E6F223B733A363A226261636B7570223B733A323A226E6F223B733A383A227573657274797065223B733A323A226E6F223B733A31323A2275736572747970655F616464223B733A323A226E6F223B733A31333A2275736572747970655F65646974223B733A323A226E6F223B733A31353A2275736572747970655F64656C657465223B733A323A226E6F223B733A31303A227065726D697373696F6E223B733A323A226E6F223B733A363A22757064617465223B733A323A226E6F223B733A31363A22706F7374735F63617465676F72696573223B733A323A226E6F223B733A32303A22706F7374735F63617465676F726965735F616464223B733A323A226E6F223B733A32313A22706F7374735F63617465676F726965735F65646974223B733A323A226E6F223B733A32333A22706F7374735F63617465676F726965735F64656C657465223B733A323A226E6F223B733A353A22706F737473223B733A323A226E6F223B733A393A22706F7374735F616464223B733A323A226E6F223B733A31303A22706F7374735F65646974223B733A323A226E6F223B733A31323A22706F7374735F64656C657465223B733A323A226E6F223B733A353A227061676573223B733A323A226E6F223B733A393A2270616765735F616464223B733A323A226E6F223B733A31303A2270616765735F65646974223B733A323A226E6F223B733A31323A2270616765735F64656C657465223B733A323A226E6F223B733A31323A2266726F6E74656E646D656E75223B733A323A226E6F223B733A373A2273657474696E67223B733A323A226E6F223B733A31363A2266726F6E74656E645F73657474696E67223B733A323A226E6F223B733A31353A227061796D656E7473657474696E6773223B733A323A226E6F223B733A31313A22736D7373657474696E6773223B733A323A226E6F223B733A31323A22656D61696C73657474696E67223B733A323A226E6F223B7D),
	('oldlv7vpo3r18pau4oo0u8d7gmsj2hbt', '::1', 1556908046, _binary 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),
	('bgviqois9noaemqr6ptarquamiln7epf', '::1', 1556908221, _binary 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),
	('b0e6gd84qfqhkvva93e9mh5j8dau1eil', '::1', 1556908387, _binary 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),
	('3a70826egfb2qoh41m4v5fhejdmlcfoj', '::1', 1556908368, _binary 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),
	('qhdrvvushl76epu8nff0j9h2amvkjvke', '::1', 1556908662, _binary 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),
	('lnprtjtqvf8mlktqcmij4f3ed9nercmf', '::1', 1556909066, _binary 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),
	('81e4isvnh96gfrhnqgvvded0s1thj9bt', '::1', 1556909481, _binary 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),
	('n4s8ql50lrrjtu1c11hfbvoje40ho0v8', '::1', 1556909580, _binary 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),
	('k33h4s2iom1gm58pt2ist21c9kdm6cta', '::1', 1556909777, _binary 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),
	('fvff3hpest9jsasj772sdocsl7ce1fnj', '::1', 1556909850, _binary 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),
	('5t0qrs6kqnkfr9o5mk232j80b50759pk', '::1', 1556909992, _binary 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),
	('gtf9u9uvoltkms9sptdmp1354b8b3hrg', '::1', 1556910018, _binary 0x5F5F63695F6C6173745F726567656E65726174657C693A313535363931303031373B),
	('vijhmkrk6oh7vi4cmqvpovsln8v3qiqg', '::1', 1556910307, _binary 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),
	('g4ufc4gd13fn81jgu6bptdufpeqh9o8a', '::1', 1556910769, _binary 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),
	('p8ih2ajh3l864qb01peg7q1r010v65sj', '::1', 1556911803, _binary 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),
	('fmm08cin102dg1vq1r7fove3ldnoo1k5', '::1', 1556913142, _binary 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),
	('oebn045a2mpt8ei9s9m2btm1fm0qjua0', '::1', 1556913072, _binary 0x5F5F63695F6C6173745F726567656E65726174657C693A313535363931323936353B),
	('epar5m5i4fttufb033vho3uelg7i510i', '::1', 1556913493, _binary 0x5F5F63695F6C6173745F726567656E65726174657C693A313535363931333236303B),
	('7e7m1a73fddgf82dh9t01tuh6anofhm4', '::1', 1556914047, _binary 0x5F5F63695F6C6173745F726567656E65726174657C693A313535363931333735313B),
	('g2mlb646b4ifdfak3oq71krpirb3oq29', '::1', 1556914414, _binary 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),
	('51dkkrc2e88ics5nu7lo1o4pr99btsl9', '::1', 1556914755, _binary 0x5F5F63695F6C6173745F726567656E65726174657C693A313535363931343530373B),
	('0v2ug6p44jp858ib091bvi4a4iin9i99', '::1', 1556914958, _binary 0x5F5F63695F6C6173745F726567656E65726174657C693A313535363931343935373B),
	('jqtocc2j430rk33bvqa8pv70g7pdn78r', '::1', 1556915100, _binary 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),
	('i80di4an14jgp7gqh94v3qt7ihfr8aqi', '::1', 1556915525, _binary 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),
	('o2tlmp74bqrqhm35earl3jsm23t63p2d', '::1', 1556915912, _binary 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),
	('sg4rq4b9p6eafrvneu3h4ugb7r45im3q', '::1', 1556916202, _binary 0x5F5F63695F6C6173745F726567656E65726174657C693A313535363931353939353B6C616E677C733A373A227370616E697368223B6C6F67696E7573657249447C733A313A2231223B6E616D657C733A353A2261646D696E223B656D61696C7C733A31353A2261646D696E4061646D696E2E636F6D223B757365727479706549447C733A313A2231223B75736572747970657C733A353A2241646D696E223B757365726E616D657C733A353A2261646D696E223B70686F746F7C733A31313A2264656661756C742E706E67223B64656661756C747363686F6F6C7965617249447C733A313A2231223B76617269667976616C6964757365727C4E3B6C6F67676564696E7C623A313B6765745F7065726D697373696F6E7C623A313B6D61737465725F7065726D697373696F6E5F7365747C613A3337303A7B733A393A2264617368626F617264223B733A333A22796573223B733A373A2273747564656E74223B733A333A22796573223B733A31313A2273747564656E745F616464223B733A333A22796573223B733A31323A2273747564656E745F65646974223B733A333A22796573223B733A31343A2273747564656E745F64656C657465223B733A333A22796573223B733A31323A2273747564656E745F76696577223B733A333A22796573223B733A373A22706172656E7473223B733A333A22796573223B733A31313A22706172656E74735F616464223B733A333A22796573223B733A31323A22706172656E74735F65646974223B733A333A22796573223B733A31343A22706172656E74735F64656C657465223B733A333A22796573223B733A31323A22706172656E74735F76696577223B733A333A22796573223B733A373A2274656163686572223B733A333A22796573223B733A31313A22746561636865725F616464223B733A333A22796573223B733A31323A22746561636865725F65646974223B733A333A22796573223B733A31343A22746561636865725F64656C657465223B733A333A22796573223B733A31323A22746561636865725F76696577223B733A333A22796573223B733A343A2275736572223B733A333A22796573223B733A383A22757365725F616464223B733A333A22796573223B733A393A22757365725F65646974223B733A333A22796573223B733A31313A22757365725F64656C657465223B733A333A22796573223B733A393A22757365725F76696577223B733A333A22796573223B733A373A22636C6173736573223B733A333A22796573223B733A31313A22636C61737365735F616464223B733A333A22796573223B733A31323A22636C61737365735F65646974223B733A333A22796573223B733A31343A22636C61737365735F64656C657465223B733A333A22796573223B733A373A2273656374696F6E223B733A333A22796573223B733A31313A2273656374696F6E5F616464223B733A333A22796573223B733A31323A2273656374696F6E5F65646974223B733A333A22796573223B733A31353A2273656D65737465725F64656C657465223B733A333A22796573223B733A31343A2273656374696F6E5F64656C657465223B733A333A22796573223B733A373A227375626A656374223B733A333A22796573223B733A31313A227375626A6563745F616464223B733A333A22796573223B733A31323A227375626A6563745F65646974223B733A333A22796573223B733A31343A227375626A6563745F64656C657465223B733A333A22796573223B733A383A2273796C6C61627573223B733A333A22796573223B733A31323A2273796C6C616275735F616464223B733A333A22796573223B733A31333A2273796C6C616275735F65646974223B733A333A22796573223B733A31353A2273796C6C616275735F64656C657465223B733A333A22796573223B733A31303A2261737369676E6D656E74223B733A333A22796573223B733A31343A2261737369676E6D656E745F616464223B733A333A22796573223B733A31353A2261737369676E6D656E745F65646974223B733A333A22796573223B733A31373A2261737369676E6D656E745F64656C657465223B733A333A22796573223B733A31353A2261737369676E6D656E745F76696577223B733A333A22796573223B733A373A22726F7574696E65223B733A333A22796573223B733A31313A22726F7574696E655F616464223B733A333A22796573223B733A31323A22726F7574696E655F65646974223B733A333A22796573223B733A31343A22726F7574696E655F64656C657465223B733A333A22796573223B733A31313A2273617474656E64616E6365223B733A333A22796573223B733A31353A2273617474656E64616E63655F616464223B733A333A22796573223B733A31363A2273617474656E64616E63655F76696577223B733A333A22796573223B733A31313A2274617474656E64616E6365223B733A333A22796573223B733A31353A2274617474656E64616E63655F616464223B733A333A22796573223B733A31363A2274617474656E64616E63655F76696577223B733A333A22796573223B733A31313A2275617474656E64616E6365223B733A333A22796573223B733A31353A2275617474656E64616E63655F616464223B733A333A22796573223B733A31363A2275617474656E64616E63655F76696577223B733A333A22796573223B733A343A226578616D223B733A333A22796573223B733A383A226578616D5F616464223B733A333A22796573223B733A393A226578616D5F65646974223B733A333A22796573223B733A31313A226578616D5F64656C657465223B733A333A22796573223B733A31323A226578616D7363686564756C65223B733A333A22796573223B733A31363A226578616D7363686564756C655F616464223B733A333A22796573223B733A31373A226578616D7363686564756C655F65646974223B733A333A22796573223B733A31393A226578616D7363686564756C655F64656C657465223B733A333A22796573223B733A353A226772616465223B733A333A22796573223B733A393A2267726164655F616464223B733A333A22796573223B733A31303A2267726164655F65646974223B733A333A22796573223B733A31323A2267726164655F64656C657465223B733A333A22796573223B733A31313A2265617474656E64616E6365223B733A333A22796573223B733A31353A2265617474656E64616E63655F616464223B733A333A22796573223B733A343A226D61726B223B733A333A22796573223B733A383A226D61726B5F616464223B733A333A22796573223B733A393A226D61726B5F76696577223B733A333A22796573223B733A31343A226D61726B70657263656E74616765223B733A333A22796573223B733A31383A226D61726B70657263656E746167655F616464223B733A333A22796573223B733A31393A226D61726B70657263656E746167655F65646974223B733A333A22796573223B733A32313A226D61726B70657263656E746167655F64656C657465223B733A333A22796573223B733A393A2270726F6D6F74696F6E223B733A333A22796573223B733A31323A22636F6E766572736174696F6E223B733A333A22796573223B733A353A226D65646961223B733A333A22796573223B733A393A226D656469615F616464223B733A333A22796573223B733A31323A226D656469615F64656C657465223B733A333A22796573223B733A31303A226D61696C616E64736D73223B733A333A22796573223B733A31343A226D61696C616E64736D735F616464223B733A333A22796573223B733A31353A226D61696C616E64736D735F76696577223B733A333A22796573223B733A31343A227175657374696F6E5F67726F7570223B733A333A22796573223B733A31383A227175657374696F6E5F67726F75705F616464223B733A333A22796573223B733A31393A227175657374696F6E5F67726F75705F65646974223B733A333A22796573223B733A32313A227175657374696F6E5F67726F75705F64656C657465223B733A333A22796573223B733A31343A227175657374696F6E5F6C6576656C223B733A333A22796573223B733A31383A227175657374696F6E5F6C6576656C5F616464223B733A333A22796573223B733A31393A227175657374696F6E5F6C6576656C5F65646974223B733A333A22796573223B733A32313A227175657374696F6E5F6C6576656C5F64656C657465223B733A333A22796573223B733A31333A227175657374696F6E5F62616E6B223B733A333A22796573223B733A31373A227175657374696F6E5F62616E6B5F616464223B733A333A22796573223B733A31383A227175657374696F6E5F62616E6B5F65646974223B733A333A22796573223B733A32303A227175657374696F6E5F62616E6B5F64656C657465223B733A333A22796573223B733A31383A227175657374696F6E5F62616E6B5F76696577223B733A333A22796573223B733A31313A226F6E6C696E655F6578616D223B733A333A22796573223B733A31353A226F6E6C696E655F6578616D5F616464223B733A333A22796573223B733A31363A226F6E6C696E655F6578616D5F65646974223B733A333A22796573223B733A31383A226F6E6C696E655F6578616D5F64656C657465223B733A333A22796573223B733A31313A22696E737472756374696F6E223B733A333A22796573223B733A31353A22696E737472756374696F6E5F616464223B733A333A22796573223B733A31363A22696E737472756374696F6E5F65646974223B733A333A22796573223B733A31383A22696E737472756374696F6E5F64656C657465223B733A333A22796573223B733A31363A22696E737472756374696F6E5F76696577223B733A333A22796573223B733A31353A2273616C6172795F74656D706C617465223B733A333A22796573223B733A31393A2273616C6172795F74656D706C6174655F616464223B733A333A22796573223B733A32303A2273616C6172795F74656D706C6174655F65646974223B733A333A22796573223B733A32323A2273616C6172795F74656D706C6174655F64656C657465223B733A333A22796573223B733A32303A2273616C6172795F74656D706C6174655F76696577223B733A333A22796573223B733A31353A22686F75726C795F74656D706C617465223B733A333A22796573223B733A31393A22686F75726C795F74656D706C6174655F616464223B733A333A22796573223B733A32303A22686F75726C795F74656D706C6174655F65646974223B733A333A22796573223B733A32323A22686F75726C795F74656D706C6174655F64656C657465223B733A333A22796573223B733A31333A226D616E6167655F73616C617279223B733A333A22796573223B733A31373A226D616E6167655F73616C6172795F616464223B733A333A22796573223B733A31383A226D616E6167655F73616C6172795F65646974223B733A333A22796573223B733A32303A226D616E6167655F73616C6172795F64656C657465223B733A333A22796573223B733A31383A226D616E6167655F73616C6172795F76696577223B733A333A22796573223B733A31323A226D616B655F7061796D656E74223B733A333A22796573223B733A363A2276656E646F72223B733A333A22796573223B733A31303A2276656E646F725F616464223B733A333A22796573223B733A31313A2276656E646F725F65646974223B733A333A22796573223B733A31333A2276656E646F725F64656C657465223B733A333A22796573223B733A383A226C6F636174696F6E223B733A333A22796573223B733A31323A226C6F636174696F6E5F616464223B733A333A22796573223B733A31333A226C6F636174696F6E5F65646974223B733A333A22796573223B733A31353A226C6F636174696F6E5F64656C657465223B733A333A22796573223B733A31343A2261737365745F63617465676F7279223B733A333A22796573223B733A31383A2261737365745F63617465676F72795F616464223B733A333A22796573223B733A31393A2261737365745F63617465676F72795F65646974223B733A333A22796573223B733A32313A2261737365745F63617465676F72795F64656C657465223B733A333A22796573223B733A353A226173736574223B733A333A22796573223B733A393A2261737365745F616464223B733A333A22796573223B733A31303A2261737365745F65646974223B733A333A22796573223B733A31323A2261737365745F64656C657465223B733A333A22796573223B733A31303A2261737365745F76696577223B733A333A22796573223B733A31363A2261737365745F61737369676E6D656E74223B733A333A22796573223B733A32303A2261737365745F61737369676E6D656E745F616464223B733A333A22796573223B733A32313A2261737365745F61737369676E6D656E745F65646974223B733A333A22796573223B733A32333A2261737365745F61737369676E6D656E745F64656C657465223B733A333A22796573223B733A32313A2261737365745F61737369676E6D656E745F76696577223B733A333A22796573223B733A383A227075726368617365223B733A333A22796573223B733A31323A2270757263686173655F616464223B733A333A22796573223B733A31333A2270757263686173655F65646974223B733A333A22796573223B733A31353A2270757263686173655F64656C657465223B733A333A22796573223B733A31353A2270726F6475637463617465676F7279223B733A333A22796573223B733A31393A2270726F6475637463617465676F72795F616464223B733A333A22796573223B733A32303A2270726F6475637463617465676F72795F65646974223B733A333A22796573223B733A32323A2270726F6475637463617465676F72795F64656C657465223B733A333A22796573223B733A373A2270726F64756374223B733A333A22796573223B733A31313A2270726F647563745F616464223B733A333A22796573223B733A31323A2270726F647563745F65646974223B733A333A22796573223B733A31343A2270726F647563745F64656C657465223B733A333A22796573223B733A31363A2270726F6475637477617265686F757365223B733A333A22796573223B733A32303A2270726F6475637477617265686F7573655F616464223B733A333A22796573223B733A32313A2270726F6475637477617265686F7573655F65646974223B733A333A22796573223B733A32333A2270726F6475637477617265686F7573655F64656C657465223B733A333A22796573223B733A31353A2270726F64756374737570706C696572223B733A333A22796573223B733A31393A2270726F64756374737570706C6965725F616464223B733A333A22796573223B733A32303A2270726F64756374737570706C6965725F65646974223B733A333A22796573223B733A32323A2270726F64756374737570706C6965725F64656C657465223B733A333A22796573223B733A31353A2270726F647563747075726368617365223B733A333A22796573223B733A31393A2270726F6475637470757263686173655F616464223B733A333A22796573223B733A32303A2270726F6475637470757263686173655F65646974223B733A333A22796573223B733A32323A2270726F6475637470757263686173655F64656C657465223B733A333A22796573223B733A32303A2270726F6475637470757263686173655F76696577223B733A333A22796573223B733A31313A2270726F6475637473616C65223B733A333A22796573223B733A31353A2270726F6475637473616C655F616464223B733A333A22796573223B733A31363A2270726F6475637473616C655F65646974223B733A333A22796573223B733A31383A2270726F6475637473616C655F64656C657465223B733A333A22796573223B733A31363A2270726F6475637473616C655F76696577223B733A333A22796573223B733A31333A226C6561766563617465676F7279223B733A333A22796573223B733A31373A226C6561766563617465676F72795F616464223B733A333A22796573223B733A31383A226C6561766563617465676F72795F65646974223B733A333A22796573223B733A32303A226C6561766563617465676F72795F64656C657465223B733A333A22796573223B733A31313A226C6561766561737369676E223B733A333A22796573223B733A31353A226C6561766561737369676E5F616464223B733A333A22796573223B733A31363A226C6561766561737369676E5F65646974223B733A333A22796573223B733A31383A226C6561766561737369676E5F64656C657465223B733A333A22796573223B733A31303A226C656176656170706C79223B733A333A22796573223B733A31343A226C656176656170706C795F616464223B733A333A22796573223B733A31353A226C656176656170706C795F65646974223B733A333A22796573223B733A31373A226C656176656170706C795F64656C657465223B733A333A22796573223B733A31353A226C656176656170706C795F76696577223B733A333A22796573223B733A31363A226C656176656170706C69636174696F6E223B733A333A22796573223B733A31383A226163746976697469657363617465676F7279223B733A333A22796573223B733A32323A226163746976697469657363617465676F72795F616464223B733A333A22796573223B733A32333A226163746976697469657363617465676F72795F65646974223B733A333A22796573223B733A32353A226163746976697469657363617465676F72795F64656C657465223B733A333A22796573223B733A31303A2261637469766974696573223B733A333A22796573223B733A31343A22616374697669746965735F616464223B733A333A22796573223B733A31373A22616374697669746965735F64656C657465223B733A333A22796573223B733A393A226368696C6463617265223B733A333A22796573223B733A31333A226368696C64636172655F616464223B733A333A22796573223B733A31343A226368696C64636172655F65646974223B733A333A22796573223B733A31363A226368696C64636172655F64656C657465223B733A333A22796573223B733A373A226C6D656D626572223B733A333A22796573223B733A31313A226C6D656D6265725F616464223B733A333A22796573223B733A31323A226C6D656D6265725F65646974223B733A333A22796573223B733A31343A226C6D656D6265725F64656C657465223B733A333A22796573223B733A31323A226C6D656D6265725F76696577223B733A333A22796573223B733A343A22626F6F6B223B733A333A22796573223B733A383A22626F6F6B5F616464223B733A333A22796573223B733A393A22626F6F6B5F65646974223B733A333A22796573223B733A31313A22626F6F6B5F64656C657465223B733A333A22796573223B733A353A226973737565223B733A333A22796573223B733A393A2269737375655F616464223B733A333A22796573223B733A31303A2269737375655F65646974223B733A333A22796573223B733A31303A2269737375655F76696577223B733A333A22796573223B733A363A2265626F6F6B73223B733A333A22796573223B733A31303A2265626F6F6B735F616464223B733A333A22796573223B733A31313A2265626F6F6B735F65646974223B733A333A22796573223B733A31333A2265626F6F6B735F64656C657465223B733A333A22796573223B733A31313A2265626F6F6B735F76696577223B733A333A22796573223B733A393A227472616E73706F7274223B733A333A22796573223B733A31333A227472616E73706F72745F616464223B733A333A22796573223B733A31343A227472616E73706F72745F65646974223B733A333A22796573223B733A31363A227472616E73706F72745F64656C657465223B733A333A22796573223B733A373A22746D656D626572223B733A333A22796573223B733A31313A22746D656D6265725F616464223B733A333A22796573223B733A31323A22746D656D6265725F65646974223B733A333A22796573223B733A31343A22746D656D6265725F64656C657465223B733A333A22796573223B733A31323A22746D656D6265725F76696577223B733A333A22796573223B733A363A22686F7374656C223B733A333A22796573223B733A31303A22686F7374656C5F616464223B733A333A22796573223B733A31313A22686F7374656C5F65646974223B733A333A22796573223B733A31333A22686F7374656C5F64656C657465223B733A333A22796573223B733A383A2263617465676F7279223B733A333A22796573223B733A31323A2263617465676F72795F616464223B733A333A22796573223B733A31333A2263617465676F72795F65646974223B733A333A22796573223B733A31353A2263617465676F72795F64656C657465223B733A333A22796573223B733A373A22686D656D626572223B733A333A22796573223B733A31313A22686D656D6265725F616464223B733A333A22796573223B733A31323A22686D656D6265725F65646974223B733A333A22796573223B733A31343A22686D656D6265725F64656C657465223B733A333A22796573223B733A31323A22686D656D6265725F76696577223B733A333A22796573223B733A383A226665657479706573223B733A333A22796573223B733A31323A2266656574797065735F616464223B733A333A22796573223B733A31333A2266656574797065735F65646974223B733A333A22796573223B733A31353A2266656574797065735F64656C657465223B733A333A22796573223B733A373A22696E766F696365223B733A333A22796573223B733A31313A22696E766F6963655F616464223B733A333A22796573223B733A31323A22696E766F6963655F65646974223B733A333A22796573223B733A31343A22696E766F6963655F64656C657465223B733A333A22796573223B733A31323A22696E766F6963655F76696577223B733A333A22796573223B733A31343A227061796D656E74686973746F7279223B733A333A22796573223B733A31393A227061796D656E74686973746F72795F65646974223B733A333A22796573223B733A32313A227061796D656E74686973746F72795F64656C657465223B733A333A22796573223B733A373A22657870656E7365223B733A333A22796573223B733A31313A22657870656E73655F616464223B733A333A22796573223B733A31323A22657870656E73655F65646974223B733A333A22796573223B733A31343A22657870656E73655F64656C657465223B733A333A22796573223B733A363A22696E636F6D65223B733A333A22796573223B733A31303A22696E636F6D655F616464223B733A333A22796573223B733A31313A22696E636F6D655F65646974223B733A333A22796573223B733A31333A22696E636F6D655F64656C657465223B733A333A22796573223B733A31343A22676C6F62616C5F7061796D656E74223B733A333A22796573223B733A363A226E6F74696365223B733A333A22796573223B733A31303A226E6F746963655F616464223B733A333A22796573223B733A31313A226E6F746963655F65646974223B733A333A22796573223B733A31333A226E6F746963655F64656C657465223B733A333A22796573223B733A31313A226E6F746963655F76696577223B733A333A22796573223B733A353A226576656E74223B733A333A22796573223B733A393A226576656E745F616464223B733A333A22796573223B733A31303A226576656E745F65646974223B733A333A22796573223B733A31323A226576656E745F64656C657465223B733A333A22796573223B733A31303A226576656E745F76696577223B733A333A22796573223B733A373A22686F6C69646179223B733A333A22796573223B733A31313A22686F6C696461795F616464223B733A333A22796573223B733A31323A22686F6C696461795F65646974223B733A333A22796573223B733A31343A22686F6C696461795F64656C657465223B733A333A22796573223B733A31323A22686F6C696461795F76696577223B733A333A22796573223B733A31333A22636C61737365737265706F7274223B733A333A22796573223B733A31333A2273747564656E747265706F7274223B733A333A22796573223B733A31323A226964636172647265706F7274223B733A333A22796573223B733A31353A2261646D6974636172647265706F7274223B733A333A22796573223B733A31333A22726F7574696E657265706F7274223B733A333A22796573223B733A31383A226578616D7363686564756C657265706F7274223B733A333A22796573223B733A31363A22617474656E64616E63657265706F7274223B733A333A22796573223B733A32343A22617474656E64616E63656F766572766965777265706F7274223B733A333A22796573223B733A31383A226C696272617279626F6F6B737265706F7274223B733A333A22796573223B733A31373A226C696272617279636172647265706F7274223B733A333A22796573223B733A32323A226C696272617279626F6F6B69737375657265706F7274223B733A333A22796573223B733A31343A227465726D696E616C7265706F7274223B733A333A22796573223B733A31363A226D6572697473746167657265706F7274223B733A333A22796573223B733A32313A22746162756C6174696F6E73686565747265706F7274223B733A333A22796573223B733A31353A226D61726B73686565747265706F7274223B733A333A22796573223B733A31383A2270726F6772657373636172647265706F7274223B733A333A22796573223B733A31363A226F6E6C696E656578616D7265706F7274223B733A333A22796573223B733A32343A226F6E6C696E656578616D7175657374696F6E7265706F7274223B733A333A22796573223B733A32313A226F6E6C696E6561646D697373696F6E7265706F7274223B733A333A22796573223B733A31373A2263657274696669636174657265706F7274223B733A333A22796573223B733A32323A226C656176656170706C69636174696F6E7265706F7274223B733A333A22796573223B733A32313A2270726F6475637470757263686173657265706F7274223B733A333A22796573223B733A31373A2270726F6475637473616C657265706F7274223B733A333A22796573223B733A32333A227365617263687061796D656E74666565737265706F7274223B733A333A22796573223B733A31303A22666565737265706F7274223B733A333A22796573223B733A31333A22647565666565737265706F7274223B733A333A22796573223B733A31373A2262616C616E6365666565737265706F7274223B733A333A22796573223B733A31373A227472616E73616374696F6E7265706F7274223B733A333A22796573223B733A31373A2273747564656E7466696E657265706F7274223B733A333A22796573223B733A31323A2273616C6172797265706F7274223B733A333A22796573223B733A31393A226163636F756E746C65646765727265706F7274223B733A333A22796573223B733A31353A226F6E6C696E6561646D697373696F6E223B733A333A22796573223B733A31313A2276697369746F72696E666F223B733A333A22796573223B733A31383A2276697369746F72696E666F5F64656C657465223B733A333A22796573223B733A31363A2276697369746F72696E666F5F76696577223B733A333A22796573223B733A31303A227363686F6F6C79656172223B733A333A22796573223B733A31343A227363686F6F6C796561725F616464223B733A333A22796573223B733A31353A227363686F6F6C796561725F65646974223B733A333A22796573223B733A31373A227363686F6F6C796561725F64656C657465223B733A333A22796573223B733A31323A2273747564656E7467726F7570223B733A333A22796573223B733A31363A2273747564656E7467726F75705F616464223B733A333A22796573223B733A31373A2273747564656E7467726F75705F65646974223B733A333A22796573223B733A31393A2273747564656E7467726F75705F64656C657465223B733A333A22796573223B733A383A22636F6D706C61696E223B733A333A22796573223B733A31323A22636F6D706C61696E5F616464223B733A333A22796573223B733A31333A22636F6D706C61696E5F65646974223B733A333A22796573223B733A31353A22636F6D706C61696E5F64656C657465223B733A333A22796573223B733A31333A22636F6D706C61696E5F76696577223B733A333A22796573223B733A32303A2263657274696669636174655F74656D706C617465223B733A333A22796573223B733A32343A2263657274696669636174655F74656D706C6174655F616464223B733A333A22796573223B733A32353A2263657274696669636174655F74656D706C6174655F65646974223B733A333A22796573223B733A32373A2263657274696669636174655F74656D706C6174655F64656C657465223B733A333A22796573223B733A32353A2263657274696669636174655F74656D706C6174655F76696577223B733A333A22796573223B733A31313A2273797374656D61646D696E223B733A333A22796573223B733A31353A2273797374656D61646D696E5F616464223B733A333A22796573223B733A31363A2273797374656D61646D696E5F65646974223B733A333A22796573223B733A31383A2273797374656D61646D696E5F64656C657465223B733A333A22796573223B733A31363A2273797374656D61646D696E5F76696577223B733A333A22796573223B733A31333A22726573657470617373776F7264223B733A333A22796573223B733A31303A22736F6369616C6C696E6B223B733A333A22796573223B733A31343A22736F6369616C6C696E6B5F616464223B733A333A22796573223B733A31353A22736F6369616C6C696E6B5F65646974223B733A333A22796573223B733A31373A22736F6369616C6C696E6B5F64656C657465223B733A333A22796573223B733A31383A226D61696C616E64736D7374656D706C617465223B733A333A22796573223B733A32323A226D61696C616E64736D7374656D706C6174655F616464223B733A333A22796573223B733A32333A226D61696C616E64736D7374656D706C6174655F65646974223B733A333A22796573223B733A32353A226D61696C616E64736D7374656D706C6174655F64656C657465223B733A333A22796573223B733A32333A226D61696C616E64736D7374656D706C6174655F76696577223B733A333A22796573223B733A31303A2262756C6B696D706F7274223B733A333A22796573223B733A363A226261636B7570223B733A333A22796573223B733A383A227573657274797065223B733A333A22796573223B733A31323A2275736572747970655F616464223B733A333A22796573223B733A31333A2275736572747970655F65646974223B733A333A22796573223B733A31353A2275736572747970655F64656C657465223B733A333A22796573223B733A31303A227065726D697373696F6E223B733A333A22796573223B733A363A22757064617465223B733A333A22796573223B733A31363A22706F7374735F63617465676F72696573223B733A333A22796573223B733A32303A22706F7374735F63617465676F726965735F616464223B733A333A22796573223B733A32313A22706F7374735F63617465676F726965735F65646974223B733A333A22796573223B733A32333A22706F7374735F63617465676F726965735F64656C657465223B733A333A22796573223B733A353A22706F737473223B733A333A22796573223B733A393A22706F7374735F616464223B733A333A22796573223B733A31303A22706F7374735F65646974223B733A333A22796573223B733A31323A22706F7374735F64656C657465223B733A333A22796573223B733A353A227061676573223B733A333A22796573223B733A393A2270616765735F616464223B733A333A22796573223B733A31303A2270616765735F65646974223B733A333A22796573223B733A31323A2270616765735F64656C657465223B733A333A22796573223B733A31323A2266726F6E74656E646D656E75223B733A333A22796573223B733A373A2273657474696E67223B733A333A22796573223B733A31363A2266726F6E74656E645F73657474696E67223B733A333A22796573223B733A31353A227061796D656E7473657474696E6773223B733A333A22796573223B733A31313A22736D7373657474696E6773223B733A333A22796573223B733A31323A22656D61696C73657474696E67223B733A333A22796573223B733A393A2274616B655F6578616D223B733A333A22796573223B7D),
	('90ve3l3stln8pb0ec6d5f1ro0nfnn2o4', '::1', 1556916466, _binary 0x5F5F63695F6C6173745F726567656E65726174657C693A313535363931363436333B),
	('vkei5tkn17fmmtdr93m50g4s1jugttqj', '::1', 1556921022, _binary 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),
	('rh4h4s15h400fa0dmebthujeiobt9m0i', '::1', 1556926425, _binary 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),
	('p48d5dtss47gmmf5nvns4trm5v0fu5nc', '::1', 1556977537, _binary 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),
	('f40pqrapbflfand02detru94ugmrdbor', '::1', 1556978076, _binary 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),
	('us2677rcfo5i73rgr0gps803rf7de2k9', '::1', 1556978046, _binary 0x5F5F63695F6C6173745F726567656E65726174657C693A313535363937383030353B),
	('tcaeno513vjtfdu7g653ff0auhq3jc38', '::1', 1556978423, _binary 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),
	('tsdk6nparu8jnq0anee4l0omobgsburi', '::1', 1556978846, _binary 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),
	('f14i1e56nuucf54hu9c06p29o303p61d', '::1', 1556978855, _binary 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